/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.EvaluationCacheKey;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.osgi.service.condpermadmin.Condition;

public class SecurityTable
extends PermissionCollection {
    private final SecurityRow[] rows;
    private final SecurityAdmin securityAdmin;
    private final transient Map<EvaluationCacheKey, Integer> evaluationCache = new ConcurrentHashMap<EvaluationCacheKey, Integer>(10000);

    public SecurityTable(SecurityAdmin securityAdmin, SecurityRow[] rows) {
        if (rows == null) {
            throw new NullPointerException("rows cannot be null!!");
        }
        this.rows = rows;
        this.securityAdmin = securityAdmin;
    }

    boolean isEmpty() {
        return this.rows.length == 0;
    }

    int evaluate(BundlePermissions bundlePermissions, Permission permission) {
        int finalDecision;
        if (bundlePermissions == null) {
            return 4;
        }
        EvaluationCacheKey evaluationCacheKey = new EvaluationCacheKey(bundlePermissions, permission);
        if (this.isEmpty()) {
            this.evaluationCache.put(evaluationCacheKey, 4);
            return 4;
        }
        Integer result = this.evaluationCache.get(evaluationCacheKey);
        boolean hasMutable = false;
        if (result != null) {
            boolean bl = hasMutable = (result & 0x16) == 22;
            if (!hasMutable) {
                return result;
            }
        }
        boolean postponed = false;
        SecurityRow.Decision[] results = new SecurityRow.Decision[this.rows.length];
        int immediateDecisionIdx = -1;
        int i = 0;
        while (i < this.rows.length && immediateDecisionIdx == -1) {
            if (result == null) {
                hasMutable |= this.checkMutable(bundlePermissions, evaluationCacheKey, this.rows[i]);
            }
            try {
                results[i] = this.rows[i].evaluate(bundlePermissions, permission);
            }
            catch (Exception exception) {
                results[i] = SecurityRow.DECISION_ABSTAIN;
            }
            if ((results[i].decision & 4) != 4) {
                if ((results[i].decision & 8) == 8) {
                    postponed = true;
                } else {
                    if (!postponed) {
                        if (!hasMutable) {
                            this.evaluationCache.put(evaluationCacheKey, results[i].decision);
                        }
                        return results[i].decision;
                    }
                    immediateDecisionIdx = i;
                }
            }
            ++i;
        }
        Integer immediateDecision = this.handlePostponedConditions(evaluationCacheKey, hasMutable, postponed, results, immediateDecisionIdx);
        if (immediateDecision != null) {
            return immediateDecision;
        }
        int n = finalDecision = postponed ? 8 : 4;
        if (!hasMutable && (finalDecision & 8) != 8) {
            this.evaluationCache.put(evaluationCacheKey, finalDecision);
        }
        return finalDecision;
    }

    private boolean checkMutable(BundlePermissions bundlePermissions, EvaluationCacheKey evaluationCacheKey, SecurityRow row) {
        Condition[] conditions = row.getConditions(bundlePermissions);
        if (conditions != null) {
            Condition[] conditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (condition != null && condition.isMutable()) {
                    this.evaluationCache.put(evaluationCacheKey, 22);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Integer handlePostponedConditions(EvaluationCacheKey evaluationCacheKey, boolean hasMutable, boolean postponed, SecurityRow.Decision[] results, int immediateDecisionIdx) {
        if (postponed) {
            int immediateDecision = immediateDecisionIdx < 0 ? 2 : results[immediateDecisionIdx].decision;
            boolean allSameDecision = true;
            int i = immediateDecisionIdx < 0 ? results.length - 1 : immediateDecisionIdx - 1;
            while (i >= 0 && allSameDecision) {
                if ((results[i].decision & 8) == 8) {
                    if ((results[i].decision & immediateDecision) == 0) {
                        allSameDecision = false;
                    } else {
                        results[i] = SecurityRow.DECISION_ABSTAIN;
                    }
                }
                --i;
            }
            if (allSameDecision) {
                if (!hasMutable) {
                    this.evaluationCache.put(evaluationCacheKey, immediateDecision);
                }
                return immediateDecision;
            }
            EquinoxSecurityManager equinoxManager = this.securityAdmin.getSupportedSecurityManager();
            if (equinoxManager == null) {
                if (!hasMutable) {
                    this.evaluationCache.put(evaluationCacheKey, 4);
                }
                return 4;
            }
            equinoxManager.addConditionsForDomain(results);
        }
        return null;
    }

    void clearEvaluationCache() {
        this.evaluationCache.clear();
    }

    SecurityRow[] getRows() {
        return this.rows;
    }

    @Override
    public void add(Permission permission) {
        throw new SecurityException();
    }

    @Override
    public Enumeration<Permission> elements() {
        return BundlePermissions.EMPTY_ENUMERATION;
    }

    @Override
    public boolean implies(Permission permission) {
        return (this.evaluate(null, permission) & 1) != 0;
    }
}

