/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.internal.debug.EclipseDebugTrace;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FrameworkDebugOptions
implements DebugOptions,
ServiceTrackerCustomizer<DebugOptionsListener, DebugOptionsListener> {
    private static final Object writeLock = new Object();
    private final Object lock = new Object();
    private Properties options = null;
    private Properties disabledOptions = null;
    protected final Map<String, DebugTrace> debugTraceCache = new HashMap<String, DebugTrace>();
    protected File outFile = null;
    protected boolean verboseDebug = true;
    private boolean newSession = true;
    private final EquinoxConfiguration environmentInfo;
    private volatile BundleContext context;

    public FrameworkDebugOptions(EquinoxConfiguration environmentInfo) {
        URL optionsFile;
        this.environmentInfo = environmentInfo;
        this.verboseDebug = Boolean.valueOf(environmentInfo.getConfiguration("osgi.debug.verbose", Boolean.TRUE.toString()));
        String debugOptionsFilename = environmentInfo.getConfiguration("osgi.debug");
        if (debugOptionsFilename == null) {
            return;
        }
        this.options = new Properties();
        if (debugOptionsFilename.length() == 0) {
            String userDir = System.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
            debugOptionsFilename = new File(userDir, ".options").toString();
        }
        if ((optionsFile = LocationHelper.buildURL(debugOptionsFilename, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            return;
        }
        System.out.print("Debug options:\n    " + optionsFile.toExternalForm());
        try (InputStream input = LocationHelper.getStream(optionsFile);){
            this.options.load(input);
            System.out.println(" loaded");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException e) {
            System.out.println(" did not parse");
            e.printStackTrace(System.out);
        }
        for (Object key : this.options.keySet()) {
            this.options.put(key, ((String)this.options.get(key)).trim());
        }
    }

    @Override
    public boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = this.getOption(option);
        return optionValue != null ? optionValue.equalsIgnoreCase("true") : defaultValue;
    }

    @Override
    public String getOption(String option) {
        return this.getOption(option, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOption(String option, String defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                return this.options.getProperty(option, defaultValue);
            }
        }
        return defaultValue;
    }

    @Override
    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAllOptions() {
        String[] optionsArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                optionsArray = new String[this.options.size()];
                Iterator<Map.Entry<Object, Object>> entrySetIterator = this.options.entrySet().iterator();
                int i = 0;
                while (entrySetIterator.hasNext()) {
                    Map.Entry<Object, Object> entry = entrySetIterator.next();
                    optionsArray[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
                    ++i;
                }
            }
        }
        if (optionsArray == null) {
            optionsArray = new String[1];
        }
        return optionsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDebugEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.options != null;
        }
    }

    @Override
    public final DebugTrace newDebugTrace(String bundleSymbolicName) {
        return this.newDebugTrace(bundleSymbolicName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DebugTrace newDebugTrace(String bundleSymbolicName, Class<?> traceEntryClass) {
        DebugTrace debugTrace = null;
        Map<String, DebugTrace> map = this.debugTraceCache;
        synchronized (map) {
            debugTrace = this.debugTraceCache.get(bundleSymbolicName);
            if (debugTrace == null) {
                debugTrace = new EclipseDebugTrace(bundleSymbolicName, this, traceEntryClass);
                this.debugTraceCache.put(bundleSymbolicName, debugTrace);
            }
        }
        return debugTrace;
    }

    public final File getFile() {
        return this.outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFile(File traceFile) {
        Object object = this.lock;
        synchronized (object) {
            this.outFile = traceFile;
            if (this.outFile != null) {
                this.environmentInfo.setConfiguration("osgi.tracefile", this.outFile.getAbsolutePath());
            } else {
                this.environmentInfo.clearConfiguration("osgi.tracefile");
            }
            this.newSession = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean newSession() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.newSession) break block4;
                this.newSession = false;
                return true;
            }
            return false;
        }
    }

    Object getWriteLock() {
        return writeLock;
    }

    boolean isVerbose() {
        return this.verboseDebug;
    }

    EquinoxConfiguration getConfiguration() {
        return this.environmentInfo;
    }

    @Override
    public DebugOptionsListener addingService(ServiceReference<DebugOptionsListener> reference) {
        DebugOptionsListener listener = this.context.getService(reference);
        listener.optionsChanged(this);
        return listener;
    }

    @Override
    public void modifiedService(ServiceReference<DebugOptionsListener> reference, DebugOptionsListener service) {
    }

    @Override
    public void removedService(ServiceReference<DebugOptionsListener> reference, DebugOptionsListener service) {
        this.context.ungetService(reference);
    }
}

