/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.debug;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.service.debug.DebugTrace;

class EclipseDebugTrace
implements DebugTrace {
    private static final SimpleDateFormat TRACE_FILE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LINE_SEPARATOR;
    private static final SecureAction secureAction;
    private int maxTraceFileSize = 1000;
    private int maxTraceFiles = 10;
    private int backupTraceFileIndex = 0;
    private String traceClass = null;
    private String bundleSymbolicName = null;
    private FrameworkDebugOptions debugOptions = null;
    private final boolean consoleLog;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
        secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    }

    EclipseDebugTrace(String bundleSymbolicName, FrameworkDebugOptions debugOptions, Class<?> traceClass) {
        this.consoleLog = "true".equals(debugOptions.getConfiguration().getConfiguration("eclipse.consoleLog"));
        this.traceClass = traceClass != null ? traceClass.getName() : null;
        this.debugOptions = debugOptions;
        this.bundleSymbolicName = bundleSymbolicName;
        this.readLogProperties();
    }

    private final boolean isDebuggingEnabled(String optionPath) {
        if (optionPath == null) {
            return true;
        }
        boolean debugEnabled = false;
        if (this.debugOptions.isDebugEnabled()) {
            String option = String.valueOf(this.bundleSymbolicName) + optionPath;
            debugEnabled = this.debugOptions.getBooleanOption(option, false);
        }
        return debugEnabled;
    }

    @Override
    public void trace(String optionPath, String message) {
        if (this.isDebuggingEnabled(optionPath)) {
            FrameworkDebugTraceEntry record = new FrameworkDebugTraceEntry(this.bundleSymbolicName, optionPath, message, this.traceClass);
            this.writeRecord(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecord(FrameworkDebugTraceEntry entry) {
        if (entry != null) {
            Object object = this.debugOptions.getWriteLock();
            synchronized (object) {
                block10: {
                    File tracingFile = this.debugOptions.getFile();
                    Writer traceWriter = null;
                    try {
                        try {
                            this.checkTraceFileSize(tracingFile, entry.getTimestamp());
                            traceWriter = this.openWriter(tracingFile);
                            if (this.debugOptions.newSession()) {
                                this.writeSession(traceWriter, entry.getTimestamp());
                            }
                            this.writeMessage(traceWriter, entry);
                            traceWriter.flush();
                        }
                        catch (Exception ex) {
                            System.err.println("An exception occurred while writing to the platform trace file: ");
                            ex.printStackTrace(System.err);
                            this.closeWriter(traceWriter);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeWriter(traceWriter);
                        throw throwable;
                    }
                    this.closeWriter(traceWriter);
                }
            }
        }
    }

    private void readLogProperties() {
        String newMaxLogFiles;
        String newMaxTraceFileSize = this.debugOptions.getConfiguration().getConfiguration("eclipse.trace.size.max");
        if (newMaxTraceFileSize != null) {
            this.maxTraceFileSize = Integer.parseInt(newMaxTraceFileSize);
            if (this.maxTraceFileSize != 0 && this.maxTraceFileSize < 10) {
                this.maxTraceFileSize = 10;
            }
        }
        if ((newMaxLogFiles = this.debugOptions.getConfiguration().getConfiguration("eclipse.trace.backup.max")) != null) {
            this.maxTraceFiles = Integer.parseInt(newMaxLogFiles);
            if (this.maxTraceFiles < 1) {
                this.maxTraceFiles = 10;
            }
        }
    }

    private boolean checkTraceFileSize(File traceFile, long timestamp) {
        boolean isBackupOK = true;
        if (this.maxTraceFileSize > 0 && traceFile != null && traceFile.exists() && traceFile.length() >> 10 > (long)this.maxTraceFileSize) {
            block10: {
                boolean isRenameOK;
                String traceFileName = traceFile.getAbsolutePath();
                String backupFilename = "";
                backupFilename = traceFileName.toLowerCase().endsWith(".trace") ? String.valueOf(traceFileName.substring(0, traceFileName.length() - ".trace".length())) + ".bak_" + this.backupTraceFileIndex + ".trace" : String.valueOf(traceFileName) + ".bak_" + this.backupTraceFileIndex;
                File backupFile = new File(backupFilename);
                if (backupFile.exists() && !backupFile.delete()) {
                    System.err.println("Error when trying to delete old trace file: " + backupFile.getName());
                    if (backupFile.renameTo(new File(String.valueOf(backupFile.getAbsolutePath()) + System.currentTimeMillis()))) {
                        System.err.println("So we rename it to filename: " + backupFile.getName());
                    } else {
                        System.err.println("And we also cannot rename it!");
                        isBackupOK = false;
                    }
                }
                if (!(isRenameOK = traceFile.renameTo(backupFile))) {
                    System.err.println("Error when trying to rename trace file to backup one.");
                    isBackupOK = false;
                }
                Writer traceWriter = null;
                try {
                    try {
                        traceWriter = this.openWriter(traceFile);
                        this.writeComment(traceWriter, "This is a continuation of trace file " + backupFile.getAbsolutePath());
                        this.writeComment(traceWriter, "version: 1.1");
                        this.writeComment(traceWriter, "verbose: " + this.debugOptions.isVerbose());
                        this.writeComment(traceWriter, "Time of creation: " + this.getFormattedDate(timestamp));
                        traceWriter.flush();
                    }
                    catch (IOException ioEx) {
                        ioEx.printStackTrace();
                        this.closeWriter(traceWriter);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.closeWriter(traceWriter);
                    throw throwable;
                }
                this.closeWriter(traceWriter);
            }
            ++this.backupTraceFileIndex;
            this.backupTraceFileIndex %= this.maxTraceFiles;
        }
        return isBackupOK;
    }

    private void writeComment(Writer traceWriter, String comment) throws IOException {
        StringBuilder commentText = new StringBuilder("#");
        commentText.append(" ");
        commentText.append(comment);
        commentText.append(LINE_SEPARATOR);
        traceWriter.write(commentText.toString());
    }

    private final String getFormattedDate(long timestamp) {
        return TRACE_FILE_DATE_FORMATTER.format(new Date(timestamp));
    }

    private final String getFormattedThrowable(Throwable error) {
        String result = null;
        if (error != null) {
            try (PrintStream throwableStream = null;){
                ByteArrayOutputStream throwableByteOutputStream = new ByteArrayOutputStream();
                throwableStream = new PrintStream(throwableByteOutputStream, false);
                error.printStackTrace(throwableStream);
                result = EclipseDebugTrace.encodeText(throwableByteOutputStream.toString());
            }
        }
        return result;
    }

    private void writeSession(Writer traceWriter, long timestamp) throws IOException {
        String[] allOptions;
        this.writeComment(traceWriter, "!SESSION " + this.getFormattedDate(timestamp));
        this.writeComment(traceWriter, "version: 1.1");
        this.writeComment(traceWriter, "verbose: " + this.debugOptions.isVerbose());
        this.writeComment(traceWriter, "The following option strings are specified for this debug session:");
        String[] stringArray = allOptions = this.debugOptions.getAllOptions();
        int n = allOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String allOption = stringArray[n2];
            this.writeComment(traceWriter, "\t" + allOption);
            ++n2;
        }
    }

    private void writeMessage(Writer traceWriter, FrameworkDebugTraceEntry entry) throws IOException {
        StringBuilder message = new StringBuilder("|");
        message.append(" ");
        message.append(EclipseDebugTrace.encodeText(entry.getThreadName()));
        message.append(" ");
        message.append("|");
        message.append(" ");
        message.append(this.getFormattedDate(entry.getTimestamp()));
        message.append(" ");
        message.append("|");
        message.append(" ");
        if (!this.debugOptions.isVerbose()) {
            message.append(EclipseDebugTrace.encodeText(entry.getMessage()));
        } else {
            message.append(entry.getBundleSymbolicName());
            message.append(" ");
            message.append("|");
            message.append(" ");
            message.append(EclipseDebugTrace.encodeText(entry.getOptionPath()));
            message.append(" ");
            message.append("|");
            message.append(" ");
            message.append(entry.getClassName());
            message.append(" ");
            message.append("|");
            message.append(" ");
            message.append(entry.getMethodName());
            message.append(" ");
            message.append("|");
            message.append(" ");
            message.append(entry.getLineNumber());
            message.append(" ");
            message.append("|");
            message.append(" ");
            message.append(EclipseDebugTrace.encodeText(entry.getMessage()));
        }
        if (entry.getThrowable() != null) {
            message.append(" ");
            message.append("|");
            message.append(" ");
            message.append(this.getFormattedThrowable(entry.getThrowable()));
        }
        message.append(" ");
        message.append("|");
        message.append(LINE_SEPARATOR);
        if (traceWriter != null && message != null) {
            traceWriter.write(message.toString());
        }
    }

    private static String encodeText(String inputString) {
        if (inputString == null || inputString.indexOf("|") < 0) {
            return inputString;
        }
        StringBuilder tempBuffer = new StringBuilder(inputString);
        int currentIndex = tempBuffer.indexOf("|");
        while (currentIndex >= 0) {
            tempBuffer.replace(currentIndex, currentIndex + "|".length(), "&#124;");
            currentIndex = tempBuffer.indexOf("|");
        }
        return tempBuffer.toString();
    }

    private Writer logForStream(OutputStream output) {
        return new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    private Writer openWriter(File traceFile) {
        OutputStream out = null;
        if (traceFile != null) {
            try {
                out = secureAction.getFileOutputStream(traceFile, true);
            }
            catch (IOException ioEx) {
                System.err.println("Unable to open trace file: " + traceFile + ": " + ioEx.getMessage());
            }
        }
        if (out == null) {
            out = new FilterOutputStream(System.out){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void write(byte[] var0, int var1, int var2) throws IOException {
                    this.out.write(var0, var1, var2);
                }
            };
        } else if (this.consoleLog) {
            out = new FilterOutputStream(out){

                @Override
                public void write(int b) throws IOException {
                    System.out.write(b);
                    this.out.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    System.out.write(b);
                    this.out.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    System.out.write(b, off, len);
                    this.out.write(b, off, len);
                }
            };
        }
        return this.logForStream(out);
    }

    private void closeWriter(Writer traceWriter) {
        if (traceWriter != null) {
            try {
                traceWriter.close();
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            traceWriter = null;
        }
    }
}

