/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.cds;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osgi.internal.cds.CDSBundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;

public class CDSBundleEntry
extends BundleEntry {
    final String path;
    final byte[] classbytes;
    final CDSBundleFile bundleFile;

    public CDSBundleEntry(String path, byte[] classbytes, CDSBundleFile bundleFile) {
        this.path = path;
        this.classbytes = classbytes;
        this.bundleFile = bundleFile;
    }

    private BundleEntry getWrappedEntry() {
        BundleEntry entry = this.bundleFile.getWrappedEntry(this.path);
        if (entry == null) {
            throw new IllegalStateException("Could not find original entry for the class: " + this.path);
        }
        return entry;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getWrappedEntry().getInputStream();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.classbytes;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public long getSize() {
        return this.getWrappedEntry().getSize();
    }

    @Override
    public long getTime() {
        return this.getWrappedEntry().getTime();
    }
}

