/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.db;

import org.eclipse.jdt.internal.core.nd.db.Chunk;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.jdt.internal.core.nd.db.Package;
import org.eclipse.jdt.internal.core.nd.db.ShortString;

public class LongString
implements IString {
    private final Database db;
    private final long record;
    private int hash;
    private static final int NUM_CHARS1 = (Database.MAX_SINGLE_BLOCK_MALLOC_SIZE - 8) / 2;
    private static final int NUM_CHARSN = (Database.MAX_SINGLE_BLOCK_MALLOC_SIZE - 4) / 2;

    public LongString(Database db, long record) {
        this.db = db;
        this.record = record;
    }

    public LongString(Database db, char[] chars, boolean useBytes) throws IndexException {
        int numChars1 = useBytes ? NUM_CHARS1 * 2 : NUM_CHARS1;
        int numCharsn = useBytes ? NUM_CHARSN * 2 : NUM_CHARSN;
        this.db = db;
        this.record = db.malloc(Database.MAX_SINGLE_BLOCK_MALLOC_SIZE, (short)3);
        int length = chars.length;
        db.putInt(this.record, useBytes ? -length : length);
        Chunk chunk = db.getChunk(this.record);
        if (useBytes) {
            chunk.putCharsAsBytes(this.record + 8L, chars, 0, numChars1);
        } else {
            chunk.putChars(this.record + 8L, chars, 0, numChars1);
        }
        long lastNext = this.record + 4L;
        int start = numChars1;
        while (length - start > numCharsn) {
            long nextRecord = db.malloc(Database.MAX_SINGLE_BLOCK_MALLOC_SIZE, (short)3);
            db.putRecPtr(lastNext, nextRecord);
            chunk = db.getChunk(nextRecord);
            if (useBytes) {
                chunk.putCharsAsBytes(nextRecord + 4L, chars, start, numCharsn);
            } else {
                chunk.putChars(nextRecord + 4L, chars, start, numCharsn);
            }
            start += numCharsn;
            lastNext = nextRecord + 0L;
        }
        int remaining = length - start;
        long nextRecord = db.malloc(4 + (useBytes ? remaining : remaining * 2), (short)3);
        db.putRecPtr(lastNext, nextRecord);
        chunk = db.getChunk(nextRecord);
        if (useBytes) {
            chunk.putCharsAsBytes(nextRecord + 4L, chars, start, remaining);
        } else {
            chunk.putChars(nextRecord + 4L, chars, start, remaining);
        }
    }

    @Override
    public long getRecord() {
        return this.record;
    }

    @Override
    public char[] getChars() throws IndexException {
        int length = this.db.getInt(this.record + 0L);
        boolean useBytes = length < 0;
        int numChars1 = NUM_CHARS1;
        int numCharsn = NUM_CHARSN;
        if (useBytes) {
            length = -length;
            numChars1 *= 2;
            numCharsn *= 2;
        }
        char[] chars = new char[length];
        long p = this.record;
        Chunk chunk = this.db.getChunk(p);
        if (useBytes) {
            chunk.getCharsFromBytes(p + 8L, chars, 0, numChars1);
        } else {
            chunk.getChars(p + 8L, chars, 0, numChars1);
        }
        int start = numChars1;
        p = this.record + 4L;
        while (start < length) {
            p = this.db.getRecPtr(p);
            int partLen = Math.min(length - start, numCharsn);
            chunk = this.db.getChunk(p);
            if (useBytes) {
                chunk.getCharsFromBytes(p + 4L, chars, start, partLen);
            } else {
                chunk.getChars(p + 4L, chars, start, partLen);
            }
            start += partLen;
            p += 0L;
        }
        return chars;
    }

    @Override
    public void delete() throws IndexException {
        int length = this.db.getInt(this.record + 0L);
        boolean useBytes = length < 0;
        int numChars1 = NUM_CHARS1;
        int numCharsn = NUM_CHARSN;
        if (useBytes) {
            length = -length;
            numChars1 *= 2;
            numCharsn *= 2;
        }
        long nextRecord = this.db.getRecPtr(this.record + 4L);
        this.db.free(this.record, (short)3);
        length -= numChars1;
        while (length > numCharsn) {
            length -= numCharsn;
            long nextnext = this.db.getRecPtr(nextRecord + 0L);
            this.db.free(nextRecord, (short)3);
            nextRecord = nextnext;
        }
        this.db.free(nextRecord, (short)3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof LongString) {
                LongString lstr = (LongString)obj;
                if (this.db == lstr.db && this.record == lstr.record) {
                    return true;
                }
                if (this.compare(lstr, true) != 0) return false;
                return true;
            }
            if (obj instanceof char[]) {
                if (this.compare((char[])obj, true) != 0) return false;
                return true;
            }
            if (!(obj instanceof String)) return false;
            if (this.compare((String)obj, true) != 0) return false;
            return true;
        }
        catch (IndexException e) {
            Package.log(e);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            char[] chars = this.getChars();
            int len = chars.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + chars[i];
                ++i;
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    public int compare(IString string, boolean caseSensitive) throws IndexException {
        return ShortString.compare(this.getChars(), string.getChars(), caseSensitive);
    }

    public int compare(String other, boolean caseSensitive) throws IndexException {
        return ShortString.compare(this.getChars(), other.toCharArray(), caseSensitive);
    }

    @Override
    public int compare(char[] other, boolean caseSensitive) throws IndexException {
        return ShortString.compare(this.getChars(), other, caseSensitive);
    }

    @Override
    public int compareCompatibleWithIgnoreCase(IString string) throws IndexException {
        return ShortString.compareCompatibleWithIgnoreCase(this.getChars(), string.getChars());
    }

    @Override
    public int comparePrefix(char[] other, boolean caseSensitive) throws IndexException {
        return ShortString.comparePrefix(this.getChars(), other, caseSensitive);
    }

    @Override
    public String getString() throws IndexException {
        return new String(this.getChars());
    }

    @Override
    public int compareCompatibleWithIgnoreCase(char[] other) throws IndexException {
        return ShortString.compareCompatibleWithIgnoreCase(this.getChars(), other);
    }

    @Override
    public int length() {
        return this.db.getInt(this.record + 0L);
    }
}

