/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;

public class TypeParameter
extends SourceRefElement
implements ITypeParameter {
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    protected String name;

    public TypeParameter(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TypeParameter)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String[] getBounds() throws JavaModelException {
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return CharOperation.toStrings(info.bounds);
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 15;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return ']';
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return new SourceRange(info.nameStart, info.nameEnd - info.nameStart + 1);
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    @Override
    public IClassFile getClassFile() {
        return ((JavaElement)this.getParent()).getClassFile();
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(this.getElementName());
        buffer.append('>');
    }
}

