/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.core.AbstractClassFile;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Disassembler;
import org.eclipse.jdt.internal.core.util.Util;

public class ClassFileWorkingCopy
extends CompilationUnit {
    public AbstractClassFile classFile;

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        if (this.isWorkingCopy()) {
            return super.getBuffer();
        }
        return this.classFile.getBuffer();
    }

    @Override
    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException javaModelException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IPath getPath() {
        return this.classFile.getPath();
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (root.isArchive()) {
            return root.resource(root);
        }
        return this.classFile.resource(root);
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = BufferManager.createBuffer(this);
        IBuffer classFileBuffer = this.classFile.getBuffer();
        if (classFileBuffer != null) {
            buffer.setContents(classFileBuffer.getCharacters());
        } else {
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
            Disassembler disassembler = new Disassembler();
            String contents = disassembler.disassemble(reader, Util.getLineSeparator("", this.getJavaProject()), 16);
            buffer.setContents(contents);
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.classFile.getElementName());
    }
}

