/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.Util;

public final class Signature {
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CAPTURE = "capture-of".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] EXTENDS = "extends".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] SUPER = "super".toCharArray();
    private static final char[] VOID = "void".toCharArray();

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer, false);
    }

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer, boolean isVarArgs) {
        int length = string.length;
        if (start >= length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int index = start;
        c = string[++index];
        while (c == '[') {
            if (index >= length - 1) {
                throw new IllegalArgumentException();
            }
            c = string[++index];
        }
        int e = Signature.appendTypeSignature(string, index, fullyQualifyTypeNames, buffer);
        int i = 1;
        int dims = index - start;
        while (i < dims) {
            buffer.append('[').append(']');
            ++i;
        }
        if (isVarArgs) {
            buffer.append('.').append('.').append('.');
        } else {
            buffer.append('[').append(']');
        }
        return e;
    }

    private static int appendCaptureTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        buffer.append(CAPTURE).append(' ');
        return Signature.appendTypeArgumentSignature(string, start + 1, fullyQualifyTypeNames, buffer);
    }

    private static int appendClassTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        boolean removePackageQualifiers;
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'L' && c != 'Q') {
            throw new IllegalArgumentException();
        }
        boolean resolved = c == 'L';
        boolean bl = removePackageQualifiers = !fullyQualifyTypeNames;
        if (!resolved) {
            removePackageQualifiers = false;
        }
        int p = start + 1;
        int checkpoint = buffer.length();
        int innerTypeStart = -1;
        boolean inAnonymousType = false;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            switch (c) {
                case ';': {
                    return p;
                }
                case '<': {
                    int e = Signature.appendTypeArgumentSignatures(string, p, fullyQualifyTypeNames, buffer);
                    removePackageQualifiers = false;
                    p = e;
                    break;
                }
                case '.': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '/': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('/');
                    break;
                }
                case '$': {
                    innerTypeStart = buffer.length();
                    inAnonymousType = false;
                    if (!resolved) break;
                    removePackageQualifiers = false;
                    buffer.append('.');
                    break;
                }
                default: {
                    if (innerTypeStart != -1 && !inAnonymousType && Character.isDigit(c)) {
                        inAnonymousType = true;
                        buffer.setLength(innerTypeStart);
                        buffer.insert(checkpoint, "new ");
                        buffer.append("(){}");
                    }
                    if (!inAnonymousType) {
                        buffer.append(c);
                    }
                    innerTypeStart = -1;
                }
            }
            ++p;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int appendIntersectionTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        block5: {
            if (start >= string.length - 1) {
                throw new IllegalArgumentException();
            }
            c = string[start];
            if (c != '|') {
                throw new IllegalArgumentException();
            }
            if ((start = Signature.appendClassTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer)) >= string.length - 1) break block5;
            if (string[++start] == ':') ** GOTO lbl17
            throw new IllegalArgumentException("should be a colon at this location");
lbl-1000:
            // 1 sources

            {
                buffer.append(" | ");
                start = Signature.appendClassTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
                if (start == string.length - 1) {
                    return start;
                }
                if (start > string.length - 1) {
                    throw new IllegalArgumentException("Should be at the end");
                }
                ++start;
lbl17:
                // 2 sources

                ** while (string[start] == ':')
            }
        }
        return start;
    }

    private static int appendTypeArgumentSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '*': {
                buffer.append('?');
                return start;
            }
            case '+': {
                buffer.append("? extends ");
                return Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
            }
            case '-': {
                buffer.append("? super ");
                return Signature.appendTypeSignature(string, start + 1, fullyQualifyTypeNames, buffer);
            }
        }
        return Signature.appendTypeSignature(string, start, fullyQualifyTypeNames, buffer);
    }

    private static int appendTypeArgumentSignatures(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        buffer.append('<');
        int p = start + 1;
        int count = 0;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            if (c == '>') {
                buffer.append('>');
                return p;
            }
            if (count != 0) {
                buffer.append(',');
            }
            int e = Signature.appendTypeArgumentSignature(string, p, fullyQualifyTypeNames, buffer);
            ++count;
            p = e + 1;
        }
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        return Signature.appendTypeSignature(string, start, fullyQualifyTypeNames, buffer, false);
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer, boolean isVarArgs) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (isVarArgs) {
            switch (c) {
                case '[': {
                    return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer, true);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (c) {
            case '[': {
                return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'L': 
            case 'Q': {
                return Signature.appendClassTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'T': {
                int e = Util.scanTypeVariableSignature(string, start);
                buffer.append(string, start + 1, e - start - 1);
                return e;
            }
            case 'Z': {
                buffer.append(BOOLEAN);
                return start;
            }
            case 'B': {
                buffer.append(BYTE);
                return start;
            }
            case 'C': {
                buffer.append(CHAR);
                return start;
            }
            case 'D': {
                buffer.append(DOUBLE);
                return start;
            }
            case 'F': {
                buffer.append(FLOAT);
                return start;
            }
            case 'I': {
                buffer.append(INT);
                return start;
            }
            case 'J': {
                buffer.append(LONG);
                return start;
            }
            case 'S': {
                buffer.append(SHORT);
                return start;
            }
            case 'V': {
                buffer.append(VOID);
                return start;
            }
            case '!': {
                return Signature.appendCaptureTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case '|': {
                return Signature.appendIntersectionTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case '*': 
            case '+': 
            case '-': {
                return Signature.appendTypeArgumentSignature(string, start, fullyQualifyTypeNames, buffer);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int checkArrayDimension(char[] typeName, int pos, int length) {
        int genericBalance = 0;
        while (pos < length) {
            switch (typeName[pos]) {
                case '<': {
                    ++genericBalance;
                    break;
                }
                case ',': {
                    if (genericBalance != 0) break;
                    return -1;
                }
                case '>': {
                    if (genericBalance == 0) {
                        return -1;
                    }
                    --genericBalance;
                    break;
                }
                case '[': {
                    if (genericBalance != 0) break;
                    return pos;
                }
            }
            ++pos;
        }
        return -1;
    }

    private static int checkName(char[] name, char[] typeName, int pos, int length) {
        if (CharOperation.fragmentEquals(name, typeName, pos, true)) {
            if ((pos += name.length) == length) {
                return pos;
            }
            char currentChar = typeName[pos];
            switch (currentChar) {
                case ' ': 
                case ',': 
                case '.': 
                case '<': 
                case '>': 
                case '[': {
                    return pos;
                }
            }
            if (ScannerHelper.isWhitespace(currentChar)) {
                return pos;
            }
        }
        return -1;
    }

    private static int checkNextChar(char[] typeName, char expectedChar, int pos, int length, boolean isOptional) {
        if ((pos = Signature.consumeWhitespace(typeName, pos, length)) < length && typeName[pos] == expectedChar) {
            return pos + 1;
        }
        if (!isOptional) {
            throw new IllegalArgumentException(new String(typeName));
        }
        return -1;
    }

    private static int consumeWhitespace(char[] typeName, int pos, int length) {
        while (pos < length) {
            char currentChar = typeName[pos];
            if (currentChar != ' ' && !ScannerHelper.isWhitespace(currentChar)) break;
            ++pos;
        }
        return pos;
    }

    public static char[] createCharArrayTypeSignature(char[] typeName, boolean isResolved) {
        if (typeName == null) {
            throw new IllegalArgumentException("null");
        }
        int length = typeName.length;
        if (length == 0) {
            throw new IllegalArgumentException(new String(typeName));
        }
        StringBuffer buffer = new StringBuffer(5);
        int pos = Signature.encodeTypeSignature(typeName, 0, isResolved, length, buffer);
        if ((pos = Signature.consumeWhitespace(typeName, pos, length)) < length) {
            throw new IllegalArgumentException(new String(typeName));
        }
        length = buffer.length();
        char[] result = new char[length];
        buffer.getChars(0, length, result, 0);
        return result;
    }

    public static String createIntersectionTypeSignature(char[][] typeSignatures) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('|');
        int i = 0;
        int max = typeSignatures.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(':');
            }
            buffer.append(typeSignatures[i]);
            ++i;
        }
        return String.valueOf(buffer);
    }

    private static String createUnionTypeSignature(char[][] typeSignatures) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('&');
        int i = 0;
        int max = typeSignatures.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(':');
            }
            buffer.append(typeSignatures[i]);
            ++i;
        }
        return String.valueOf(buffer);
    }

    public static String createIntersectionTypeSignature(String[] typeSignatures) {
        int typeSignaturesLenth = typeSignatures.length;
        char[][] signatures = new char[typeSignaturesLenth][];
        int i = 0;
        while (i < typeSignaturesLenth) {
            signatures[i] = typeSignatures[i].toCharArray();
            ++i;
        }
        return Signature.createIntersectionTypeSignature(signatures);
    }

    public static String createUnionTypeSignature(String[] typeSignatures) {
        int typeSignaturesLenth = typeSignatures.length;
        char[][] signatures = new char[typeSignaturesLenth][];
        int i = 0;
        while (i < typeSignaturesLenth) {
            signatures[i] = typeSignatures[i].toCharArray();
            ++i;
        }
        return Signature.createUnionTypeSignature(signatures);
    }

    public static char[] createTypeParameterSignature(char[] typeParameterName, char[][] boundSignatures) {
        int length = boundSignatures.length;
        if (length == 0) {
            return CharOperation.append(typeParameterName, ':');
        }
        int boundsSize = 0;
        int i = 0;
        while (i < length) {
            boundsSize += boundSignatures[i].length + 1;
            ++i;
        }
        int nameLength = typeParameterName.length;
        char[] result = new char[nameLength + boundsSize];
        System.arraycopy(typeParameterName, 0, result, 0, nameLength);
        int index = nameLength;
        int i2 = 0;
        while (i2 < length) {
            result[index++] = 58;
            int boundLength = boundSignatures[i2].length;
            System.arraycopy(boundSignatures[i2], 0, result, index, boundLength);
            index += boundLength;
            ++i2;
        }
        return result;
    }

    public static String createTypeSignature(char[] typeName, boolean isResolved) {
        return new String(Signature.createCharArrayTypeSignature(typeName, isResolved));
    }

    public static String createTypeSignature(String typeName, boolean isResolved) {
        return Signature.createTypeSignature(typeName == null ? null : typeName.toCharArray(), isResolved);
    }

    private static int encodeArrayDimension(char[] typeName, int pos, int length, StringBuffer buffer) {
        int checkPos;
        while (pos < length && (checkPos = Signature.checkNextChar(typeName, '[', pos, length, true)) > 0) {
            pos = Signature.checkNextChar(typeName, ']', checkPos, length, false);
            buffer.append('[');
        }
        return pos;
    }

    private static int encodeQualifiedName(char[] typeName, int pos, int length, StringBuffer buffer) {
        int count = 0;
        int lastAppendedChar = 0;
        block4: while (pos < length) {
            int currentChar = typeName[pos];
            switch (currentChar) {
                case 44: 
                case 60: 
                case 62: 
                case 91: {
                    break block4;
                }
                case 46: {
                    buffer.append('.');
                    lastAppendedChar = 46;
                    ++count;
                    break;
                }
                default: {
                    if (currentChar == 32 || ScannerHelper.isWhitespace((char)currentChar)) {
                        if (lastAppendedChar == 46) {
                            pos = Signature.consumeWhitespace(typeName, pos, length) - 1;
                            break;
                        }
                        int checkPos = Signature.checkNextChar(typeName, '.', pos, length, true);
                        if (checkPos <= 0) break block4;
                        buffer.append('.');
                        lastAppendedChar = 46;
                        ++count;
                        pos = checkPos;
                        break;
                    }
                    buffer.append((char)currentChar);
                    lastAppendedChar = currentChar;
                    ++count;
                }
            }
            ++pos;
        }
        if (count == 0) {
            throw new IllegalArgumentException(new String(typeName));
        }
        return pos;
    }

    private static int encodeTypeSignature(char[] typeName, int start, boolean isResolved, int length, StringBuffer buffer) {
        int checkPos;
        int pos = start;
        if ((pos = Signature.consumeWhitespace(typeName, pos, length)) >= length) {
            throw new IllegalArgumentException(new String(typeName));
        }
        char currentChar = typeName[pos];
        switch (currentChar) {
            case 'b': {
                checkPos = Signature.checkName(BOOLEAN, typeName, pos, length);
                if (checkPos > 0) {
                    pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                    buffer.append('Z');
                    return pos;
                }
                checkPos = Signature.checkName(BYTE, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('B');
                return pos;
            }
            case 'd': {
                checkPos = Signature.checkName(DOUBLE, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('D');
                return pos;
            }
            case 'f': {
                checkPos = Signature.checkName(FLOAT, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('F');
                return pos;
            }
            case 'i': {
                checkPos = Signature.checkName(INT, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('I');
                return pos;
            }
            case 'l': {
                checkPos = Signature.checkName(LONG, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('J');
                return pos;
            }
            case 's': {
                checkPos = Signature.checkName(SHORT, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('S');
                return pos;
            }
            case 'v': {
                checkPos = Signature.checkName(VOID, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('V');
                return pos;
            }
            case 'c': {
                checkPos = Signature.checkName(CHAR, typeName, pos, length);
                if (checkPos > 0) {
                    pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                    buffer.append('C');
                    return pos;
                }
                checkPos = Signature.checkName(CAPTURE, typeName, pos, length);
                if (checkPos <= 0 || typeName[pos = Signature.consumeWhitespace(typeName, checkPos, length)] != '?') break;
                buffer.append('!');
            }
            case '?': {
                pos = Signature.consumeWhitespace(typeName, pos + 1, length);
                checkPos = Signature.checkName(EXTENDS, typeName, pos, length);
                if (checkPos > 0) {
                    buffer.append('+');
                    pos = Signature.encodeTypeSignature(typeName, checkPos, isResolved, length, buffer);
                    return pos;
                }
                checkPos = Signature.checkName(SUPER, typeName, pos, length);
                if (checkPos > 0) {
                    buffer.append('-');
                    pos = Signature.encodeTypeSignature(typeName, checkPos, isResolved, length, buffer);
                    return pos;
                }
                buffer.append('*');
                return pos;
            }
        }
        checkPos = Signature.checkArrayDimension(typeName, pos, length);
        int end = checkPos > 0 ? Signature.encodeArrayDimension(typeName, checkPos, length, buffer) : -1;
        buffer.append(isResolved ? (char)'L' : 'Q');
        while (true) {
            if ((checkPos = Signature.checkNextChar(typeName, '<', pos = Signature.encodeQualifiedName(typeName, pos, length, buffer), length, true)) > 0) {
                buffer.append('<');
                pos = Signature.checkNextChar(typeName, '>', checkPos, length, true);
                if (pos > 0) {
                    buffer.append('>');
                } else {
                    pos = Signature.encodeTypeSignature(typeName, checkPos, isResolved, length, buffer);
                    while ((checkPos = Signature.checkNextChar(typeName, ',', pos, length, true)) > 0) {
                        pos = Signature.encodeTypeSignature(typeName, checkPos, isResolved, length, buffer);
                    }
                    pos = Signature.checkNextChar(typeName, '>', pos, length, false);
                    buffer.append('>');
                }
            }
            if ((checkPos = Signature.checkNextChar(typeName, '.', pos, length, true)) <= 0) break;
            buffer.append('.');
            pos = checkPos;
        }
        buffer.append(';');
        if (end > 0) {
            pos = end;
        }
        return pos;
    }

    public static int getParameterCount(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            while (true) {
                if (methodSignature[i] == ')') {
                    return count;
                }
                int e = Util.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                i = e + 1;
                ++count;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static char[][] getParameterTypes(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = Signature.getParameterCount(methodSignature);
            char[][] result = new char[count][];
            if (count == 0) {
                return result;
            }
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            int t = 0;
            while (true) {
                if (methodSignature[i] == ')') {
                    return result;
                }
                int e = Util.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                result[t] = CharOperation.subarray(methodSignature, i, e + 1);
                ++t;
                i = e + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String[] getParameterTypes(String methodSignature) throws IllegalArgumentException {
        char[][] parameterTypes = Signature.getParameterTypes(methodSignature.toCharArray());
        return CharOperation.toStrings(parameterTypes);
    }

    public static char[] getReturnType(char[] methodSignature) throws IllegalArgumentException {
        int paren = CharOperation.lastIndexOf(')', methodSignature);
        if (paren == -1) {
            throw new IllegalArgumentException();
        }
        int last = Util.scanTypeSignature(methodSignature, paren + 1);
        return CharOperation.subarray(methodSignature, paren + 1, last + 1);
    }

    public static String getReturnType(String methodSignature) throws IllegalArgumentException {
        return new String(Signature.getReturnType(methodSignature.toCharArray()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] getSignatureSimpleName(char[] typeSignature) {
        if (typeSignature == null) {
            return CharOperation.NO_CHAR;
        }
        char[] qualifiedType = Signature.toCharArray(typeSignature);
        int dotCount = 0;
        int i = 0;
        block9: while (i < typeSignature.length) {
            switch (typeSignature[i]) {
                case '.': {
                    ++dotCount;
                    break;
                }
                case '<': {
                    break block9;
                }
                case '$': {
                    break block9;
                }
            }
            ++i;
        }
        if (dotCount > 0) {
            int typeStart = 0;
            int i2 = 0;
            while (i2 < qualifiedType.length) {
                switch (qualifiedType[i2]) {
                    case '.': {
                        --dotCount;
                        break;
                    }
                    case ' ': {
                        typeStart = i2 + 1;
                        break;
                    }
                }
                if (dotCount <= 0) {
                    char[] simpleName = CharOperation.subarray(qualifiedType, i2 + 1, qualifiedType.length);
                    if (typeStart > 0 && typeStart < qualifiedType.length) {
                        return CharOperation.concat(CharOperation.subarray(qualifiedType, 0, typeStart), simpleName);
                    }
                    return simpleName;
                }
                ++i2;
            }
        }
        return qualifiedType;
    }

    public static String getSignatureSimpleName(String typeSignature) {
        return new String(Signature.getSignatureSimpleName(typeSignature == null ? null : typeSignature.toCharArray()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[][] getSimpleNames(char[] name) {
        int length;
        int n = length = name == null ? 0 : name.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        block4: while (i < length) {
            switch (name[i]) {
                case '.': {
                    ++wordCount;
                    break;
                }
                case '<': {
                    break block4;
                }
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (name[i2] == '<') break;
            if (name[i2] == '.') {
                split[currentWord] = new char[i2 - last];
                System.arraycopy(name, last, split[currentWord++], 0, i2 - last);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = new char[length - last];
        System.arraycopy(name, last, split[currentWord], 0, length - last);
        return split;
    }

    public static String[] getSimpleNames(String name) {
        return CharOperation.toStrings(Signature.getSimpleNames(name.toCharArray()));
    }

    public static char[] getTypeErasure(char[] parameterizedTypeSignature) throws IllegalArgumentException {
        int end = CharOperation.indexOf('<', parameterizedTypeSignature);
        if (end == -1) {
            return parameterizedTypeSignature;
        }
        int length = parameterizedTypeSignature.length;
        char[] result = new char[length];
        int pos = 0;
        int start = 0;
        int deep = 0;
        int idx = end;
        while (idx < length) {
            switch (parameterizedTypeSignature[idx]) {
                case '<': {
                    if (deep == 0) {
                        int size = idx - start;
                        System.arraycopy(parameterizedTypeSignature, start, result, pos, size);
                        end = idx;
                        pos += size;
                    }
                    ++deep;
                    break;
                }
                case '>': {
                    if (--deep < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (deep != 0) break;
                    start = idx + 1;
                }
            }
            ++idx;
        }
        if (deep > 0) {
            throw new IllegalArgumentException();
        }
        int size = pos + length - start;
        char[] resized = new char[size];
        System.arraycopy(result, 0, resized, 0, pos);
        System.arraycopy(parameterizedTypeSignature, start, resized, pos, length - start);
        return resized;
    }

    public static String getTypeErasure(String parameterizedTypeSignature) throws IllegalArgumentException {
        char[] erasure;
        char[] signature = parameterizedTypeSignature.toCharArray();
        return signature == (erasure = Signature.getTypeErasure(signature)) ? parameterizedTypeSignature : new String(erasure);
    }

    public static char[][] getTypeParameterBounds(char[] formalTypeParameterSignature) throws IllegalArgumentException {
        int p1 = CharOperation.indexOf(':', formalTypeParameterSignature);
        if (p1 < 0) {
            throw new IllegalArgumentException();
        }
        if (p1 == formalTypeParameterSignature.length - 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int p2 = CharOperation.indexOf(':', formalTypeParameterSignature, p1 + 1);
        if (p2 < 0) {
            char[] classBound = CharOperation.subarray(formalTypeParameterSignature, p1 + 1, formalTypeParameterSignature.length);
            return new char[][]{classBound};
        }
        char[] classBound = p2 == p1 + 1 ? null : CharOperation.subarray(formalTypeParameterSignature, p1 + 1, p2);
        char[][] interfaceBounds = CharOperation.splitOn(':', formalTypeParameterSignature, p2 + 1, formalTypeParameterSignature.length);
        if (classBound == null) {
            return interfaceBounds;
        }
        int resultLength = interfaceBounds.length + 1;
        char[][] result = new char[resultLength][];
        result[0] = classBound;
        System.arraycopy(interfaceBounds, 0, result, 1, interfaceBounds.length);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static char[][] getTypeParameters(char[] methodOrTypeSignature) throws IllegalArgumentException {
        try {
            length = methodOrTypeSignature.length;
            if (length == 0) {
                return CharOperation.NO_CHAR_CHAR;
            }
            if (methodOrTypeSignature[0] != '<') {
                return CharOperation.NO_CHAR_CHAR;
            }
            paramList = new ArrayList<char[]>(1);
            paramStart = 1;
            i = 1;
            while (i < length) {
                if (methodOrTypeSignature[i] == '>') {
                    size = paramList.size();
                    if (size == 0) {
                        throw new IllegalArgumentException();
                    }
                    result = new char[size][];
                    paramList.toArray((T[])result);
                    return result;
                }
                if ((i = CharOperation.indexOf(':', methodOrTypeSignature, i)) >= 0 && i < length) ** GOTO lbl53
                throw new IllegalArgumentException();
lbl-1000:
                // 1 sources

                {
                    switch (methodOrTypeSignature[++i]) {
                        case ':': {
                            break;
                        }
                        case '>': {
                            break;
                        }
                        case 'L': {
                            try {
                                i = Util.scanClassTypeSignature(methodOrTypeSignature, i);
                                ++i;
                            }
                            catch (IllegalArgumentException v0) {}
                            continue block19;
                        }
                        case '[': {
                            try {
                                i = Util.scanArrayTypeSignature(methodOrTypeSignature, i);
                                ++i;
                            }
                            catch (IllegalArgumentException v1) {}
                            continue block19;
                        }
                        case 'T': {
                            try {
                                i = Util.scanTypeVariableSignature(methodOrTypeSignature, i);
                                ++i;
                            }
                            catch (IllegalArgumentException v2) {}
                            continue block19;
                        }
                        case '!': {
                            try {
                                i = Util.scanCaptureTypeSignature(methodOrTypeSignature, i);
                                ++i;
                                break;
                            }
                            catch (IllegalArgumentException v3) {}
                        }
                    }
lbl53:
                    // 12 sources

                    ** while (methodOrTypeSignature[i] == ':')
                }
lbl54:
                // 1 sources

                paramList.add(CharOperation.subarray(methodOrTypeSignature, paramStart, i));
                paramStart = i;
            }
        }
        catch (ArrayIndexOutOfBoundsException v4) {}
        throw new IllegalArgumentException();
    }

    public static char[] getTypeVariable(char[] formalTypeParameterSignature) throws IllegalArgumentException {
        int p = CharOperation.indexOf(':', formalTypeParameterSignature);
        if (p < 0) {
            throw new IllegalArgumentException();
        }
        return CharOperation.subarray(formalTypeParameterSignature, 0, p);
    }

    public static String getTypeVariable(String formalTypeParameterSignature) throws IllegalArgumentException {
        return new String(Signature.getTypeVariable(formalTypeParameterSignature.toCharArray()));
    }

    public static char[] toCharArray(char[] signature) throws IllegalArgumentException {
        int sigLength = signature.length;
        if (sigLength == 0) {
            throw new IllegalArgumentException();
        }
        if (signature[0] == '(' || signature[0] == '<') {
            return Signature.toCharArray(signature, CharOperation.NO_CHAR, null, true, true);
        }
        StringBuffer buffer = new StringBuffer(signature.length + 10);
        Signature.appendTypeSignature(signature, 0, true, buffer);
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        return Signature.toCharArray(methodSignature, methodName, parameterNames, fullyQualifyTypeNames, includeReturnType, false);
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType, boolean isVargArgs) {
        int index;
        int firstParen = CharOperation.indexOf('(', methodSignature);
        if (firstParen == -1) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer(methodSignature.length + 10);
        if (includeReturnType) {
            char[] rts = Signature.getReturnType(methodSignature);
            Signature.appendTypeSignature(rts, 0, fullyQualifyTypeNames, buffer);
            buffer.append(' ');
        }
        if (methodName != null) {
            buffer.append(methodName);
        }
        buffer.append('(');
        char[][] pts = Signature.getParameterTypes(methodSignature);
        int max = pts.length;
        int i = index = max - 1;
        while (i >= 0) {
            if (pts[i][0] == '[') break;
            --index;
            --i;
        }
        i = 0;
        while (i < max) {
            if (i == index) {
                Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer, isVargArgs);
            } else {
                Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer);
            }
            if (parameterNames != null) {
                buffer.append(' ');
                buffer.append(parameterNames[i]);
            }
            if (i != pts.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(')');
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    public static String toString(String signature) throws IllegalArgumentException {
        return new String(Signature.toCharArray(signature.toCharArray()));
    }
}

