/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.internal.preferences.legacy.PreferenceForwarder;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public abstract class Plugin
implements BundleActivator {
    private Bundle bundle;
    private boolean debug = false;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    @Deprecated
    private Preferences preferences = null;

    public final ILog getLog() {
        return InternalPlatform.getDefault().getLog(this.getBundle());
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return InternalPlatform.getDefault().getStateLocation(this.getBundle(), true);
    }

    @Deprecated
    public final Preferences getPluginPreferences() {
        Bundle bundleCopy = this.getBundle();
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Plugin preferences already loaded for: " + bundleCopy.getSymbolicName());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("Loading preferences for plugin: " + bundleCopy.getSymbolicName());
        }
        Preferences[] preferencesCopy = new Preferences[1];
        Runnable innerCall = () -> {
            PreferenceForwarder preferenceForwarder = new PreferenceForwarder(this, bundleCopy.getSymbolicName());
        };
        innerCall.run();
        this.preferences = preferencesCopy[0];
        return this.preferences;
    }

    @Deprecated
    public final void savePluginPreferences() {
        Location instance = InternalPlatform.getDefault().getInstanceLocation();
        if (instance == null || !instance.isSet()) {
            return;
        }
        this.getPluginPreferences();
        Preferences preferencesCopy = this.preferences;
        Runnable innerCall = () -> {
            try {
                ((PreferenceForwarder)preferencesCopy).flush();
            }
            catch (BackingStoreException e) {
                Status status = new Status(4, "org.eclipse.core.runtime", 4, Messages.preferences_saveProblems, e);
                RuntimeLog.log(status);
            }
        };
        innerCall.run();
    }

    @Deprecated
    protected void initializeDefaultPluginPreferences() {
    }

    @Deprecated
    public final void internalInitializeDefaultPluginPreferences() {
        this.initializeDefaultPluginPreferences();
    }

    public boolean isDebugging() {
        Bundle debugBundle = this.getBundle();
        if (debugBundle == null) {
            return this.debug;
        }
        String key = String.valueOf(debugBundle.getSymbolicName()) + "/debug";
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return this.debug;
        }
        return debugOptions.isDebugEnabled() ? InternalPlatform.getDefault().getBooleanOption(key, false) : false;
    }

    private DebugOptions getDebugOptions() {
        Bundle debugBundle = this.getBundle();
        if (debugBundle == null) {
            return null;
        }
        if (this.debugTracker == null) {
            BundleContext context = debugBundle.getBundleContext();
            if (context == null) {
                return null;
            }
            this.debugTracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        return this.debugTracker.getService();
    }

    public String toString() {
        Bundle myBundle = this.getBundle();
        if (myBundle == null) {
            return "";
        }
        String name = myBundle.getSymbolicName();
        return name == null ? String.valueOf(myBundle.getBundleId()) : name;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
    }

    public final Bundle getBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof BundleReference) {
            return ((BundleReference)((Object)cl)).getBundle();
        }
        return null;
    }
}

