/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.resources.CheckMissingNaturesListener;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.PlatformURLResourceConnection;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class ResourcesPlugin
extends Plugin {
    public static final Object FAMILY_AUTO_BUILD = new Object();
    public static final Object FAMILY_AUTO_REFRESH = new Object();
    public static final Object FAMILY_MANUAL_BUILD = new Object();
    public static final Object FAMILY_MANUAL_REFRESH = new Object();
    private static ResourcesPlugin plugin;
    private static Workspace workspace;
    private ServiceRegistration<IWorkspace> workspaceRegistration;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private CheckMissingNaturesListener checkMissingNaturesListener;

    static {
        workspace = null;
    }

    private static void constructWorkspace() throws CoreException {
        new LocalMetaArea().createMetaArea();
    }

    public static String getEncoding() {
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        if (enc == null || enc.length() == 0) {
            enc = System.getProperty("file.encoding");
        }
        return enc;
    }

    public static ResourcesPlugin getPlugin() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        if (workspace == null) {
            throw new IllegalStateException(Messages.resources_workspaceClosed);
        }
        return workspace;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.debugRegistration.unregister();
        this.debugRegistration = null;
        if (workspace == null) {
            return;
        }
        workspace.removeResourceChangeListener(this.checkMissingNaturesListener);
        InstanceScope.INSTANCE.getNode("missingNatureMarkerSeverity").removePreferenceChangeListener(this.checkMissingNaturesListener);
        if (this.workspaceRegistration != null) {
            this.workspaceRegistration.unregister();
        }
        ResourcesPlugin.getPlugin().savePluginPreferences();
        workspace.close(null);
        workspace = null;
        this.workspaceRegistration = null;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", "org.eclipse.core.resources");
        this.debugRegistration = context.registerService(DebugOptionsListener.class, Policy.RESOURCES_DEBUG_OPTIONS_LISTENER, properties);
        if (!new LocalMetaArea().hasSavedWorkspace()) {
            ResourcesPlugin.constructWorkspace();
        }
        workspace = new Workspace();
        PlatformURLResourceConnection.startup(workspace.getRoot().getLocation());
        this.initializePreferenceLookupOrder();
        IStatus result = workspace.open(null);
        if (!result.isOK()) {
            this.getLog().log(result);
        }
        this.workspaceRegistration = context.registerService(IWorkspace.class, workspace, null);
        this.checkMissingNaturesListener = new CheckMissingNaturesListener();
        workspace.addResourceChangeListener(this.checkMissingNaturesListener, 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").addPreferenceChangeListener(this.checkMissingNaturesListener);
    }

    private void initializePreferenceLookupOrder() {
        PreferencesService service = PreferencesService.getDefault();
        String[] original = service.getDefaultDefaultLookupOrder();
        ArrayList<String> newOrder = new ArrayList<String>();
        newOrder.add("project");
        newOrder.addAll(Arrays.asList(original));
        service.setDefaultDefaultLookupOrder(newOrder.toArray(new String[newOrder.size()]));
    }
}

