/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class PlatformURLConfigConnection
extends PlatformURLConnection {
    private static boolean isRegistered = false;
    private boolean parentConfiguration;

    @Override
    protected URL resolve() throws IOException {
        File parentFile;
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith("config")) {
            throw new IOException(NLS.bind(CommonMessages.url_badVariant, this.url.toString()));
        }
        String path = spec.substring("config".length() + 1);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        Location localConfig = activator.getConfigurationLocation();
        Location parentConfig = localConfig.getParentLocation();
        URL localURL = new URL(localConfig.getURL(), path);
        if (!"file".equals(localURL.getProtocol()) || parentConfig == null) {
            return localURL;
        }
        File localFile = new File(localURL.getPath());
        if (localFile.exists()) {
            return localURL;
        }
        URL parentURL = new URL(parentConfig.getURL(), path);
        if ("file".equals(parentURL.getProtocol()) && (parentFile = new File(parentURL.getPath())).exists()) {
            this.parentConfiguration = true;
            return parentURL;
        }
        return localURL;
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        PlatformURLHandler.register("config", PlatformURLConfigConnection.class);
        isRegistered = true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        String fileString;
        if (this.parentConfiguration || Activator.getDefault() == null || Activator.getDefault().getConfigurationLocation().isReadOnly()) {
            throw new UnknownServiceException(NLS.bind(CommonMessages.url_noOutput, this.url));
        }
        URL resolved = this.getResolvedURL();
        if (resolved != null && (fileString = resolved.getFile()) != null) {
            File file = new File(fileString);
            String parent = file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            return new FileOutputStream(file);
        }
        return null;
    }
}

