/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.LinkedList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.projectvariables.ProjectLocationVariableResolver;
import org.eclipse.core.internal.resources.projectvariables.WorkspaceLocationVariableResolver;
import org.eclipse.core.internal.resources.projectvariables.WorkspaceParentLocationVariableResolver;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PathVariableUtil {
    public static String getUniqueVariableName(String variable, IResource resource) {
        int index = 1;
        variable = PathVariableUtil.getValidVariableName(variable);
        StringBuilder destVariable = new StringBuilder(variable);
        IPathVariableManager pathVariableManager = resource.getPathVariableManager();
        if (variable.startsWith("PARENT") || variable.startsWith(ProjectLocationVariableResolver.NAME)) {
            destVariable.insert(0, "copy_");
        }
        while (pathVariableManager.isDefined(destVariable.toString())) {
            destVariable.append(index);
            ++index;
        }
        return destVariable.toString();
    }

    public static String getValidVariableName(String variable) {
        char first;
        int argumentIndex = variable.indexOf(45);
        if (argumentIndex != -1) {
            variable = variable.substring(0, argumentIndex);
        }
        if (!Character.isLetter(first = (variable = variable.trim()).charAt(0)) && first != '_') {
            variable = String.valueOf('A') + variable;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < variable.length()) {
            char c = variable.charAt(i);
            if ((Character.isLetter(c) || Character.isDigit(c) || c == '_') && !Character.isWhitespace(c)) {
                builder.append(c);
            }
            ++i;
        }
        variable = builder.toString();
        return variable;
    }

    public static IPath convertToPathRelativeMacro(IPathVariableManager pathVariableManager, IPath originalPath, IResource resource, boolean force, String variableHint) throws CoreException {
        return PathVariableUtil.convertToRelative(pathVariableManager, originalPath, resource, force, variableHint, true, true);
    }

    private static IPath convertToRelative(IPathVariableManager pathVariableManager, IPath originalPath, IResource resource, boolean force, String variableHint, boolean skipWorkspace, boolean generateMacro) throws CoreException {
        String[] existingVariables;
        IPath value;
        if (variableHint != null && pathVariableManager.isDefined(variableHint) && (value = URIUtil.toPath(pathVariableManager.getURIValue(variableHint))) != null) {
            return PathVariableUtil.wrapInProperFormat(PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, resource, force, variableHint, generateMacro), generateMacro);
        }
        IPath path = PathVariableUtil.convertToProperCase(originalPath);
        IPath newPath = null;
        int maxMatchLength = -1;
        String[] stringArray = existingVariables = pathVariableManager.getPathVariableNames();
        int n = existingVariables.length;
        int n2 = 0;
        while (n2 < n) {
            int matchLength;
            IPath value2;
            String variable = stringArray[n2];
            if (!(skipWorkspace && variable.equals(WorkspaceLocationVariableResolver.NAME) || variable.equals(WorkspaceParentLocationVariableResolver.NAME) || variable.equals("PARENT") || (value2 = URIUtil.toPath(pathVariableManager.getURIValue(variable))) == null || !(value2 = PathVariableUtil.convertToProperCase(URIUtil.toPath(pathVariableManager.resolveURI(URIUtil.toURI(value2))))).isPrefixOf(path) || (matchLength = value2.segmentCount()) <= maxMatchLength)) {
                maxMatchLength = matchLength;
                newPath = PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, resource, force, variable, generateMacro);
            }
            ++n2;
        }
        if (newPath != null) {
            return PathVariableUtil.wrapInProperFormat(newPath, generateMacro);
        }
        if (force) {
            int originalSegmentCount = originalPath.segmentCount();
            int j = 0;
            while (j <= originalSegmentCount) {
                IPath matchingPath = path.removeLastSegments(j);
                int minDifference = Integer.MAX_VALUE;
                String[] stringArray2 = existingVariables;
                int n3 = existingVariables.length;
                int n4 = 0;
                while (n4 < n3) {
                    int difference;
                    IPath value3;
                    String variable = stringArray2[n4];
                    if (!(skipWorkspace && variable.equals(WorkspaceLocationVariableResolver.NAME) || variable.equals(WorkspaceParentLocationVariableResolver.NAME) || variable.equals("PARENT") || (value3 = URIUtil.toPath(pathVariableManager.getURIValue(variable))) == null || !matchingPath.isPrefixOf(value3 = PathVariableUtil.convertToProperCase(URIUtil.toPath(pathVariableManager.resolveURI(URIUtil.toURI(value3))))) || (difference = value3.segmentCount() - originalSegmentCount) >= minDifference)) {
                        minDifference = difference;
                        newPath = PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, resource, force, variable, generateMacro);
                    }
                    ++n4;
                }
                if (newPath != null) {
                    return PathVariableUtil.wrapInProperFormat(newPath, generateMacro);
                }
                ++j;
            }
            if (originalSegmentCount == 0) {
                String variable = ProjectLocationVariableResolver.NAME;
                IPath value4 = URIUtil.toPath(pathVariableManager.getURIValue(variable));
                if (originalPath.isPrefixOf(value4 = PathVariableUtil.convertToProperCase(URIUtil.toPath(pathVariableManager.resolveURI(URIUtil.toURI(value4)))))) {
                    newPath = PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, resource, force, variable, generateMacro);
                }
                if (newPath != null) {
                    return PathVariableUtil.wrapInProperFormat(newPath, generateMacro);
                }
            }
        }
        if (skipWorkspace) {
            return PathVariableUtil.convertToRelative(pathVariableManager, originalPath, resource, force, variableHint, false, generateMacro);
        }
        return originalPath;
    }

    private static IPath wrapInProperFormat(IPath newPath, boolean generateMacro) {
        if (generateMacro) {
            newPath = PathVariableUtil.buildVariableMacro(newPath);
        }
        return newPath;
    }

    private static IPath makeRelativeToVariable(IPathVariableManager pathVariableManager, IPath originalPath, IResource resource, boolean force, String variableHint, boolean generateMacro) {
        int matchingFirstSegments;
        IPath path = PathVariableUtil.convertToProperCase(originalPath);
        IPath value = URIUtil.toPath(pathVariableManager.getURIValue(variableHint));
        value = PathVariableUtil.convertToProperCase(URIUtil.toPath(pathVariableManager.resolveURI(URIUtil.toURI(value))));
        int valueSegmentCount = value.segmentCount();
        if (value.isPrefixOf(path)) {
            IPath tmp = Path.fromOSString(variableHint);
            int j = valueSegmentCount;
            while (j < originalPath.segmentCount()) {
                tmp = tmp.append(originalPath.segment(j));
                ++j;
            }
            return tmp;
        }
        if (force && PathVariableUtil.devicesAreCompatible(path, value) && (matchingFirstSegments = path.matchingFirstSegments(value)) >= 0) {
            String originalName = PathVariableUtil.buildParentPathVariable(variableHint, valueSegmentCount - matchingFirstSegments, true);
            IPath tmp = Path.fromOSString(originalName);
            int j = matchingFirstSegments;
            while (j < originalPath.segmentCount()) {
                tmp = tmp.append(originalPath.segment(j));
                ++j;
            }
            return tmp;
        }
        return originalPath;
    }

    private static boolean devicesAreCompatible(IPath path, IPath value) {
        return path.getDevice() != null && value.getDevice() != null ? path.getDevice().equals(value.getDevice()) : path.getDevice() == value.getDevice();
    }

    private static IPath convertToProperCase(IPath path) {
        if (Platform.getOS().equals("win32")) {
            return Path.fromPortableString(path.toPortableString().toLowerCase());
        }
        return path;
    }

    public static boolean isParentVariable(String variableString) {
        return variableString.startsWith("PARENT-");
    }

    public static String buildParentPathVariable(String variable, int difference, boolean generateMacro) {
        String newString = "PARENT-" + difference + "-" + variable;
        if (!generateMacro) {
            newString = "${" + newString + "}";
        }
        return newString;
    }

    public static IPath buildVariableMacro(IPath relativeSrcValue) {
        String variable = relativeSrcValue.segment(0);
        variable = "${" + variable + "}";
        return Path.fromOSString(variable).append(relativeSrcValue.removeFirstSegments(1));
    }

    static String[] splitVariablesAndContent(String value) {
        int index;
        LinkedList<String> result = new LinkedList<String>();
        while ((index = value.indexOf("${")) != -1) {
            int endIndex = PathVariableUtil.getMatchingBrace(value, index);
            if (index > 0) {
                result.add(value.substring(0, index));
            }
            result.add(value.substring(index, endIndex + 1));
            value = value.substring(endIndex + 1);
        }
        if (value.length() > 0) {
            result.add(value);
        }
        return result.toArray(new String[0]);
    }

    static String[] splitVariableNames(String value) {
        int index;
        LinkedList<String> result = new LinkedList<String>();
        while ((index = value.indexOf("${")) != -1) {
            int endIndex = PathVariableUtil.getMatchingBrace(value, index);
            result.add(value.substring(index + 2, endIndex));
            value = value.substring(endIndex + 1);
        }
        return result.toArray(new String[0]);
    }

    static String extractVariable(String segment) {
        int index = segment.indexOf("${");
        if (index != -1) {
            int endIndex = PathVariableUtil.getMatchingBrace(segment, index);
            return segment.substring(index + 2, endIndex);
        }
        return "";
    }

    static int getMatchingBrace(String value, int index) {
        int scope = 0;
        int i = index + 1;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '}') {
                if (scope == 0) {
                    return i;
                }
                --scope;
            }
            if (c == '$' && i + 1 < value.length() && value.charAt(i + 1) == '{') {
                ++scope;
            }
            ++i;
        }
        return value.length();
    }

    public static boolean isPreferred(String variableName) {
        return !variableName.equals(WorkspaceLocationVariableResolver.NAME) && !variableName.equals(WorkspaceParentLocationVariableResolver.NAME) && !variableName.equals("PARENT");
    }
}

