/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local.unix;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.internal.filesystem.FileSystemAccess;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.osgi.util.NLS;

public abstract class UnixFileNatives {
    private static final boolean usingNatives;
    private static final int libattr;

    static {
        boolean _usingNatives = false;
        int _libattr = 0;
        try {
            try {
                System.loadLibrary("unixfile_1_0_0");
                _usingNatives = true;
                UnixFileNatives.initializeStructStatFieldIDs();
                _libattr = UnixFileNatives.libattr();
            }
            catch (UnsatisfiedLinkError e) {
                if (UnixFileNatives.isLibraryPresent()) {
                    UnixFileNatives.logMissingNativeLibrary(e);
                }
                usingNatives = _usingNatives;
                libattr = _libattr;
            }
        }
        finally {
            usingNatives = _usingNatives;
            libattr = _libattr;
        }
    }

    private static boolean isLibraryPresent() {
        String libName = System.mapLibraryName("unixfile_1_0_0");
        Enumeration<URL> entries = FileSystemAccess.findEntries("/", libName, true);
        return entries != null && entries.hasMoreElements();
    }

    private static void logMissingNativeLibrary(UnsatisfiedLinkError e) {
        String libName = System.mapLibraryName("unixfile_1_0_0");
        String message = NLS.bind(Messages.couldNotLoadLibrary, libName);
        Policy.log(1, message, e);
    }

    public static int getSupportedAttributes() {
        if (!usingNatives) {
            return -1;
        }
        int ret = 2143289446;
        if (UnixFileNatives.isSupported(2)) {
            ret |= 0x200000;
        }
        return ret;
    }

    public static boolean isUsingNatives() {
        return usingNatives;
    }

    private static boolean isSupported(int attr) {
        return (libattr & attr) != 0;
    }

    private static final native void initializeStructStatFieldIDs();

    private static final native int libattr();
}

