/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.PerformanceStats;

public class ResourceStats {
    private static PerformanceStats currentStats;
    public static boolean TRACE_BUILDERS;
    public static boolean TRACE_LISTENERS;
    public static boolean TRACE_SAVE_PARTICIPANTS;
    public static boolean TRACE_SNAPSHOT;

    static {
        TRACE_BUILDERS = PerformanceStats.isEnabled("org.eclipse.core.resources/perf/builders");
        TRACE_LISTENERS = PerformanceStats.isEnabled("org.eclipse.core.resources/perf/listeners");
        TRACE_SAVE_PARTICIPANTS = PerformanceStats.isEnabled("org.eclipse.core.resources/perf/save.participants");
        TRACE_SNAPSHOT = PerformanceStats.isEnabled("org.eclipse.core.resources/perf/snapshot");
    }

    public static void endBuild() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void endNotify() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void endSave() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void endSnapshot() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void listenerAdded(IResourceChangeListener listener) {
        if (listener != null) {
            PerformanceStats.getStats("org.eclipse.core.resources/perf/listeners", listener.getClass().getName());
        }
    }

    public static void listenerRemoved(IResourceChangeListener listener) {
        if (listener != null) {
            PerformanceStats.removeStats("org.eclipse.core.resources/perf/listeners", listener.getClass().getName());
        }
    }

    public static void startBuild(IncrementalProjectBuilder builder) {
        currentStats = PerformanceStats.getStats("org.eclipse.core.resources/perf/builders", builder);
        currentStats.startRun(builder.getProject().getName());
    }

    public static void startNotify(IResourceChangeListener listener) {
        currentStats = PerformanceStats.getStats("org.eclipse.core.resources/perf/listeners", listener);
        currentStats.startRun();
    }

    public static void startSnapshot() {
        currentStats = PerformanceStats.getStats("org.eclipse.core.resources/perf/snapshot", ResourcesPlugin.getWorkspace());
        currentStats.startRun();
    }

    public static void startSave(ISaveParticipant participant) {
        currentStats = PerformanceStats.getStats("org.eclipse.core.resources/perf/save.participants", participant);
        currentStats.startRun();
    }
}

