/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class ZipOutputSupplier
implements OutputSupplier {
    private final ZipOutputStream zout;
    private EntryOutStream tempOut;

    public ZipOutputSupplier(File out) throws IOException {
        out = out.getAbsoluteFile();
        if (!out.exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        this.zout = new ZipOutputStream(new FileOutputStream(out));
    }

    public ZipOutputSupplier(ZipOutputStream stream) {
        this.zout = stream;
    }

    @Override
    public void close() throws IOException {
        this.zout.flush();
        this.zout.close();
    }

    @Override
    public OutputStream getOutput(String relPath) {
        if (this.tempOut != null) {
            throw new IllegalStateException("You must close the previous stream before getting a new one!");
        }
        try {
            this.zout.putNextEntry(new ZipEntry(relPath));
        }
        catch (IOException e) {
            return null;
        }
        return new EntryOutStream();
    }

    private class EntryOutStream
    extends OutputStream {
        private EntryOutStream() {
        }

        @Override
        public void write(int paramInt) throws IOException {
            ZipOutputSupplier.this.zout.write(paramInt);
        }

        @Override
        public void close() throws IOException {
            ZipOutputSupplier.this.zout.closeEntry();
        }
    }
}

