/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class FolderSupplier
implements InputSupplier,
OutputSupplier {
    private final File root;

    public FolderSupplier(File root) {
        if (!root.exists()) {
            root.mkdirs();
        }
        this.root = root;
    }

    @Override
    public OutputStream getOutput(String relPath) {
        try {
            File out = new File(this.root, relPath);
            if (!out.exists()) {
                out.getParentFile().mkdirs();
                out.createNewFile();
            }
            return new FileOutputStream(new File(this.root, relPath));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getInput(String relPath) {
        try {
            return new FileInputStream(new File(this.root, relPath));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> gatherAll(String endFilter) {
        LinkedList<String> out = new LinkedList<String>();
        Stack<File> dirStack = new Stack<File>();
        dirStack.push(this.root);
        int rootCut = this.root.getAbsolutePath().length() + 1;
        while (dirStack.size() > 0) {
            for (File f : ((File)dirStack.pop()).listFiles()) {
                if (f.isDirectory()) {
                    dirStack.push(f);
                    continue;
                }
                if (!f.getPath().endsWith(endFilter)) continue;
                out.add(f.getAbsolutePath().substring(rootCut));
            }
        }
        return out;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getRoot(String resource) {
        return this.root.getAbsolutePath();
    }
}

