/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.srg2source.util.io.InputSupplier;

public class ChainedInputSupplier
implements InputSupplier {
    private List<InputSupplier> children;

    public ChainedInputSupplier(InputSupplier ... children) {
        this.children = Arrays.asList(children);
    }

    public ChainedInputSupplier(Collection<InputSupplier> children) {
        this.children = new ArrayList<InputSupplier>(children);
    }

    @Override
    public void close() throws IOException {
        for (InputSupplier child : this.children) {
            child.close();
        }
    }

    @Override
    public String getRoot(String resource) {
        InputSupplier child;
        String ret = null;
        Iterator<InputSupplier> iterator = this.children.iterator();
        while (iterator.hasNext() && (ret = (child = iterator.next()).getRoot(resource)) == null) {
        }
        return ret;
    }

    @Override
    public InputStream getInput(String resource) {
        InputSupplier child;
        InputStream ret = null;
        Iterator<InputSupplier> iterator = this.children.iterator();
        while (iterator.hasNext() && (ret = (child = iterator.next()).getInput(resource)) == null) {
        }
        return ret;
    }

    @Override
    public List<String> gatherAll(String endFilter) {
        HashSet ret = new HashSet();
        this.children.forEach(c -> ret.addAll(c.gatherAll(endFilter)));
        return ret.stream().collect(Collectors.toList());
    }

    @Override
    public Charset getEncoding(String resource) {
        InputSupplier child;
        Charset ret = null;
        Iterator<InputSupplier> iterator = this.children.iterator();
        while (iterator.hasNext() && (ret = (child = iterator.next()).getEncoding(resource)) == null) {
        }
        return ret;
    }
}

