/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util;

import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class Util {
    private static final Pattern SIG_REGEX = Pattern.compile("L([^;]+);");

    public static HashMap<String, List<String>> remapParameterMap(Map<String, List<String>> paramMap, Map<String, String> methodMap, Map<String, String> methodSigMap, Map<String, String> classMap, boolean keepMissing) {
        HashMap<String, List<String>> newParamMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : paramMap.entrySet()) {
            String newMethodSig;
            String newFullMethodName;
            String className;
            String[] split;
            if (e.getKey().contains("<init>")) {
                split = e.getKey().split(" ");
                String newClassName = className = Util.splitPackageName(split[0]);
                if (!classMap.containsKey(className)) {
                    if (!keepMissing) {
                        continue;
                    }
                } else {
                    newClassName = classMap.get(className);
                }
                newFullMethodName = newClassName + "/" + Util.splitBaseName(newClassName);
                newMethodSig = Util.remapSig(split[1], classMap);
            } else if (!methodMap.containsKey(e.getKey())) {
                if (!keepMissing) continue;
                split = e.getKey().split(" ");
                className = Util.splitPackageName(split[0]);
                newFullMethodName = className + "/" + Util.splitBaseName(split[0]);
                newMethodSig = Util.remapSig(split[1], classMap);
            } else {
                newFullMethodName = methodMap.get(e.getKey());
                newMethodSig = methodSigMap.get(e.getKey());
            }
            newParamMap.put(newFullMethodName + " " + newMethodSig, e.getValue());
        }
        return newParamMap;
    }

    public static String remapSig(String sig, Map<String, String> classMap) {
        StringBuffer buffer = new StringBuffer(sig.length());
        Matcher matcher = SIG_REGEX.matcher(sig);
        while (matcher.find()) {
            String className = matcher.group(1);
            String repl = "L" + (classMap.containsKey(className) ? classMap.get(className) : className) + ";";
            int idx = repl.lastIndexOf(36);
            if (repl.indexOf(36) != -1) {
                String ending = repl.substring(idx + 1, repl.length() - 1);
                repl = ending.matches("\\d+") ? "Ljava/lang/Object;" : repl.replace("$", "\\$");
            }
            matcher.appendReplacement(buffer, repl);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static Map<String, String> readDescriptiveParameterNames(File mcpConfDir) {
        return Util.readCSVMap(new File(mcpConfDir, "params.csv"));
    }

    public static Map<String, String> readDescriptiveMethodNames(File mcpConfDir) {
        return Util.readCSVMap(new File(mcpConfDir, "methods.csv"));
    }

    public static Map<String, String> readClassPackageMap(File mcpConfDir) {
        return Util.readCSVMap(new File(mcpConfDir, "methods.csv"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> readCSVMap(File file) {
        try (FileReader reader = new FileReader(file);){
            HashMap<String, String> map = new HashMap<String, String>();
            CsvReader csv = new CsvReader();
            csv.setContainsHeader(true);
            for (CsvRow row : csv.read(reader).getRows()) {
                map.put(row.getField(0), row.getField(1));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    public static String splitBaseName(String className) {
        if (className == null) {
            return null;
        }
        return className.substring(className.lastIndexOf(47) + 1);
    }

    public static String splitBaseName(String qualName, int num) {
        int c = 46;
        int index = qualName.lastIndexOf(c);
        while (index >= 0 && num > 0) {
            index = qualName.lastIndexOf(c, index - 1);
            --num;
        }
        if (index < 0) {
            return qualName;
        }
        return qualName.substring(index + 1);
    }

    public static String splitPackageName(String className) {
        if (className == null) {
            return null;
        }
        int index = className.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    public static String internalName2Source(String internalName) {
        if (internalName == null) {
            return null;
        }
        return internalName.replace('/', '.');
    }

    public static int countChar(String str, char c) {
        int index = str.indexOf(c);
        int num = 0;
        while (index >= 0) {
            ++num;
            index = str.indexOf(c, index + 1);
        }
        return num;
    }

    public static String sourceName2Internal(String sourceName) {
        return Util.sourceName2Internal(sourceName, true);
    }

    public static String sourceName2Internal(String sourceName, boolean inner) {
        if (sourceName == null) {
            return null;
        }
        if (inner) {
            return sourceName.replace('.', '/').replace('$', '/');
        }
        return sourceName.replace('.', '/');
    }

    public static String getTopLevelClassForFilename(String filename) {
        if (filename.startsWith("/") || filename.startsWith("\\")) {
            filename = filename.substring(1);
        }
        return filename.replace("." + Util.getFileExtension(filename), "").replace('\\', '/');
    }

    public static String[] gatherFiles(String path, String filter, boolean relative) {
        ArrayList<String> names = new ArrayList<String>();
        for (File f : new File(path).listFiles()) {
            if (f.isDirectory()) {
                if (relative) {
                    names.addAll(Util.gatherFiles(f.getAbsolutePath(), path.length() + 1, filter));
                    continue;
                }
                names.addAll(Arrays.asList(Util.gatherFiles(f.getAbsolutePath(), filter, relative)));
                continue;
            }
            if (!f.getName().endsWith(filter)) continue;
            if (relative) {
                names.add(f.getAbsolutePath().substring(path.length() + 1).replace('\\', '/'));
                continue;
            }
            names.add(f.getAbsolutePath().replace('\\', '/'));
        }
        return names.toArray(new String[names.size()]);
    }

    private static List<String> gatherFiles(String path, int cut, String filter) {
        ArrayList<String> names = new ArrayList<String>();
        for (File f : new File(path).listFiles()) {
            if (f.isDirectory()) {
                names.addAll(Util.gatherFiles(f.getPath(), cut, filter));
                continue;
            }
            if (!f.getName().endsWith(filter)) continue;
            names.add(f.getAbsolutePath().substring(cut).replace('\\', '/'));
        }
        return names;
    }

    public static ASTParser createParser(String javaVersion, String srcRoot, String[] libs) {
        ASTParser parser = ASTParser.newParser(10);
        parser.setEnvironment(libs, new String[]{srcRoot}, null, true);
        return Util.setOptions(parser, javaVersion);
    }

    public static ASTParser createParser(String javaVersion, String[] libs) {
        ASTParser parser = ASTParser.newParser(10);
        parser.setEnvironment(libs, null, null, true);
        return Util.setOptions(parser, javaVersion);
    }

    private static ASTParser setOptions(ASTParser parser, String javaVersion) {
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable<String, String> options = JavaCore.getDefaultOptions();
        JavaCore.setComplianceOptions(javaVersion, options);
        parser.setCompilerOptions(options);
        return parser;
    }

    public static CompilationUnit createUnit(ASTParser parser, String javaVersion, String name, char[] data) throws Exception {
        parser.setUnitName(name);
        parser.setSource(data);
        return (CompilationUnit)parser.createAST(null);
    }

    public static void transferTo(InputStream input, OutputStream output) throws IOException {
        int cnt;
        byte[] buf = new byte[1024];
        while ((cnt = input.read(buf)) > 0) {
            output.write(buf, 0, cnt);
        }
    }

    public static byte[] readStream(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Util.transferTo(input, output);
        return output.toByteArray();
    }

    public static byte[] readFile(File input) throws IOException {
        try (FileInputStream stream = new FileInputStream(input);){
            byte[] byArray = Util.readStream(stream);
            return byArray;
        }
    }

    public static String md5(String data, Charset encoding) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data.getBytes(encoding));
            return Util.hex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hex(byte[] data) {
        return IntStream.range(0, data.length).collect(StringBuilder::new, (sb, i) -> new Formatter((Appendable)sb).format("%02x", data[i] & 0xFF), StringBuilder::append).toString();
    }

    public static String getFileExtension(String fullName) {
        String fileName = new File(fullName).getName();
        int idx = fileName.lastIndexOf(46);
        return idx == -1 ? "" : fileName.substring(idx + 1);
    }
}

