/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class ListFile<T, ME extends ListFile>
implements Iterable<T> {
    protected List<T> lines = new LinkedList<T>();

    protected ListFile() {
    }

    @Override
    public Iterator<T> iterator() {
        return this.lines.iterator();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public boolean add(T e) {
        return this.lines.add(e);
    }

    public boolean addAll(Collection<? extends T> c) {
        return this.lines.addAll(c);
    }

    public boolean contains(Object o) {
        return this.lines.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.lines.containsAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.lines.retainAll(c);
    }

    public int size() {
        return this.lines.size();
    }

    public T[] toArray() {
        return this.lines.toArray();
    }

    public T[] toArray(T[] a) {
        return this.lines.toArray(a);
    }

    public ME read(File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            reader.lines().forEach(line -> {
                T thing = this.parseLine((String)line);
                if (thing != null) {
                    this.lines.add(thing);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (ME)this;
    }

    protected abstract T parseLine(String var1);
}

