/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.srg2source.rangeapplier.ExceptorFile;
import net.minecraftforge.srg2source.rangeapplier.LocalVarFile;
import net.minecraftforge.srg2source.rangeapplier.MethodData;
import net.minecraftforge.srg2source.rangeapplier.SrgContainer;
import net.minecraftforge.srg2source.util.Util;

class RenameMap {
    public Map<String, String> maps = new HashMap<String, String>();
    public Map<String, String> imports = new HashMap<String, String>();

    public RenameMap readSrg(SrgContainer srgs) {
        for (Map.Entry e : srgs.packageMap.entrySet()) {
            this.maps.put("package " + (String)e.getKey(), (String)e.getValue());
        }
        for (Map.Entry e : srgs.classMap.entrySet()) {
            String replacedKey = ((String)e.getKey()).replace('$', '/');
            this.maps.put("class " + replacedKey, ((String)e.getValue()).replace('$', '.').replace('/', '.'));
            this.imports.put("class " + replacedKey, Util.internalName2Source((String)e.getValue()));
        }
        for (Map.Entry e : srgs.fieldMap.entrySet()) {
            this.maps.put("field " + ((String)e.getKey()).replace('$', '/'), Util.splitBaseName((String)e.getValue()).replace('$', '/'));
        }
        for (Map.Entry e : srgs.methodMap.entrySet()) {
            this.maps.put("method " + ((MethodData)e.getKey()).name.replace('$', '/') + " " + ((MethodData)e.getKey()).sig, Util.splitBaseName(((MethodData)e.getValue()).name).replace('$', '.'));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RenameMap readParamMap(SrgContainer srg, ExceptorFile exc) {
        BiMap<String, String> classMap = srg.classMap.inverse();
        BiMap<MethodData, MethodData> methodMap = srg.methodMap.inverse();
        HashBiMap<String, String> tmpClass = HashBiMap.create(classMap.size());
        for (Map.Entry entry : classMap.entrySet()) {
            tmpClass.put(((String)entry.getKey()).replace('$', '/'), ((String)entry.getValue()).replace('$', '/'));
        }
        HashBiMap<MethodData, MethodData> tmpMethod = HashBiMap.create(methodMap.size());
        for (Map.Entry entry : methodMap.entrySet()) {
            tmpMethod.put(new MethodData(((MethodData)entry.getKey()).name.replace('$', '/'), ((MethodData)entry.getKey()).sig), new MethodData(((MethodData)entry.getValue()).name.replace('$', '/'), ((MethodData)entry.getValue()).sig));
        }
        methodMap = tmpMethod;
        for (ExceptorFile.ExcLine line : exc) {
            MethodData methodData = line.getMethodData();
            if (line.methodName.equals("<init>")) {
                String newClassName = line.className;
                if (!tmpClass.containsKey(line.className)) continue;
                newClassName = (String)tmpClass.get(line.className);
                MethodData methodData2 = new MethodData(newClassName + "/" + Util.splitBaseName(newClassName), Util.remapSig(line.methodSig, classMap));
            } else if (methodMap.containsKey(methodData)) {
                MethodData methodData3 = (MethodData)methodMap.get(methodData);
            }
            for (int i = 0; i < line.params.size(); ++i) {
                void var7_13;
                this.maps.put("param " + var7_13 + " " + i, line.params.get(i));
            }
        }
        return this;
    }

    public RenameMap readLocalVariableMap(LocalVarFile localVars, SrgContainer srg) throws IOException {
        BiMap<String, String> classMap = srg.classMap.inverse();
        BiMap<MethodData, MethodData> methodMap = srg.methodMap.inverse();
        for (LocalVarFile.LocalVar var : localVars) {
            Object key;
            MethodData val;
            String className;
            String mcpClassName = Util.sourceName2Internal(var.mcpClassName);
            if (!classMap.containsKey(mcpClassName)) {
                className = "net.minecraft.server." + Util.splitBaseName(mcpClassName);
                System.out.println("WARNING: readLocalVariableMap: no CB class name for MCP class name " + mcpClassName + ", using " + className);
            } else {
                className = (String)classMap.get(mcpClassName);
            }
            if (var.mcpMethodName.equals("{}")) {
                val = new MethodData("{}", "");
            } else if (var.mcpMethodName.equals(Util.splitBaseName(var.mcpMethodName))) {
                val = new MethodData(className + "/" + Util.splitBaseName(className), Util.remapSig(var.mcpMethodSig, classMap));
            } else {
                key = new MethodData(mcpClassName + "/" + var.mcpMethodName, var.mcpMethodSig);
                if (!methodMap.containsKey(key)) {
                    System.out.println("NOTICE: local variables available for " + key + " but no inverse method map; skipping");
                    continue;
                }
                val = (MethodData)methodMap.get(key);
            }
            key = "localvar " + val + " " + var.variableIndex;
            this.maps.put((String)key, var.expectedOldText);
        }
        return this;
    }
}

