/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.srg2source.rangeapplier.MethodData;
import net.minecraftforge.srg2source.util.ListFile;

public class ExceptorFile
extends ListFile<ExcLine, ExceptorFile> {
    static final Pattern EXC_REGEX = Pattern.compile("^([^.]+)\\.([^(]+)(\\([^=]+)=([^|]*)\\|(.*)");
    static final Splitter SPLIT = Splitter.on(",").omitEmptyStrings().trimResults();

    public ExceptorFile() {
    }

    public ExceptorFile(File src) {
        this.read(src);
    }

    @Override
    protected ExcLine parseLine(String line) {
        Matcher match = EXC_REGEX.matcher(line);
        if (match.find()) {
            String className = match.group(1);
            String methodName = match.group(2);
            String methodSig = match.group(3);
            int index = className.lastIndexOf(36);
            if (index >= 0) {
                String parent = "L" + className.substring(0, index) + ";";
                if (methodName.equals("<init>") && methodSig.startsWith("(" + parent)) {
                    ArrayList<String> params = new ArrayList<String>(SPLIT.splitToList(match.group(5)));
                    params.remove(0);
                    super.add(new ExcLine(className, methodName, methodSig.replace("(" + parent, "("), SPLIT.splitToList(match.group(4)), params));
                }
            }
            if (methodName.equals("<init>") && methodSig.startsWith("(Ljava/lang/String;I")) {
                ArrayList<String> params = new ArrayList<String>(SPLIT.splitToList(match.group(5)));
                params.remove(0);
                params.remove(0);
                super.add(new ExcLine(className, methodName, methodSig.replace("(Ljava/lang/String;I", "("), SPLIT.splitToList(match.group(4)), params));
            }
            return new ExcLine(match.group(1), match.group(2), match.group(3), SPLIT.splitToList(match.group(4)), SPLIT.splitToList(match.group(5)));
        }
        return null;
    }

    public static final class ExcLine
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 887701501978751668L;
        public final String className;
        public final String methodName;
        public final String methodSig;
        public final List<String> exceptions;
        public final List<String> params;

        ExcLine(String className, String methodName, String methodSig, List<String> exceptions, List<String> params) {
            this.className = className.replace('$', '/');
            this.methodName = methodName.replace('$', '/');
            this.methodSig = methodSig;
            this.exceptions = exceptions;
            this.params = params;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.exceptions == null ? 0 : this.exceptions.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            result = 31 * result + (this.methodSig == null ? 0 : this.methodSig.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public MethodData getMethodData() {
            return new MethodData(this.className + "/" + this.methodName, this.methodSig);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExcLine other = (ExcLine)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.exceptions == null ? other.exceptions != null : !this.exceptions.equals(other.exceptions)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            if (this.methodSig == null ? other.methodSig != null : !this.methodSig.equals(other.methodSig)) {
                return false;
            }
            return !(this.params == null ? other.params != null : !this.params.equals(other.params));
        }
    }
}

