/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.srg2source.api.SourceVersion;
import net.minecraftforge.srg2source.ast.SymbolRangeEmitter;
import net.minecraftforge.srg2source.ast.SymbolReferenceWalker;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class RangeExtractor
extends ConfLogger<RangeExtractor> {
    private static RangeExtractor INSTANCE = null;
    private PrintWriter output;
    private String sourceVersion;
    private boolean enableBatchedASTs = true;
    private final Set<File> libs = new LinkedHashSet<File>();
    private String[] libArray = null;
    private InputSupplier input;
    private Map<String, FileCache> file_cache = new HashMap<String, FileCache>();
    private int cache_hits = 0;
    private boolean enableNewRanges = false;

    public void setOutput(PrintWriter value) {
        this.output = value;
    }

    public void setSourceCompatibility(SourceVersion value) {
        this.sourceVersion = value.getSpec();
    }

    public void setBatchASTs(boolean value) {
        this.enableBatchedASTs = value;
    }

    public void addLibrary(File value) {
        String fileName = value.getPath().toLowerCase(Locale.ENGLISH);
        if (value.isDirectory()) {
            this.libArray = null;
            this.libs.add(value);
        } else if (fileName.endsWith(".jar") || fileName.endsWith(".jar")) {
            this.libArray = null;
            this.libs.add(value);
        } else {
            this.log("Unsupposrted library path: " + value.getAbsolutePath());
        }
    }

    public void setInput(InputSupplier supplier) {
        this.input = supplier;
    }

    public void loadCache(InputStream stream) throws IOException {
        FileCache file = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("startProcessing")) {
                    line = line.substring("startProcessing \"".length());
                    file = new FileCache();
                    file.path = line.substring(0, line.indexOf(34));
                    file.md5 = line.substring(file.path.length() + 7);
                    continue;
                }
                if (line.startsWith("endProcessing")) {
                    if (file == null) continue;
                    String path = (line = line.substring("endProcessing \"".length())).substring(0, line.indexOf(34));
                    if (path.equals(file.path)) {
                        this.file_cache.put(path, file);
                    }
                    file = null;
                    continue;
                }
                if ("Cache Hit!".equals(line) || file == null) continue;
                file.lines.add(line);
            }
        }
    }

    public boolean run() {
        this.log("Symbol range map extraction starting");
        List<String> tmp = this.input.gatherAll(".java");
        Collections.sort(tmp);
        String[] files = tmp.toArray(new String[tmp.size()]);
        this.log("Processing " + files.length + " files");
        if (files.length == 0) {
            this.cleanup();
            return true;
        }
        if (this.canBatchASTs()) {
            return this.batchGenerate(files);
        }
        return this.legacyGenerate(files);
    }

    private boolean legacyGenerate(String[] files) {
        try {
            for (String path : files) {
                Charset encoding = this.input.getEncoding(path);
                if (encoding == null) {
                    encoding = StandardCharsets.UTF_8;
                }
                try (InputStream stream = this.input.getInput(path);){
                    SymbolRangeEmitter emitter = new SymbolRangeEmitter(path, this.output);
                    String data = new String(Util.readStream(stream), encoding);
                    String md5 = Util.md5(data, encoding);
                    this.log("startProcessing \"" + path + "\" md5: " + md5);
                    FileCache cache = this.file_cache.get(path);
                    if (cache != null && cache.path.equals(path) && cache.md5.equals(md5)) {
                        this.log("Cache Hit!");
                        ++this.cache_hits;
                        for (String line : cache.lines) {
                            emitter.log(line);
                        }
                    } else {
                        ASTParser parser = Util.createParser(this.sourceVersion, this.input.getRoot(path), this.getLibArray());
                        CompilationUnit cu = Util.createUnit(parser, this.sourceVersion, path, data.toCharArray());
                        if (cu.getProblems() != null && cu.getProblems().length > 0) {
                            for (IProblem prob : cu.getProblems()) {
                                if (prob.isWarning()) continue;
                                this.log("    Compile Error! " + prob.toString());
                            }
                        }
                        int[] newCode = this.getNewCodeRanges(cu, data);
                        SymbolReferenceWalker walker = new SymbolReferenceWalker(emitter, null, newCode);
                        walker.walk(cu);
                    }
                    this.log("endProcessing \"" + path + "\"");
                    this.log("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.errorLogger);
        }
        this.cleanup();
        return true;
    }

    private boolean batchGenerate(String[] files) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Can not do batched processing while another is running!");
        }
        INSTANCE = this;
        ASTParser parser = Util.createParser(this.sourceVersion, this.getLibArray());
        FileASTRequestor requestor = new FileASTRequestor(){

            @Override
            public void acceptAST(String path, CompilationUnit cu) {
                path = path.replace(File.separatorChar, '/');
                Charset encoding = RangeExtractor.this.input.getEncoding(path);
                if (encoding == null) {
                    encoding = StandardCharsets.UTF_8;
                }
                try (InputStream stream = RangeExtractor.this.input.getInput(path);){
                    SymbolRangeEmitter emitter = new SymbolRangeEmitter(path, RangeExtractor.this.output);
                    String data = new String(Util.readStream(stream), encoding).replaceAll("\r", "");
                    String md5 = Util.md5(data, encoding);
                    RangeExtractor.this.log("startProcessing \"" + path + "\" md5: " + md5);
                    FileCache cache = (FileCache)RangeExtractor.this.file_cache.get(path);
                    if (cache != null && cache.path.equals(path) && cache.md5.equals(md5)) {
                        RangeExtractor.this.log("Cache Hit!");
                        RangeExtractor.this.cache_hits++;
                        for (String line : cache.lines) {
                            emitter.log(line);
                        }
                    } else {
                        if (cu.getProblems() != null && cu.getProblems().length > 0) {
                            for (IProblem prob : cu.getProblems()) {
                                if (prob.isWarning()) continue;
                                RangeExtractor.this.log("    Compile Error! " + prob.toString());
                            }
                        }
                        int[] newCode = RangeExtractor.this.getNewCodeRanges(cu, data);
                        SymbolReferenceWalker walker = new SymbolReferenceWalker(emitter, null, newCode);
                        walker.walk(cu);
                    }
                    RangeExtractor.this.log("endProcessing \"" + path + "\"");
                    RangeExtractor.this.log("");
                }
                catch (IOException e) {
                    if (RangeExtractor.this.output != null) {
                        e.printStackTrace(RangeExtractor.this.output);
                    }
                    e.printStackTrace();
                }
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor(){};
        parser.createASTs(files, null, new String[0], requestor, monitor);
        this.cleanup();
        INSTANCE = null;
        return true;
    }

    private void cleanup() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.output != null) {
            this.output.flush();
            this.output.close();
            this.output = null;
        }
    }

    @Override
    protected void log(String s) {
        if (this.output != null) {
            this.output.println(s);
        }
        super.log(s);
    }

    private int[] getNewCodeRanges(CompilationUnit cu, String data) {
        if (!this.enableNewRanges) {
            return new int[0];
        }
        boolean inside = false;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Comment cmt : cu.getCommentList()) {
            String[] lines;
            String comment = data.substring(cmt.getStartPosition(), cmt.getStartPosition() + cmt.getLength());
            if (cmt.isLineComment()) {
                String[] words = comment.split(" ");
                if (words.length < 3) continue;
                int idx = words[0].startsWith("//") && words[0].length() != 2 ? 1 : 2;
                String command = words[idx];
                if (command.equalsIgnoreCase("start")) {
                    ret.add(cmt.getStartPosition());
                    if (inside) {
                        this.log("Unmatched newcode start: " + cmt.getStartPosition() + ": " + comment);
                    }
                    inside = true;
                    continue;
                }
                if (!command.equalsIgnoreCase("end")) continue;
                ret.add(cmt.getStartPosition());
                if (!inside) {
                    this.log("Unmatched newcode end: " + cmt.getStartPosition() + ": " + comment);
                }
                inside = false;
                continue;
            }
            if (!cmt.isBlockComment()) continue;
            for (String line : lines = comment.split("\r?\n")) {
                String[] words = line.trim().split(" ");
                if (words.length < 3) continue;
                String command = words[2];
                if (command.equalsIgnoreCase("start")) {
                    ret.add(cmt.getStartPosition());
                    if (inside) {
                        this.log("Unmatched newcode start: " + cmt.getStartPosition() + ": " + comment);
                    }
                    inside = true;
                    continue;
                }
                if (!command.equalsIgnoreCase("end")) continue;
                ret.add(cmt.getStartPosition());
                if (!inside) {
                    this.log("Unmatched newcode end: " + cmt.getStartPosition() + ": " + comment);
                }
                inside = false;
            }
        }
        int[] r = new int[ret.size()];
        for (int x = 0; x < ret.size(); ++x) {
            r[x] = (Integer)ret.get(x);
        }
        return r;
    }

    private String[] getLibArray() {
        if (this.libArray == null) {
            this.libArray = (String[])this.libs.stream().map(File::getAbsolutePath).toArray(String[]::new);
        }
        return this.libArray;
    }

    public int getCacheHits() {
        return this.cache_hits;
    }

    public boolean canBatchASTs() {
        return RangeExtractor.hasBeenASMPatched() && this.enableBatchedASTs;
    }

    /*
     * Exception decompiling
     */
    public static char[] getFileCharContent(String path, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean hasBeenASMPatched() {
        return true;
    }

    private static final class FileCache {
        private String path;
        private String md5;
        private List<String> lines = new ArrayList<String>();

        private FileCache() {
        }
    }
}

