/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraftforge.srg2source.api.RangeApplierBuilder;

public class RangeApplyMain {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpArg = parser.acceptsAll(RangeApplyMain.a("h", "help")).forHelp();
        ArgumentAcceptingOptionSpec<File> inputArg = parser.acceptsAll(RangeApplyMain.a("in", "input", "srcRoot")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> rangeArg = parser.acceptsAll(RangeApplyMain.a("rm", "range", "srcRangeMap")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> mappingArg = parser.acceptsAll(RangeApplyMain.a("map", "srg", "srgFiles")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> excArg = parser.acceptsAll(RangeApplyMain.a("exc", "excFiles")).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> outArg = parser.acceptsAll(RangeApplyMain.a("out", "output", "outDir")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<Boolean> importArg = parser.acceptsAll(RangeApplyMain.a("keepImports")).withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<File> lvRangeArg = parser.acceptsAll(RangeApplyMain.a("lvRangeMap")).withRequiredArg().ofType(File.class);
        try {
            OptionSet options = parser.parse(args);
            if (options.has(helpArg)) {
                parser.printHelpOn(System.out);
                return;
            }
            File range = options.valueOf(rangeArg);
            File output = options.valueOf(outArg);
            File lvRange = options.valueOf(lvRangeArg);
            boolean keepImports = options.has(importArg) && options.valueOf(importArg) != false;
            System.out.println("Range:   " + range);
            System.out.println("Output:  " + output);
            System.out.println("LVRange: " + lvRange);
            System.out.println("Imports: " + keepImports);
            RangeApplierBuilder builder = new RangeApplierBuilder().range(range).output(output).lvrange(lvRange);
            if (options.has(mappingArg)) {
                options.valuesOf(mappingArg).forEach(v -> {
                    System.out.println("Map:     " + v);
                    builder.srg((File)v);
                });
            }
            options.valuesOf(inputArg).forEach(v -> {
                System.out.println("Input:   " + v);
                builder.input((File)v);
            });
            if (options.has(excArg)) {
                options.valuesOf(excArg).forEach(v -> {
                    System.out.println("Exc:     " + v);
                    builder.exc((File)v);
                });
            }
            if (keepImports) {
                builder.keepImports();
            } else {
                builder.trimImports();
            }
            builder.build().run();
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }

    private static List<String> a(String ... values) {
        return Arrays.asList(values);
    }
}

