/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvParser;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CsvReader {
    private char fieldSeparator = (char)44;
    private char textDelimiter = (char)34;
    private boolean containsHeader;
    private boolean skipEmptyRows = true;
    private boolean errorOnDifferentFieldCount;

    public void setContainsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
    }

    public CsvContainer read(Reader reader) throws IOException {
        CsvRow csvRow;
        CsvParser csvParser = this.parse(Objects.requireNonNull(reader, "reader must not be null"));
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        while ((csvRow = csvParser.nextRow()) != null) {
            rows.add(csvRow);
        }
        if (rows.isEmpty()) {
            return null;
        }
        List<String> header = this.containsHeader ? csvParser.getHeader() : null;
        return new CsvContainer(header, rows);
    }

    public CsvParser parse(Reader reader) throws IOException {
        return new CsvParser(Objects.requireNonNull(reader, "reader must not be null"), this.fieldSeparator, this.textDelimiter, this.containsHeader, this.skipEmptyRows, this.errorOnDifferentFieldCount);
    }
}

