/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraftforge.srg2source.rangeapplier.MethodData;

public class SrgContainer {
    private static Pattern CLS_ENTRY = Pattern.compile("L([^;]+);");
    public final BiMap<String, String> classMap = HashBiMap.create();
    public final BiMap<String, String> fieldMap;
    public final BiMap<String, String> packageMap = HashBiMap.create();
    public final BiMap<MethodData, MethodData> methodMap;

    public SrgContainer() {
        this.fieldMap = HashBiMap.create();
        this.methodMap = HashBiMap.create();
    }

    public SrgContainer readSrg(File srg) {
        return this.readSrg(srg, false);
    }

    public SrgContainer readSrg(File srg, boolean reverse) {
        try {
            return this.readSrg(Files.readLines((File)srg, (Charset)StandardCharsets.UTF_8), reverse);
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public SrgContainer readSrg(List<String> lines, boolean reverse) {
        String currentClass = null;
        lines = lines.stream().map(line -> line.split("#")[0]).filter(l -> !Strings.isNullOrEmpty((String)l.trim())).collect(Collectors.toList());
        for (String line2 : lines) {
            String[] args;
            if (line2.startsWith("\t") || line2.indexOf(58) != -1 && !line2.startsWith("CL:")) continue;
            if (line2.indexOf(58) != -1) {
                line2 = line2.substring(4);
            }
            if ((args = line2.split(" ")).length != 2 || args[0].endsWith("/")) continue;
            this.classMap.put((Object)args[0], (Object)args[1]);
        }
        for (String line2 : lines) {
            String type;
            int idx = line2.indexOf(58);
            if (idx != -1 && line2.startsWith("CL:")) continue;
            String string = type = idx != -1 ? line2.substring(0, idx) : null;
            if (idx != -1) {
                line2 = line2.substring(4);
            }
            if (line2.startsWith("\t")) {
                if (currentClass == null) {
                    throw new RuntimeException("Invalid TSRG line, missing current class: " + line2);
                }
                line2 = currentClass + " " + line2.substring(1);
            }
            String[] args = line2.split(" ");
            if (type != null) {
                if (type.equals("PK")) {
                    this.packageMap.put((Object)args[0], (Object)args[1]);
                    continue;
                }
                if (type.equals("CL")) continue;
                if (type.equals("FD")) {
                    this.fieldMap.put((Object)args[0], (Object)args[1]);
                    continue;
                }
                if (type.equals("MD")) {
                    this.methodMap.put((Object)new MethodData(args[0], args[1]), (Object)new MethodData(args[2], args[3]));
                    continue;
                }
                throw new RuntimeException("Invalid SRG Line: " + type + ": " + line2);
            }
            if (args.length == 2) {
                if (args[0].endsWith("/")) {
                    this.packageMap.put((Object)args[0].substring(0, args[0].length() - 1), (Object)args[1].substring(0, args[1].length() - 1));
                    continue;
                }
                currentClass = args[0];
                continue;
            }
            if (args.length == 3) {
                this.fieldMap.put((Object)(args[0] + "/" + args[1]), (Object)(this.remapClass(args[0]) + "/" + args[2]));
                continue;
            }
            if (args.length == 4) {
                this.methodMap.put((Object)new MethodData(args[0] + "/" + args[1], args[2]), (Object)new MethodData(this.remapClass(args[0]) + "/" + args[3], this.remapDesc(args[2])));
                continue;
            }
            throw new RuntimeException("Invalid CSRG Line: " + type + ": " + line2);
        }
        return this;
    }

    private String remapClass(String cls) {
        String ret = (String)this.classMap.get((Object)cls);
        if (ret != null) {
            return ret;
        }
        int idx = cls.lastIndexOf(36);
        ret = idx != -1 ? this.remapClass(cls.substring(0, idx)) + cls.substring(idx) : cls;
        this.classMap.put((Object)cls, (Object)ret);
        return cls;
    }

    private String remapDesc(String desc) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = CLS_ENTRY.matcher(desc);
        while (matcher.find()) {
            matcher.appendReplacement(buf, "L" + Matcher.quoteReplacement(this.remapClass(matcher.group(1))) + ";");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public SrgContainer readSrgs(Iterable<File> srgs) {
        for (File file : srgs) {
            this.readSrg(file);
        }
        return this;
    }
}

