/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.srg2source.util.Util;

public class RangeMap {
    private final Multimap<String, RangeEntry> rangeMap;
    private final HashMap<String, String> obfids = Maps.newHashMap();

    public RangeMap() {
        this.rangeMap = Multimaps.newMultimap(new HashMap(), (Supplier)new Supplier<Collection<RangeEntry>>(){

            public Collection<RangeEntry> get() {
                return new TreeSet<RangeEntry>();
            }
        });
    }

    public Set<String> keySet() {
        return this.rangeMap.keySet();
    }

    public Collection<RangeEntry> get(String key) {
        return this.rangeMap.get((Object)key);
    }

    public RangeMap read(File file) {
        try {
            for (String line : Files.readLines((File)file, (Charset)Charset.defaultCharset())) {
                String key;
                line = line.trim();
                List tokens = Splitter.on((char)'|').splitToList((CharSequence)line);
                if (!((String)tokens.get(0)).equals("@")) continue;
                String fileName = (String)tokens.get(1);
                int startRange = Integer.parseInt((String)tokens.get(2));
                int endRange = Integer.parseInt((String)tokens.get(3));
                String expectedOldText = (String)tokens.get(4);
                String kind = (String)tokens.get(5);
                List info = tokens.subList(6, tokens.size());
                boolean qualified = false;
                if (kind.equals("package")) {
                    String forClass = (String)info.get(1);
                    forClass = forClass.equals("(file)") ? Util.getTopLevelClassForFilename(fileName) : Util.sourceName2Internal(forClass);
                    key = "package " + forClass;
                } else if (kind.equals("class")) {
                    String className = Util.sourceName2Internal((String)info.get(0));
                    if (Strings.isNullOrEmpty((String)className)) continue;
                    key = "class " + className;
                    if (info.size() > 1 && ((String)info.get(1)).equals("true")) {
                        qualified = true;
                    }
                } else if (kind.equals("field")) {
                    key = "field " + Util.sourceName2Internal((String)info.get(0)) + "/" + (String)info.get(1);
                    if (((String)info.get(1)).equals("__OBFID")) {
                        this.obfids.put((String)info.get(0), (String)info.get(2));
                    }
                } else if (kind.equals("method")) {
                    if (expectedOldText.contains("super") || expectedOldText.contains("this")) continue;
                    key = "method " + Util.sourceName2Internal((String)info.get(0)) + "/" + (String)info.get(1) + " " + (String)info.get(2);
                } else if (kind.equals("param")) {
                    key = "param " + Util.sourceName2Internal((String)info.get(0)) + "/" + (String)info.get(1) + " " + (String)info.get(2) + " " + (String)info.get(4);
                } else if (kind.equals("localvar")) {
                    key = "localvar " + Util.sourceName2Internal((String)info.get(0)) + "/" + (String)info.get(1) + " " + (String)info.get(2) + " " + (String)info.get(4);
                } else {
                    throw new RuntimeException("Unknown kind: " + kind);
                }
                this.rangeMap.put((Object)fileName, (Object)new RangeEntry(startRange, endRange, expectedOldText, key, qualified));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public static class RangeEntry
    implements Comparable<RangeEntry> {
        public final int start;
        public final int end;
        public final String expectedOldText;
        public final String key;
        public final boolean qualified;

        RangeEntry(int start, int end, String expectedOldText, String key, boolean qualified) {
            this.start = start;
            this.end = end;
            this.expectedOldText = expectedOldText;
            this.key = key;
            this.qualified = qualified;
        }

        @Override
        public int compareTo(RangeEntry arg0) {
            if (this.start == arg0.start) {
                return 0;
            }
            return this.start > arg0.start ? 1 : -1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + (this.expectedOldText == null ? 0 : this.expectedOldText.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangeEntry other = (RangeEntry)obj;
            if (this.end != other.end) {
                return false;
            }
            if (this.expectedOldText == null ? other.expectedOldText != null : !this.expectedOldText.equals(other.expectedOldText)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.start == other.start;
        }

        public String toString() {
            return "RangeEntry [start=" + this.start + ", end=" + this.end + ", expectedOldText=" + this.expectedOldText + ", key=" + this.key + "]";
        }
    }
}

