/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.rangeapplier;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraftforge.srg2source.rangeapplier.ExceptorFile;
import net.minecraftforge.srg2source.rangeapplier.LocalVarFile;
import net.minecraftforge.srg2source.rangeapplier.RangeMap;
import net.minecraftforge.srg2source.rangeapplier.RenameMap;
import net.minecraftforge.srg2source.rangeapplier.SrgContainer;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class RangeApplier
extends ConfLogger<RangeApplier> {
    private SrgContainer srg = new SrgContainer();
    private final RenameMap map = new RenameMap();
    private boolean keepImports = false;

    public static void main(String[] args) throws IOException {
        FolderSupplier srcRoot;
        OptionParser parser = new OptionParser();
        parser.acceptsAll(Arrays.asList("h", "help")).isForHelp();
        parser.accepts("srcRoot", "Source root directory to rename").withRequiredArg().ofType(File.class).isRequired();
        parser.accepts("srcRangeMap", "Source range map generated by srg2source").withRequiredArg().ofType(File.class).isRequired();
        parser.accepts("srgFiles", "Symbol map file(s), separated by ' '").withRequiredArg().ofType(File.class).isRequired();
        parser.accepts("git", "Command to invoke git");
        parser.accepts("lvRangeMap", "Original source range map generated by srg2source, for renaming local variables");
        parser.accepts("mcpConfDir", "MCP configuration directory, for renaming parameters").withRequiredArg().ofType(File.class);
        parser.accepts("excFiles", "Parameter map file(s), separated by ' '").withRequiredArg().ofType(File.class);
        parser.accepts("dumpRangeMap", "Enable dumping the ordered range map and quit");
        parser.accepts("outDir", "The output folder for editted classes.").withRequiredArg().ofType(File.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        boolean dumpRangeMap = options.has("dumpRangeMap");
        if (dumpRangeMap) {
            RangeMap ranges = new RangeMap().read((File)options.valueOf("srcRangeMap"));
            for (String key : ranges.keySet()) {
                for (RangeMap.RangeEntry info : ranges.get(key)) {
                    System.out.println(info);
                }
            }
            return;
        }
        RangeApplier app = new RangeApplier().readSrg(options.valuesOf("srgFiles"));
        if (options.has("mcpConfDir") && options.hasArgument("mcpConfDir")) {
            File conf = (File)options.valueOf("mcpConfDir");
            File primary = new File(conf, "joined.exc");
            LinkedList<File> excs = new LinkedList<File>();
            if (!primary.exists()) {
                primary = new File(conf, "packaged.exc");
            }
            excs.add(primary);
            if (options.has("excFiles") && options.hasArgument("excFiles")) {
                excs.addAll(options.valuesOf("excFiles"));
            }
            app.readParamMap(excs);
        }
        if (options.has("lvRangeMap") && options.hasArgument("lvRangeMap")) {
            app.readLvRangeMap((File)options.valueOf("lvRangeMap"));
        }
        FolderSupplier outDir = srcRoot = new FolderSupplier((File)options.valueOf("srcRoot"));
        if (options.has("outDir")) {
            outDir = new FolderSupplier((File)options.valueOf("outDir"));
        }
        app.remapSources((InputSupplier)srcRoot, (OutputSupplier)outDir, (File)options.valueOf("srcRangeMap"), false);
        srcRoot.close();
        outDir.close();
        System.out.println("FINISHED!");
    }

    public RangeApplier readSrg(File srg) {
        this.srg.readSrg(srg);
        this.map.readSrg(this.srg);
        return this;
    }

    public RangeApplier readSrg(Iterable<File> srgs) {
        this.srg.readSrgs(srgs);
        this.map.readSrg(this.srg);
        return this;
    }

    public RangeApplier readSrg(SrgContainer srgCont) {
        this.srg = srgCont;
        this.map.readSrg(this.srg);
        return this;
    }

    public RangeApplier readParamMap(Iterable<File> exceptors) {
        ExceptorFile exc = (ExceptorFile)new ExceptorFile().read(exceptors);
        this.map.readParamMap(this.srg, exc);
        return this;
    }

    public RangeApplier readParamMap(ExceptorFile exc) {
        this.map.readParamMap(this.srg, exc);
        return this;
    }

    public RangeApplier readLvRangeMap(File lvRangeMap) {
        try {
            this.map.readLocalVariableMap((LocalVarFile)new LocalVarFile().read(lvRangeMap), this.srg);
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return this;
    }

    public void dumpRenameMap() {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.map.maps.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : entries) {
            this.log("RENAME MAP: " + (String)entry.getKey() + " -> " + (String)entry.getValue());
        }
    }

    public void remapSources(InputSupplier inSupp, OutputSupplier outSupp, File rangeMap, boolean annotate) throws IOException {
        this.remapSources(inSupp, outSupp, new RangeMap().read(rangeMap), annotate);
    }

    public void remapSources(InputSupplier inSupp, OutputSupplier outSupp, RangeMap range, boolean annotate) throws IOException {
        ArrayList<String> paths = new ArrayList<String>(range.keySet());
        Collections.sort(paths);
        this.log("Processing " + paths.size() + " files");
        for (String filePath : paths) {
            this.log("Start Processing: " + filePath);
            InputStream stream = inSupp.getInput(filePath);
            if (stream == null) {
                this.log("Data not found: " + filePath);
                continue;
            }
            String data = new String(ByteStreams.toByteArray((InputStream)stream), Charset.forName("UTF-8"));
            stream.close();
            if (data.contains("\r")) {
                this.log("Warning: " + filePath + " has CRLF line endings; consider switching to LF");
                data = data.replace("\r", "");
            }
            ImmutableList<String> out = this.processJavaSourceFile(filePath, data, range.get(filePath), annotate);
            filePath = (String)out.get(0);
            data = (String)out.get(1);
            OutputStream outStream = outSupp.getOutput(filePath);
            outStream.write(data.getBytes(Charset.forName("UTF-8")));
            outStream.close();
            this.log("End  Processing: " + filePath);
            this.log("");
        }
    }

    private ImmutableList<String> processJavaSourceFile(String fileName, String data, Collection<RangeMap.RangeEntry> rangeList, boolean shouldAnnotate) throws IOException {
        String newFileName;
        StringBuilder outData = new StringBuilder();
        outData.append(data);
        TreeSet<String> importsToAdd = new TreeSet<String>();
        int shift = 0;
        String oldTopLevelClassFullName = Util.getTopLevelClassForFilename(fileName);
        String oldTopLevelClassPackage = Util.splitPackageName(oldTopLevelClassFullName);
        String oldTopLevelClassName = Util.splitBaseName(oldTopLevelClassFullName);
        String newTopLevelClassPackage = Util.sourceName2Internal(this.map.maps.get("package " + oldTopLevelClassPackage));
        String newTopLevelClassFullName = Util.sourceName2Internal(this.map.maps.get("class " + oldTopLevelClassFullName), false);
        String newTopLevelClassName = Util.splitBaseName(newTopLevelClassFullName);
        if (newTopLevelClassName != null) {
            newTopLevelClassPackage = Util.splitPackageName(newTopLevelClassFullName);
        } else if (newTopLevelClassPackage != null) {
            newTopLevelClassName = oldTopLevelClassName;
        }
        if (newTopLevelClassPackage == null) {
            newTopLevelClassPackage = oldTopLevelClassPackage;
            newTopLevelClassName = oldTopLevelClassName;
        }
        String newTopLevelQualifiedName = (newTopLevelClassPackage + "/" + newTopLevelClassName).replace('\\', '/');
        for (RangeMap.RangeEntry info : rangeList) {
            String oldName;
            int end = info.end;
            String expectedOldText = info.expectedOldText;
            if (this.map.maps.containsKey(info.key) && this.map.maps.get(info.key).isEmpty()) {
                if (!info.key.startsWith("package ")) {
                    throw new RuntimeException("unable to remove non-package symbol " + info.key);
                }
                ++end;
                expectedOldText = expectedOldText + ".";
            }
            if (!(oldName = outData.substring(info.start + shift, end + shift)).equals(expectedOldText)) {
                throw new RuntimeException("Rename sanity check failed: expected '" + expectedOldText + "' at [" + info.start + "," + end + "] (shifted " + shift + " to [" + (shift + info.start) + "," + (shift + end) + "]) in " + fileName + ", but found '" + oldName + "'\nRegenerate symbol map on latest sources or start with fresh source and try again");
            }
            String newName = this.getNewName(info.key, oldName, this.map.maps, shouldAnnotate);
            if (newName == null) {
                newName = oldName;
            }
            if (info.key.startsWith("class ")) {
                String key = info.key;
                if (key.equals("class " + newName.replace('.', '/'))) {
                    key = null;
                } else if (newName.indexOf(46) > 0) {
                    for (int i = 0; i < Util.countChar(newName, '.'); ++i) {
                        key = Util.splitPackageName(key);
                    }
                    this.log("New Key: " + key);
                }
                if (key != null) {
                    String impt = key.substring(key.indexOf(32) + 1);
                    if (this.map.imports.containsKey(key)) {
                        impt = this.map.imports.get(key).replace('.', '/').replace('$', '/');
                    }
                    if (!info.qualified && this.needsImport(newTopLevelQualifiedName, impt)) {
                        if ((impt = impt.replace('/', '.').replace('$', '.')).indexOf(46) == -1) {
                            this.log("ERROR: Invalid import attempted, \"" + impt + "\"");
                        } else {
                            importsToAdd.add(impt);
                        }
                    }
                }
            }
            if (oldName.equals(newName)) continue;
            this.log("Rename " + info.key + "[" + (info.start + shift) + "," + (end + shift) + "]::" + oldName + "->" + newName);
            outData.replace(info.start + shift, end + shift, newName);
            shift += newName.length() - oldName.length();
        }
        String outString = this.updateImports(outData, importsToAdd, this.map.imports);
        if (!(fileName = fileName.replace('\\', '/')).equals(newFileName = newTopLevelQualifiedName + ".java")) {
            this.log("Rename file " + fileName + " -> " + newFileName);
            fileName = newFileName;
        }
        return ImmutableList.of((Object)fileName, (Object)outString);
    }

    private boolean needsImport(String topLevel, String reference) {
        if (reference.startsWith(topLevel)) {
            return false;
        }
        return !Util.splitPackageName(topLevel).equals(Util.splitPackageName(reference));
    }

    private String updateImports(StringBuilder data, Set<String> newImports, Map<String, String> importMap) {
        if (data.charAt(data.length() - 1) != '\n') {
            data.append('\n');
        }
        int lastIndex = 0;
        int nextIndex = data.indexOf("\n");
        boolean addedNewImports = false;
        boolean sawImports = false;
        int packageLine = -1;
        while (nextIndex > -1) {
            String line = data.substring(lastIndex, nextIndex);
            while ((line.isEmpty() || line.startsWith("\n")) && (nextIndex = data.indexOf("\n", ++lastIndex + 1)) != -1) {
                line = data.substring(lastIndex, nextIndex);
            }
            if (line.startsWith("package ")) {
                packageLine = nextIndex + 1;
            }
            if (line.startsWith("import ")) {
                sawImports = true;
                if (line.indexOf(42) > 0) {
                    LinkedList<String> remove = new LinkedList<String>();
                    String starter = line.replace("import ", "").replace(".*;", "").trim();
                    for (String imp : newImports) {
                        String impStart = imp.substring(0, imp.lastIndexOf(46));
                        if (!impStart.equals(starter)) continue;
                        remove.add(imp);
                    }
                    newImports.removeAll(remove);
                }
                String oldClass = line.replace("import ", "").replace(";", "").trim();
                Object newClass = importMap.get("class " + Util.sourceName2Internal(oldClass));
                if (newClass == null) {
                    newClass = oldClass;
                }
                newClass = ((String)newClass).replace('$', '.');
                this.log("Import: " + (String)newClass);
                if (!newImports.remove(newClass)) {
                    if (this.keepImports) {
                        lastIndex = nextIndex + 1;
                    } else {
                        data.delete(lastIndex, nextIndex + 1);
                    }
                    nextIndex = data.indexOf("\n", lastIndex);
                    continue;
                }
                if (!oldClass.equals(newClass)) {
                    int change = "import ".length();
                    data.replace(lastIndex, nextIndex, "import ");
                    data.insert(lastIndex + change, (String)newClass);
                    data.insert(lastIndex + (change += ((String)newClass).length()), ";");
                    nextIndex = lastIndex + change + 1;
                }
            } else if (sawImports && !addedNewImports) {
                this.filterImports(newImports);
                if (newImports.size() > 0) {
                    CharSequence sub = data.subSequence(lastIndex, data.length());
                    data.setLength(lastIndex);
                    for (String imp : newImports) {
                        data.append("import ").append(imp).append(";\n");
                    }
                    if (newImports.size() > 0) {
                        data.append('\n');
                    }
                    int change = data.length() - lastIndex;
                    lastIndex = data.length();
                    nextIndex += change;
                    data.append(sub);
                }
                addedNewImports = true;
                break;
            }
            lastIndex = nextIndex + 1;
            nextIndex = data.indexOf("\n", lastIndex + 1);
        }
        if (!addedNewImports) {
            this.filterImports(newImports);
            if (newImports.size() > 0) {
                int index = packageLine == -1 ? 0 : packageLine;
                CharSequence sub = data.subSequence(index, data.length());
                data.setLength(index);
                for (String imp : newImports) {
                    data.append("import ").append(imp).append(";\n");
                }
                if (newImports.size() > 0) {
                    data.append('\n');
                }
                data.append(sub);
            }
        }
        return data.toString();
    }

    private void filterImports(Set<String> newImports) {
        Iterator<String> itr = newImports.iterator();
        while (itr.hasNext()) {
            if (!itr.next().startsWith("java.lang.")) continue;
            itr.remove();
        }
        if (newImports.size() > 0) {
            this.log("Adding " + newImports.size() + " imports");
            for (String imp : newImports) {
                this.log("        " + imp);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getNewName(String key, String oldName, Map<String, String> renameMap, boolean shouldAnnotate) {
        String newName;
        if (!renameMap.containsKey(key)) {
            String constructorClassName = this.getConstructor(key);
            if (constructorClassName == null) return null;
            this.log("FOUND CONSTR " + key + " " + constructorClassName);
            if (!renameMap.containsKey("class " + constructorClassName)) return null;
            newName = Util.splitBaseName(Util.sourceName2Internal(renameMap.get("class " + constructorClassName), false));
        } else {
            newName = renameMap.get(key);
        }
        newName = Util.splitBaseName(newName, Util.countChar(oldName, '.'));
        if (!shouldAnnotate) return newName;
        return newName + "/* was " + oldName + "*/";
    }

    private String getConstructor(String key) {
        String[] tokens = key.split(" ", 3);
        if (!tokens[0].equals("method")) {
            return null;
        }
        if (tokens[2].charAt(tokens[2].length() - 1) != 'V') {
            return null;
        }
        String fullClassName = Util.splitPackageName(tokens[1]);
        String methodName = Util.splitBaseName(tokens[1]);
        String className = Util.splitBaseName(fullClassName);
        if (className.equals(methodName)) {
            return fullClassName;
        }
        return null;
    }

    public void setKeepImports(boolean value) {
        this.keepImports = value;
    }
}

