/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.ast;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.srg2source.ast.SymbolRangeEmitter;
import net.minecraftforge.srg2source.ast.SymbolReferenceWalker;
import net.minecraftforge.srg2source.util.Util;
import net.minecraftforge.srg2source.util.io.ConfLogger;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class RangeExtractor
extends ConfLogger<RangeExtractor> {
    public static final String JAVA_1_6 = "1.6";
    public static final String JAVA_1_7 = "1.7";
    public static final String JAVA_1_8 = "1.8";
    private PrintWriter outFile;
    private final Set<File> libs = new HashSet<File>();
    private InputSupplier src;
    private ASTParser parser = null;
    private String java_version = "1.6";
    private Map<String, FileCache> file_cache = Maps.newHashMap();
    private int cache_hits = 0;
    private String[] libArray = null;
    private String src_root_cache = "";

    public RangeExtractor() {
        this(JAVA_1_6);
    }

    public RangeExtractor(String javaVersion) {
        this.java_version = javaVersion;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: RangeExtract [SourceDir] [LibDir] [OutFile]");
            return;
        }
        File src = new File(args[0]);
        RangeExtractor extractor = new RangeExtractor();
        extractor.setSrcRoot(new File(args[0]));
        if (args[1].equals("none") || args[1].isEmpty()) {
            extractor.addLibs(src);
        } else {
            extractor.addLibs(args[1]);
        }
        boolean worked = extractor.generateRangeMap(new File(args[2]));
        System.out.println("Srg2source batch mode finished - now exiting " + (worked ? 0 : 1));
        System.exit(worked ? 0 : 1);
    }

    public boolean generateRangeMap(File out) {
        try {
            if (!out.exists()) {
                Files.createParentDirs((File)out);
                out.createNewFile();
            }
            this.outFile = new PrintWriter(new BufferedWriter(new FileWriter(out)));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return this.generateRangeMap(this.outFile);
    }

    public boolean generateRangeMap(PrintWriter writer) {
        this.outFile = writer;
        this.log("Symbol range map extraction starting");
        List<String> tmp = this.src.gatherAll(".java");
        Collections.sort(tmp);
        String[] files = tmp.toArray(new String[tmp.size()]);
        this.log("Processing " + files.length + " files");
        if (files.length == 0) {
            this.cleanup();
            return true;
        }
        try {
            for (String path : files) {
                InputStream stream = this.src.getInput(path);
                SymbolRangeEmitter emitter = new SymbolRangeEmitter(path, this.outFile);
                byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                String data = new String(bytes, Charsets.UTF_8).replaceAll("\r", "");
                String md5 = Hashing.md5().hashString((CharSequence)data, Charsets.UTF_8).toString();
                this.log("startProcessing \"" + path + "\" md5: " + md5);
                FileCache cache = this.file_cache.get(path);
                if (cache != null && cache.path.equals(path) && cache.md5.equals(md5)) {
                    this.log("Cache Hit!");
                    ++this.cache_hits;
                    for (String string : cache.lines) {
                        emitter.log(string);
                    }
                } else {
                    CompilationUnit cu = Util.createUnit(this.getParser(this.src.getRoot(path)), this.java_version, path, data);
                    if (cu.getProblems() != null && cu.getProblems().length > 0) {
                        for (IProblem prob : cu.getProblems()) {
                            if (prob.isWarning()) continue;
                            this.log("    Compile Error! " + prob.toString());
                        }
                    }
                    int[] nArray = this.getNewCodeRanges(cu, data);
                    SymbolReferenceWalker walker = new SymbolReferenceWalker(emitter, null, nArray);
                    walker.walk((ASTNode)cu);
                }
                this.log("endProcessing \"" + path + "\"");
                this.log("");
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.errorLogger);
        }
        this.cleanup();
        return true;
    }

    private void cleanup() {
        this.outFile.close();
        this.outFile = null;
    }

    @Override
    protected void log(String s) {
        this.outFile.println(s);
        this.outLogger.println(s);
    }

    private int[] getNewCodeRanges(CompilationUnit cu, String data) {
        boolean inside = false;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Comment cmt : cu.getCommentList()) {
            String[] lines;
            String comment = data.substring(cmt.getStartPosition(), cmt.getStartPosition() + cmt.getLength());
            if (cmt.isLineComment()) {
                String[] words = comment.split(" ");
                if (words.length < 3) continue;
                int idx = words[0].startsWith("//") && words[0].length() != 2 ? 1 : 2;
                String command = words[idx];
                if (command.equalsIgnoreCase("start")) {
                    ret.add(cmt.getStartPosition());
                    if (inside) {
                        this.log("Unmatched newcode start: " + cmt.getStartPosition() + ": " + comment);
                    }
                    inside = true;
                    continue;
                }
                if (!command.equalsIgnoreCase("end")) continue;
                ret.add(cmt.getStartPosition());
                if (!inside) {
                    this.log("Unmatched newcode end: " + cmt.getStartPosition() + ": " + comment);
                }
                inside = false;
                continue;
            }
            if (!cmt.isBlockComment()) continue;
            for (String line : lines = comment.split("\r?\n")) {
                String[] words = line.trim().split(" ");
                if (words.length < 3) continue;
                String command = words[2];
                if (command.equalsIgnoreCase("start")) {
                    ret.add(cmt.getStartPosition());
                    if (inside) {
                        this.log("Unmatched newcode start: " + cmt.getStartPosition() + ": " + comment);
                    }
                    inside = true;
                    continue;
                }
                if (!command.equalsIgnoreCase("end")) continue;
                ret.add(cmt.getStartPosition());
                if (!inside) {
                    this.log("Unmatched newcode end: " + cmt.getStartPosition() + ": " + comment);
                }
                inside = false;
            }
        }
        int[] r = new int[ret.size()];
        for (int x = 0; x < ret.size(); ++x) {
            r[x] = (Integer)ret.get(x);
        }
        return r;
    }

    public InputSupplier getSrc() {
        return this.src;
    }

    public RangeExtractor setSrcRoot(File srcRoot) {
        if (srcRoot.isDirectory()) {
            this.src = new FolderSupplier(srcRoot);
        }
        return this;
    }

    public RangeExtractor setSrc(InputSupplier supplier) {
        this.src = supplier;
        return this;
    }

    public RangeExtractor addLibs(File lib) {
        if (lib.isDirectory()) {
            this.libArray = null;
            this.libs.add(lib);
            for (File f : lib.listFiles()) {
                this.addLibsRecursive(f);
            }
        } else if (lib.getPath().endsWith(".jar")) {
            this.libArray = null;
            this.libs.add(lib);
        } else {
            this.log("Unsupposrted library path: " + lib.getAbsolutePath());
        }
        return this;
    }

    private void addLibsRecursive(File lib) {
        if (lib.isDirectory()) {
            for (File f : lib.listFiles()) {
                this.addLibsRecursive(f);
            }
        } else if (lib.getPath().endsWith(".jar")) {
            this.libArray = null;
            this.libs.add(lib);
        }
    }

    public RangeExtractor addLibs(String path) {
        if (path.contains(File.pathSeparator)) {
            for (String f : Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)path)) {
                this.addLibs(new File(f));
            }
        } else {
            this.addLibs(new File(path));
        }
        return this;
    }

    public Set<File> getLibs() {
        return this.libs;
    }

    private ASTParser getParser(String root) {
        if (this.libArray == null) {
            this.libArray = new String[this.libs.size()];
            int i = 0;
            for (File f : this.libs) {
                this.libArray[i++] = f.getAbsolutePath();
            }
        }
        this.src_root_cache = root;
        this.parser = Util.createParser(this.java_version, this.src_root_cache, this.libArray);
        return this.parser;
    }

    public void loadCache(InputStream stream) throws IOException {
        FileCache file = null;
        for (String line : CharStreams.readLines((Readable)new InputStreamReader(stream))) {
            if (line.startsWith("startProcessing")) {
                line = line.substring("startProcessing \"".length());
                file = new FileCache();
                file.path = line.substring(0, line.indexOf(34));
                file.md5 = line.substring(file.path.length() + 7);
                continue;
            }
            if (line.startsWith("endProcessing")) {
                if (file == null) continue;
                String path = (line = line.substring("endProcessing \"".length())).substring(0, line.indexOf(34));
                if (path.equals(file.path)) {
                    this.file_cache.put(path, file);
                }
                file = null;
                continue;
            }
            if ("Cache Hit!".equals(line) || file == null) continue;
            file.lines.add(line);
        }
    }

    public int getCacheHits() {
        return this.cache_hits;
    }

    private static final class FileCache {
        private String path;
        private String md5;
        private List<String> lines = Lists.newArrayList();

        private FileCache() {
        }
    }
}

