/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraftforge.installertools.BundlerExtract;
import net.minecraftforge.snowblower.util.Cache;
import net.minecraftforge.snowblower.util.DependencyHashCache;

public class BundlerExtractTask {
    private static final Attributes.Name FORMAT = new Attributes.Name("Bundler-Format");

    public static Path getExtractedServerJar(Consumer<String> logger, Path cache, Path serverJar, DependencyHashCache depCache) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(serverJar, Map.of());){
            Manifest mf;
            Path mfp = fs.getPath("META-INF", "MANIFEST.MF");
            if (!Files.exists(mfp, new LinkOption[0])) {
                Path path = serverJar;
                return path;
            }
            try (InputStream is = Files.newInputStream(mfp, new OpenOption[0]);){
                mf = new Manifest(is);
            }
            String format = mf.getMainAttributes().getValue(FORMAT);
            if (format == null) {
                Path path = serverJar;
                return path;
            }
        }
        Cache key = new Cache().put("net.minecraftforge:installertools", depCache).put("server", serverJar);
        Path keyF = cache.resolve("server-extracted.jar.cache");
        Path extractedServerJar = cache.resolve("server-extracted.jar");
        if (!Files.exists(extractedServerJar, new LinkOption[0]) || !key.isValid(keyF)) {
            logger.accept("  Extracting server jar");
            PrintStream stdout = System.out;
            System.setOut(new PrintStream(OutputStream.nullOutputStream()));
            new BundlerExtract().process(new String[]{"--input", serverJar.toString(), "--output", extractedServerJar.toString(), "--jar-only"});
            System.setOut(stdout);
            key.write(keyF);
        }
        return extractedServerJar;
    }
}

