/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.snowblower.Generator;
import net.minecraftforge.snowblower.data.Config;
import net.minecraftforge.snowblower.util.DependencyHashCache;
import net.minecraftforge.snowblower.util.Util;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.eclipse.jgit.lib.PersonIdent;

public class Main {
    public static void main(String[] args) throws Exception {
        Config cfg;
        MinecraftVersion targetVer;
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output", "Output directory to put the git directory in").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec cacheO = parser.accepts("cache", "Cache directory to hold all files related to a version. If omitted, goes to ./cache").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec extraMappingsO = parser.accepts("extra-mappings", "When set, points to a directory with extra mappings files").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec startVerO = parser.accepts("start-ver", "The starting Minecraft version to generate from (inclusive). If omitted, defaults to oldest while respecting --releases-only").withRequiredArg();
        ArgumentAcceptingOptionSpec targetVerO = parser.accepts("target-ver", "The target Minecraft version to generate up to (inclusive). If omitted, defaults to latest while respecting --releases-only").withRequiredArg();
        ArgumentAcceptingOptionSpec branchNameO = parser.acceptsAll(List.of("branch-name", "branch"), "The Git branch name, creating an orphan branch if it does not exist. Uses checked out branch if omitted").withRequiredArg();
        OptionSpecBuilder releasesOnlyO = parser.accepts("releases-only", "When set, only release versions will be considered");
        OptionSpecBuilder startOverO = parser.accepts("start-over", "Whether to start over by deleting the target branch");
        OptionSpecBuilder startOverIfRequiredO = parser.accepts("start-over-if-required", "Whether to start over by deleting the target branch, only if it is necessary to do so").availableUnless("start-over", new String[0]);
        ArgumentAcceptingOptionSpec configO = parser.accepts("cfg", "Config file for SnowBlower").withRequiredArg().ofType(URI.class);
        ArgumentAcceptingOptionSpec remoteO = parser.accepts("remote", "The URL of the Git remote to use").withRequiredArg().ofType(URL.class);
        OptionSpecBuilder checkoutO = parser.accepts("checkout", "Whether to checkout the remote branch (if it exists) before generating").availableIf("remote", new String[0]);
        OptionSpecBuilder pushO = parser.accepts("push", "Whether to push the branch to the remote once finished").availableIf("remote", new String[0]);
        ArgumentAcceptingOptionSpec committerO = parser.accepts("committer", "The name and email of the user to use as the committer, separated by a space. If omitted, defaults to snowforge").withRequiredArg();
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            System.err.println("Error: " + ex.getMessage());
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
            return;
        }
        URL depHashCacheUrl = Main.class.getResource("/dependency_hashes.txt");
        if (depHashCacheUrl == null) {
            throw new IllegalStateException("Could not find dependency_hashes.txt on classpath");
        }
        DependencyHashCache depCache = DependencyHashCache.load(Util.getPath(depHashCacheUrl.toURI()));
        File output = (File)options.valueOf((OptionSpec)outputO);
        File cache = (File)options.valueOf((OptionSpec)cacheO);
        Path cachePath = cache == null ? Paths.get("cache", new String[0]) : cache.toPath();
        File extraMappings = (File)options.valueOf((OptionSpec)extraMappingsO);
        Path extraMappingsPath = extraMappings == null ? null : extraMappings.toPath();
        boolean startOver = options.has((OptionSpec)startOverO);
        boolean startOverIfRequired = !startOver && options.has((OptionSpec)startOverIfRequiredO);
        URL remote = options.has((OptionSpec)remoteO) ? (URL)options.valueOf((OptionSpec)remoteO) : null;
        boolean checkout = options.has((OptionSpec)checkoutO);
        boolean push = options.has((OptionSpec)pushO);
        MinecraftVersion startVer = options.has((OptionSpec)startVerO) ? MinecraftVersion.from((String)((String)options.valueOf((OptionSpec)startVerO))) : null;
        MinecraftVersion minecraftVersion = targetVer = options.has((OptionSpec)targetVerO) ? MinecraftVersion.from((String)((String)options.valueOf((OptionSpec)targetVerO))) : null;
        if (targetVer != null && targetVer.compareTo(startVer) < 0) {
            throw new IllegalArgumentException("Target version must be greater than or equal to start version");
        }
        Config.BranchSpec cliBranch = new Config.BranchSpec(options.has((OptionSpec)releasesOnlyO) ? "release" : "all", startVer, targetVer, null);
        String branchName = (String)options.valueOf((OptionSpec)branchNameO);
        if (options.has((OptionSpec)configO)) {
            URI configUri = (URI)options.valueOf((OptionSpec)configO);
            try {
                URL url = configUri.toURL();
                cfg = Util.downloadJson(s -> {}, url, Config.class);
            }
            catch (MalformedURLException e) {
                cfg = Config.load(Util.getPath(configUri));
            }
        } else {
            HashMap<String, Config.BranchSpec> branches = new HashMap<String, Config.BranchSpec>();
            branches.put("release", new Config.BranchSpec("release", null, null, null));
            branches.put("dev", new Config.BranchSpec("all", null, null, null));
            cfg = new Config(branches);
        }
        if (options.has((OptionSpec)committerO)) {
            String[] committer = ((String)options.valueOf((OptionSpec)committerO)).split(" ");
            if (committer.length != 2) {
                throw new IllegalArgumentException("Committer should be in the format 'name email'!");
            }
            Util.COMMITTER = new PersonIdent(committer[0], committer[1]);
        }
        try (Generator gen = new Generator(output.toPath(), cachePath, extraMappingsPath, depCache);){
            gen.setup(branchName, remote, checkout, push, cfg, cliBranch, startOver, startOverIfRequired);
            gen.run();
        }
    }
}

