/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.typeann;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class TypeAnnotationWriteHelper {
    @NotNull
    private final Deque<StructTypePathEntry> paths;
    @NotNull
    private final TypeAnnotation annotation;

    public TypeAnnotationWriteHelper(@NotNull TypeAnnotation annotation) {
        this(annotation, new ArrayDeque<StructTypePathEntry>(annotation.getPaths()));
    }

    public TypeAnnotationWriteHelper(@NotNull TypeAnnotation annotation, @NotNull Deque<StructTypePathEntry> paths) {
        this.annotation = annotation;
        this.paths = paths;
    }

    @NotNull
    public Deque<StructTypePathEntry> getPaths() {
        return this.paths;
    }

    @NotNull
    public TypeAnnotation getAnnotation() {
        return this.annotation;
    }

    public void writeTo(@NotNull StringBuilder sb) {
        this.annotation.writeTo(sb);
    }

    public void writeTo(@NotNull TextBuffer sb) {
        this.annotation.writeTo(sb);
    }

    public int arrayPathCount() {
        return (int)this.paths.stream().filter(entry -> entry.getTypePathEntryKind() == StructTypePathEntry.Kind.ARRAY.getId()).count();
    }

    public static List<TypeAnnotationWriteHelper> create(List<TypeAnnotation> typeAnnotations) {
        return typeAnnotations.stream().map(TypeAnnotationWriteHelper::new).collect(Collectors.toList());
    }
}

