/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class MonitorExprent
extends Exprent {
    public static final int MONITOR_ENTER = 0;
    public static final int MONITOR_EXIT = 1;
    private final int monType;
    private Exprent value;

    public MonitorExprent(int monType, Exprent value, BitSet bytecodeOffsets) {
        super(9);
        this.monType = monType;
        this.value = value;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        return new MonitorExprent(this.monType, this.value.copy(), this.bytecode);
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.value);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        tracer.addMapping(this.bytecode);
        if (this.monType == 0) {
            return this.value.toJava(indent, tracer).enclose("synchronized(", ")");
        }
        return new TextBuffer();
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.value) {
            this.value = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorExprent)) {
            return false;
        }
        MonitorExprent me = (MonitorExprent)o;
        return this.monType == me.getMonType() && Objects.equals(this.value, me.getValue());
    }

    public int getMonType() {
        return this.monType;
    }

    public Exprent getValue() {
        return this.value;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        MonitorExprent.measureBytecode(values, this.value);
        this.measureBytecode(values);
    }
}

