/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class FieldExprent
extends Exprent {
    private final String name;
    private final String classname;
    private final boolean isStatic;
    private Exprent instance;
    private final FieldDescriptor descriptor;
    private boolean forceQualified = false;

    public FieldExprent(LinkConstant cn, Exprent instance, BitSet bytecodeOffsets) {
        this(cn.elementname, cn.classname, instance == null, instance, FieldDescriptor.parseDescriptor(cn.descriptor), bytecodeOffsets);
    }

    public FieldExprent(String name, String classname, boolean isStatic, Exprent instance, FieldDescriptor descriptor, BitSet bytecodeOffsets) {
        this(name, classname, isStatic, instance, descriptor, bytecodeOffsets, false);
    }

    public FieldExprent(String name, String classname, boolean isStatic, Exprent instance, FieldDescriptor descriptor, BitSet bytecodeOffsets, boolean forceQualified) {
        super(5);
        this.name = name;
        this.classname = classname;
        this.isStatic = isStatic;
        this.instance = instance;
        this.descriptor = descriptor;
        this.forceQualified = forceQualified;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.type;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        Map<Object, Object> types = cl == null ? Collections.emptyMap() : cl.getAllGenerics();
        StructField ft = null;
        while (cl != null && (ft = cl.getField(this.name, this.descriptor.descriptorString)) == null) {
            cl = cl.superClass == null ? null : DecompilerContext.getStructContext().getClass((String)cl.superClass.value);
        }
        if (ft != null && ft.getSignature() != null) {
            VarType instType;
            VarType ret = ft.getSignature().type.remap(types.getOrDefault(cl.qualifiedName, Collections.emptyMap()));
            if (this.instance != null && cl.getSignature() != null && (instType = this.instance.getInferredExprType(null)).isGeneric() && instType.getType() != 18) {
                GenericType ginstance = (GenericType)instType;
                cl = DecompilerContext.getStructContext().getClass(instType.getValue());
                if (cl != null && cl.getSignature() != null) {
                    HashMap<VarType, VarType> tempMap = new HashMap<VarType, VarType>();
                    cl.getSignature().genericType.mapGenVarsTo(ginstance, tempMap);
                    VarType _new = ret.remap(tempMap);
                    if (_new != null) {
                        ret = _new;
                    }
                }
            }
            return ret;
        }
        return this.getExprType();
    }

    @Override
    public int getExprentUse() {
        return this.instance == null ? 1 : this.instance.getExprentUse() & 1;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        if (this.instance != null) {
            lst.add(this.instance);
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        return new FieldExprent(this.name, this.classname, this.isStatic, this.instance == null ? null : this.instance.copy(), this.descriptor, this.bytecode);
    }

    private boolean isAmbiguous() {
        StructLocalVariableTableAttribute attr;
        MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        if (method != null && (attr = method.methodStruct.getLocalVariableAttr()) != null) {
            return attr.containsName(this.name);
        }
        return false;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        if (this.isStatic) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.classname.equals(node.classStruct.qualifiedName) || this.isAmbiguous() || this.forceQualified) {
                buf.append(DecompilerContext.getImportCollector().getNestedNameInClassContext(ExprProcessor.buildJavaClassName(this.classname)));
                buf.append(".");
            }
        } else {
            String super_qualifier = null;
            if (this.instance != null && this.instance.type == 12) {
                String this_classname;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair pair = new VarVersionPair(instVar);
                MethodWrapper currentMethod = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
                if (currentMethod != null && (this_classname = currentMethod.varproc.getThisVars().get(pair)) != null && !this.classname.equals(this_classname)) {
                    super_qualifier = this_classname;
                }
            }
            if (super_qualifier != null) {
                TextUtil.writeQualifiedSuper(buf, super_qualifier);
            } else {
                TextBuffer buff = new TextBuffer();
                boolean casted = ExprProcessor.getCastedExprent(this.instance, new VarType(8, 0, this.classname), buff, indent, true, tracer);
                Object res = buff.toString();
                if (casted || this.instance.getPrecedence() > this.getPrecedence()) {
                    res = "(" + (String)res + ")";
                }
                buf.append((String)res);
            }
            if (buf.toString().equals("<VAR_NAMELESS_ENCLOSURE>")) {
                buf.setLength(0);
            } else {
                buf.append(".");
            }
        }
        buf.append(this.name);
        tracer.addMapping(this.bytecode);
        return buf;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldExprent)) {
            return false;
        }
        FieldExprent ft = (FieldExprent)o;
        return Objects.equals(this.name, ft.getName()) && Objects.equals(this.classname, ft.getClassname()) && this.isStatic == ft.isStatic() && Objects.equals(this.instance, ft.getInstance()) && Objects.equals(this.descriptor, ft.getDescriptor());
    }

    public String getClassname() {
        return this.classname;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void forceQualified(boolean value) {
        this.forceQualified = value;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        FieldExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRules().get((Object)IMatchable.MatchProperties.EXPRENT_FIELD_NAME);
        if (rule != null) {
            if (rule.isVariable()) {
                return engine.checkAndSetVariableValue((String)rule.value, this.name);
            }
            return rule.value.equals(this.name);
        }
        return true;
    }
}

