/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructEnclosingMethodAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class NestedClassProcessor {
    public void processClass(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode node) {
        ClassesProcessor.ClassNode node_content;
        if (node.type == 8 && !node.lambdaInformation.is_method_reference && (node_content = DecompilerContext.getClassProcessor().getMapRootClasses().get(node.classStruct.qualifiedName)) != null && node_content.getWrapper() != null) {
            node_content.getWrapper().getHiddenMembers().add(node.lambdaInformation.content_method_key);
        }
        if (node.nested.isEmpty()) {
            return;
        }
        if (node.type != 8) {
            NestedClassProcessor.computeLocalVarsAndDefinitions(node);
            NestedClassProcessor.checkNotFoundClasses(root, node);
        }
        int nameless = 0;
        int synthetics = 0;
        for (ClassesProcessor.ClassNode child : node.nested) {
            StructClass cl = child.classStruct;
            if (child.type != 4 && child.type != 1 || child.simpleName != null) continue;
            if ((child.access & 0x1000) != 0 || cl.isSynthetic()) {
                child.simpleName = "SyntheticClass_" + ++synthetics;
                continue;
            }
            String message = "Nameless local or member class " + cl.qualifiedName + "!";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
            child.simpleName = "NamelessClass_" + ++nameless;
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            MethodWrapper enclosingMethodWrapper;
            if (child.type == 8) {
                NestedClassProcessor.setLambdaVars(node, child);
                continue;
            }
            if (child.type == 1 && (child.access & 8) != 0) continue;
            NestedClassProcessor.insertLocalVars(node, child);
            if (child.type != 4 || child.enclosingMethod == null || (enclosingMethodWrapper = node.getWrapper().getMethods().getWithKey(child.enclosingMethod)) == null) continue;
            NestedClassProcessor.setLocalClassDefinition(enclosingMethodWrapper, child);
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.processClass(root, child);
        }
    }

    private static void setLambdaVars(ClassesProcessor.ClassNode parent, ClassesProcessor.ClassNode child) {
        if (child.lambdaInformation.is_method_reference) {
            return;
        }
        MethodWrapper method = parent.getWrapper().getMethods().getWithKey(child.lambdaInformation.content_method_key);
        MethodWrapper enclosingMethod = parent.getWrapper().getMethods().getWithKey(child.enclosingMethod);
        MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(child.lambdaInformation.method_descriptor);
        MethodDescriptor md_content = MethodDescriptor.parseDescriptor(child.lambdaInformation.content_method_descriptor);
        int vars_count = md_content.params.length - md_lambda.params.length;
        boolean is_static_lambda_content = child.lambdaInformation.is_content_method_static;
        String parent_class_name = parent.getWrapper().getClassStruct().qualifiedName;
        String lambda_class_name = child.simpleName;
        VarType lambda_class_type = new VarType(lambda_class_name, true);
        if (!is_static_lambda_content && DecompilerContext.getOption("lac")) {
            method.varproc.getThisVars().put(new VarVersionPair(0, 0), parent_class_name);
            method.varproc.setVarName(new VarVersionPair(0, 0), parent.simpleName + ".this");
        }
        HashMap mapNewNames = new HashMap();
        HashMap lvts = new HashMap();
        enclosingMethod.getOrBuildGraph().iterateExprents(arg_0 -> NestedClassProcessor.lambda$setLambdaVars$0(enclosingMethod, lambda_class_type, is_static_lambda_content, md_content, vars_count, mapNewNames, lvts, method, arg_0));
        HashSet setNewOuterNames = new HashSet(mapNewNames.values());
        setNewOuterNames.removeAll(method.setOuterVarNames);
        method.setOuterVarNames.addAll(setNewOuterNames);
        for (Map.Entry entry : mapNewNames.entrySet()) {
            VarVersionPair pair = (VarVersionPair)entry.getKey();
            StructLocalVariableTableAttribute.LocalVariable lvt = (StructLocalVariableTableAttribute.LocalVariable)lvts.get(pair);
            method.varproc.setVarName(pair, (String)entry.getValue());
            if (lvt == null) continue;
            method.varproc.setVarLVT(pair, lvt);
        }
        method.getOrBuildGraph().iterateExprentsDeep(exp -> {
            if (exp.type == 12) {
                VarExprent var = (VarExprent)exp;
                StructLocalVariableTableAttribute.LocalVariable lv = (StructLocalVariableTableAttribute.LocalVariable)lvts.get(var.getVarVersionPair());
                if (lv != null) {
                    var.setLVT(lv);
                } else if (mapNewNames.containsKey(var.getVarVersionPair())) {
                    var.setLVT(null);
                }
            }
            return 0;
        });
    }

    private static void checkNotFoundClasses(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode node) {
        ArrayList<ClassesProcessor.ClassNode> copy = new ArrayList<ClassesProcessor.ClassNode>(node.nested);
        for (ClassesProcessor.ClassNode child : copy) {
            String message;
            StructEnclosingMethodAttribute attr;
            if (child.classStruct.isSynthetic() || child.type != 4 && child.type != 2 || child.enclosingMethod != null) continue;
            Set<String> setEnclosing = child.enclosingClasses;
            if (!setEnclosing.isEmpty() && (attr = child.classStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD)) != null && attr.getMethodName() != null && node.classStruct.qualifiedName.equals(attr.getClassName()) && node.classStruct.getMethod(attr.getMethodName(), attr.getMethodDescriptor()) != null) {
                child.enclosingMethod = InterpreterUtil.makeUniqueKey(attr.getMethodName(), attr.getMethodDescriptor());
                continue;
            }
            node.nested.remove(child);
            child.parent = null;
            setEnclosing.remove(node.classStruct.qualifiedName);
            boolean hasEnclosing = !setEnclosing.isEmpty() && NestedClassProcessor.insertNestedClass(root, child);
            if (hasEnclosing) continue;
            if (child.type == 2) {
                message = "Unreferenced anonymous class " + child.classStruct.qualifiedName + "!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                continue;
            }
            if (child.type != 4) continue;
            message = "Unreferenced local class " + child.classStruct.qualifiedName + "!";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
    }

    private static boolean insertNestedClass(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode child) {
        Set<String> setEnclosing = child.enclosingClasses;
        LinkedList<ClassesProcessor.ClassNode> stack = new LinkedList<ClassesProcessor.ClassNode>();
        stack.add(root);
        while (!stack.isEmpty()) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)stack.removeFirst();
            if (setEnclosing.contains(node.classStruct.qualifiedName)) {
                node.nested.add(child);
                child.parent = node;
                Collections.sort(node.nested);
                return true;
            }
            stack.addAll(node.nested);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void computeLocalVarsAndDefinitions(ClassesProcessor.ClassNode node) {
        HashMap<String, Map<String, List<VarFieldPair>>> mapVarMasks = new HashMap<String, Map<String, List<VarFieldPair>>>();
        int clTypes = 0;
        for (ClassesProcessor.ClassNode nd : node.nested) {
            if (nd.type == 8 || nd.classStruct.isSynthetic() || (nd.access & 8) != 0 || (nd.access & 0x200) != 0) continue;
            clTypes |= nd.type;
            Map<String, List<VarFieldPair>> mask = NestedClassProcessor.getMaskLocalVars(nd.getWrapper());
            if (mask.isEmpty()) {
                String message = "Nested class " + nd.classStruct.qualifiedName + " has no constructor!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                continue;
            }
            mapVarMasks.put(nd.classStruct.qualifiedName, mask);
        }
        HashMap mapVarFieldPairs = new HashMap();
        if (clTypes != 1) {
            for (MethodWrapper method : node.getWrapper().getMethods()) {
                if (method.root == null) continue;
                DotExporter.toDotFile(method.getOrBuildGraph(), method.methodStruct, "computeLocalVars");
                method.getOrBuildGraph().iterateExprents(exprent -> {
                    List<Exprent> lst = exprent.getAllExprents(true);
                    lst.add(exprent);
                    for (Exprent expr : lst) {
                        InvocationExprent constructor;
                        if (expr.type != 10 || (constructor = ((NewExprent)expr).getConstructor()) == null || !mapVarMasks.containsKey(constructor.getClassName())) continue;
                        String refClassName = constructor.getClassName();
                        ClassesProcessor.ClassNode nestedClassNode = node.getClassNode(refClassName);
                        if (nestedClassNode.type == 1) continue;
                        List mask = (List)((Map)mapVarMasks.get(refClassName)).get(constructor.getStringDescriptor());
                        if (!mapVarFieldPairs.containsKey(refClassName)) {
                            mapVarFieldPairs.put(refClassName, new HashMap());
                        }
                        ArrayList<VarFieldPair> lstTemp = new ArrayList<VarFieldPair>();
                        for (int i = 0; i < mask.size(); ++i) {
                            Exprent param = constructor.getParameters().get(i);
                            VarFieldPair pair = null;
                            if (param.type == 12 && mask.get(i) != null) {
                                VarVersionPair varPair = new VarVersionPair((VarExprent)param);
                                pair = new VarFieldPair(((VarFieldPair)mask.get((int)i)).fieldKey, varPair);
                            }
                            lstTemp.add(pair);
                        }
                        ArrayList<VarFieldPair> pairMask = (ArrayList<VarFieldPair>)((Map)mapVarFieldPairs.get(refClassName)).get(constructor.getStringDescriptor());
                        if (pairMask == null) {
                            pairMask = lstTemp;
                        } else {
                            for (int i = 0; i < pairMask.size(); ++i) {
                                if (Objects.equals(pairMask.get(i), lstTemp.get(i))) continue;
                                pairMask.set(i, null);
                            }
                        }
                        ((Map)mapVarFieldPairs.get(refClassName)).put(constructor.getStringDescriptor(), pairMask);
                        nestedClassNode.enclosingMethod = InterpreterUtil.makeUniqueKey(method.methodStruct.getName(), method.methodStruct.getDescriptor());
                    }
                    return 0;
                });
            }
        }
        for (Map.Entry enclosing : mapVarMasks.entrySet()) {
            Object mask22;
            ClassesProcessor.ClassNode nestedNode = node.getClassNode((String)enclosing.getKey());
            ArrayList<VarFieldPair> interPairMask = null;
            if (mapVarFieldPairs.containsKey(enclosing.getKey())) {
                for (Object mask22 : ((Map)mapVarFieldPairs.get(enclosing.getKey())).values()) {
                    if (interPairMask == null) {
                        interPairMask = new ArrayList(mask22);
                        continue;
                    }
                    NestedClassProcessor.mergeListSignatures(interPairMask, (List<VarFieldPair>)mask22, false);
                }
            }
            ArrayList interMask = null;
            mask22 = ((Map)enclosing.getValue()).values().iterator();
            while (mask22.hasNext()) {
                List list = (List)mask22.next();
                if (interMask == null) {
                    interMask = new ArrayList(list);
                    continue;
                }
                NestedClassProcessor.mergeListSignatures(interMask, list, false);
            }
            if (interPairMask == null) {
                void var10_14;
                interPairMask = interMask != null ? new ArrayList<VarFieldPair>(interMask) : new ArrayList();
                boolean found = false;
                boolean bl = false;
                while (var10_14 < interPairMask.size()) {
                    if (interPairMask.get((int)var10_14) != null) {
                        if (found) {
                            interPairMask.set((int)var10_14, null);
                        }
                        found = true;
                    }
                    ++var10_14;
                }
            }
            NestedClassProcessor.mergeListSignatures(interPairMask, interMask, true);
            for (VarFieldPair varFieldPair : interPairMask) {
                if (varFieldPair == null || varFieldPair.fieldKey.isEmpty()) continue;
                nestedNode.mapFieldsToVars.put(varFieldPair.fieldKey, varFieldPair.varPair);
            }
            for (Map.Entry entry : ((Map)enclosing.getValue()).entrySet()) {
                NestedClassProcessor.mergeListSignatures((List)entry.getValue(), interPairMask, false);
                ArrayList<VarVersionPair> mask4 = new ArrayList<VarVersionPair>(((List)entry.getValue()).size());
                for (VarFieldPair pair : (List)entry.getValue()) {
                    mask4.add(pair != null && !pair.fieldKey.isEmpty() ? pair.varPair : null);
                }
                nestedNode.getWrapper().getMethodWrapper((String)"<init>", (String)((String)entry.getKey())).synthParameters = mask4;
            }
        }
    }

    private static void insertLocalVars(ClassesProcessor.ClassNode parent, final ClassesProcessor.ClassNode child) {
        MethodWrapper enclosingMethod = parent.getWrapper().getMethods().getWithKey(child.enclosingMethod);
        for (final MethodWrapper method : child.getWrapper().getMethods()) {
            if (method.root == null) continue;
            HashMap<VarVersionPair, Object> mapNewNames = new HashMap<VarVersionPair, Object>();
            HashMap<VarVersionPair, VarType> mapNewTypes = new HashMap<VarVersionPair, VarType>();
            HashMap<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable> mapNewLVTs = new HashMap<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable>();
            final HashMap<Integer, VarVersionPair> mapParamsToNewVars = new HashMap<Integer, VarVersionPair>();
            if (method.synthParameters != null) {
                int index = 0;
                int varIndex = 1;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(method.methodStruct.getDescriptor());
                for (VarVersionPair pair : method.synthParameters) {
                    if (pair != null) {
                        VarVersionPair newVar = new VarVersionPair(method.counter.getCounterAndIncrement(2), 0);
                        mapParamsToNewVars.put(varIndex, newVar);
                        Object varName = null;
                        VarType varType = null;
                        StructLocalVariableTableAttribute.LocalVariable varLVT = null;
                        if (child.type != 1) {
                            varName = enclosingMethod.varproc.getVarName(pair);
                            varType = enclosingMethod.varproc.getVarType(pair);
                            varLVT = enclosingMethod.varproc.getVarLVT(pair);
                            enclosingMethod.varproc.setVarFinal(pair, 2);
                        }
                        if (pair.var == -1 || "this".equals(varName) || varLVT != null && "this".equals(varLVT.getName())) {
                            varName = parent.simpleName == null ? "<VAR_NAMELESS_ENCLOSURE>" : parent.simpleName + ".this";
                            if (varLVT != null) {
                                varLVT = varLVT.rename((String)varName);
                            }
                            method.varproc.getThisVars().put(newVar, parent.classStruct.qualifiedName);
                        }
                        mapNewNames.put(newVar, varName);
                        mapNewTypes.put(newVar, varType);
                        mapNewLVTs.put(newVar, varLVT);
                    }
                    varIndex += md.params[index++].getStackSize();
                }
            }
            final HashMap<String, VarVersionPair> mapFieldsToNewVars = new HashMap<String, VarVersionPair>();
            ClassesProcessor.ClassNode classNode = child;
            while (classNode != null) {
                for (Map.Entry<String, VarVersionPair> entry : classNode.mapFieldsToVars.entrySet()) {
                    VarVersionPair newVar = new VarVersionPair(method.counter.getCounterAndIncrement(2), 0);
                    mapFieldsToNewVars.put(InterpreterUtil.makeUniqueKey(classNode.classStruct.qualifiedName, entry.getKey()), newVar);
                    Object varName = null;
                    VarType varType = null;
                    StructLocalVariableTableAttribute.LocalVariable varLVT = null;
                    if (classNode.type != 1) {
                        MethodWrapper enclosing_method = classNode.parent.getWrapper().getMethods().getWithKey(classNode.enclosingMethod);
                        varName = enclosing_method.varproc.getVarName(entry.getValue());
                        varType = enclosing_method.varproc.getVarType(entry.getValue());
                        varLVT = enclosing_method.varproc.getVarLVT(entry.getValue());
                        enclosing_method.varproc.setVarFinal(entry.getValue(), 2);
                    }
                    if (entry.getValue().var == -1 || "this".equals(varName) || varLVT != null && "this".equals(varLVT.getName())) {
                        varName = classNode.parent.simpleName == null ? "<VAR_NAMELESS_ENCLOSURE>" : classNode.parent.simpleName + ".this";
                        if (varLVT != null) {
                            varLVT = varLVT.rename((String)varName);
                        }
                        method.varproc.getThisVars().put(newVar, classNode.parent.classStruct.qualifiedName);
                    }
                    mapNewNames.put(newVar, varName);
                    mapNewTypes.put(newVar, varType);
                    mapNewLVTs.put(newVar, varLVT);
                    if (classNode != child) continue;
                    StructField fd = child.classStruct.getFields().getWithKey(entry.getKey());
                    child.getWrapper().getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                }
                classNode = classNode.parent;
            }
            HashSet<String> setNewOuterNames = new HashSet<String>(mapNewNames.values());
            setNewOuterNames.removeAll(method.setOuterVarNames);
            method.varproc.refreshVarNames(new VarNamesCollector(setNewOuterNames));
            method.setOuterVarNames.addAll(setNewOuterNames);
            for (Map.Entry<String, VarVersionPair> entry : mapNewNames.entrySet()) {
                VarVersionPair pair;
                pair = (VarVersionPair)((Object)entry.getKey());
                VarType type = (VarType)mapNewTypes.get(pair);
                StructLocalVariableTableAttribute.LocalVariable lvt = (StructLocalVariableTableAttribute.LocalVariable)mapNewLVTs.get(pair);
                method.varproc.setVarName(pair, (String)((Object)entry.getValue()));
                if (type != null) {
                    method.varproc.setVarType(pair, type);
                }
                if (lvt == null) continue;
                method.varproc.setVarLVT(pair, lvt);
            }
            NestedClassProcessor.iterateExprents(method.getOrBuildGraph(), new ExprentIteratorWithReplace(){

                @Override
                public Exprent processExprent(Exprent exprent) {
                    InvocationExprent invokeExpr;
                    if (exprent.type == 2) {
                        AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                        if (assignExpr.getLeft().type == 5) {
                            FieldExprent fExpr = (FieldExprent)assignExpr.getLeft();
                            String qName = child.classStruct.qualifiedName;
                            if (fExpr.getClassname().equals(qName) && mapFieldsToNewVars.containsKey(InterpreterUtil.makeUniqueKey(qName, fExpr.getName(), fExpr.getDescriptor().descriptorString))) {
                                return null;
                            }
                        }
                    }
                    if (child.type == 2 && "<init>".equals(method.methodStruct.getName()) && exprent.type == 8 && (invokeExpr = (InvocationExprent)exprent).getFuncType() == 2) {
                        child.superInvocation = invokeExpr;
                        return null;
                    }
                    Exprent ret = this.replaceExprent(exprent);
                    return ret == null ? exprent : ret;
                }

                private Exprent replaceExprent(Exprent exprent) {
                    FieldExprent fExpr;
                    String key;
                    if (exprent.type == 12) {
                        int varIndex = ((VarExprent)exprent).getIndex();
                        if (mapParamsToNewVars.containsKey(varIndex)) {
                            VarVersionPair newVar = (VarVersionPair)mapParamsToNewVars.get(varIndex);
                            method.varproc.getExternalVars().add(newVar);
                            VarExprent ret = new VarExprent(newVar.var, method.varproc.getVarType(newVar), method.varproc, exprent.bytecode);
                            StructLocalVariableTableAttribute.LocalVariable lvt = method.varproc.getVarLVT(newVar);
                            if (lvt != null) {
                                ret.setLVT(lvt);
                            }
                            return ret;
                        }
                    } else if (exprent.type == 5 && mapFieldsToNewVars.containsKey(key = InterpreterUtil.makeUniqueKey((fExpr = (FieldExprent)exprent).getClassname(), fExpr.getName(), fExpr.getDescriptor().descriptorString))) {
                        VarVersionPair newVar = (VarVersionPair)mapFieldsToNewVars.get(key);
                        method.varproc.getExternalVars().add(newVar);
                        VarExprent ret = new VarExprent(newVar.var, method.varproc.getVarType(newVar), method.varproc, exprent.bytecode);
                        StructLocalVariableTableAttribute.LocalVariable lvt = method.varproc.getVarLVT(newVar);
                        if (lvt != null) {
                            ret.setLVT(lvt);
                        }
                        return ret;
                    }
                    boolean replaced = true;
                    block0: while (replaced) {
                        replaced = false;
                        for (Exprent expr : exprent.getAllExprents()) {
                            Exprent retExpr = this.replaceExprent(expr);
                            if (retExpr == null) continue;
                            exprent.replaceExprent(expr, retExpr);
                            replaced = true;
                            continue block0;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private static Map<String, List<VarFieldPair>> getMaskLocalVars(ClassWrapper wrapper) {
        HashMap<String, List<VarFieldPair>> mapMasks = new HashMap<String, List<VarFieldPair>>();
        StructClass cl = wrapper.getClassStruct();
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            MethodWrapper method = wrapper.getMethodWrapper("<init>", mt.getDescriptor());
            DirectGraph graph = method.getOrBuildGraph();
            if (graph == null) continue;
            ArrayList<VarFieldPair> fields = new ArrayList<VarFieldPair>(md.params.length);
            int varIndex = 1;
            for (int i = 0; i < md.params.length; ++i) {
                String keyField = NestedClassProcessor.getEnclosingVarField(cl, method, graph, varIndex);
                fields.add(keyField == null ? null : new VarFieldPair(keyField, new VarVersionPair(-1, 0)));
                varIndex += md.params[i].getStackSize();
            }
            mapMasks.put(mt.getDescriptor(), fields);
        }
        return mapMasks;
    }

    private static String getEnclosingVarField(StructClass cl, MethodWrapper method, DirectGraph graph, int index) {
        String field = "";
        if (method.varproc.getVarFinal(new VarVersionPair(index, 0)) == 1) {
            return null;
        }
        boolean noSynthFlag = DecompilerContext.getOption("nns");
        DirectNode firstNode = graph.first;
        if (firstNode.predecessors.isEmpty()) {
            for (Exprent exprent : firstNode.exprents) {
                FieldExprent left;
                StructField fd;
                if (exprent.type != 2) continue;
                AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                if (assignExpr.getRight().type != 12 || ((VarExprent)assignExpr.getRight()).getIndex() != index || assignExpr.getLeft().type != 5 || (fd = cl.getField((left = (FieldExprent)assignExpr.getLeft()).getName(), left.getDescriptor().descriptorString)) == null || !cl.qualifiedName.equals(left.getClassname()) || !fd.isSynthetic() && (!noSynthFlag || !NestedClassProcessor.possiblySyntheticField(fd))) continue;
                field = InterpreterUtil.makeUniqueKey(left.getName(), left.getDescriptor().descriptorString);
                break;
            }
        }
        return field;
    }

    private static boolean possiblySyntheticField(StructField fd) {
        return fd.getName().contains("$") && fd.hasModifier(16) && fd.hasModifier(2);
    }

    private static void mergeListSignatures(List<VarFieldPair> first, List<VarFieldPair> second, boolean both) {
        int j;
        VarFieldPair sObj;
        int i;
        for (i = 1; first.size() > i && second.size() > i; ++i) {
            VarFieldPair fObj = first.get(first.size() - i);
            if (!NestedClassProcessor.isEqual(both, fObj, sObj = second.get(second.size() - i))) {
                first.set(first.size() - i, null);
                if (!both) continue;
                second.set(second.size() - i, null);
                continue;
            }
            if (fObj == null) continue;
            if (fObj.varPair.var == -1) {
                fObj.varPair = sObj.varPair;
                continue;
            }
            sObj.varPair = fObj.varPair;
        }
        for (j = 1; j <= first.size() - i; ++j) {
            first.set(j, null);
        }
        if (both) {
            for (j = 1; j <= second.size() - i; ++j) {
                second.set(j, null);
            }
        }
        if (first.isEmpty()) {
            if (!second.isEmpty() && both) {
                second.set(0, null);
            }
        } else if (second.isEmpty()) {
            first.set(0, null);
        } else {
            VarFieldPair fObj = first.get(0);
            if (!NestedClassProcessor.isEqual(both, fObj, sObj = second.get(0))) {
                first.set(0, null);
                if (both) {
                    second.set(0, null);
                }
            } else if (fObj != null) {
                if (fObj.varPair.var == -1) {
                    fObj.varPair = sObj.varPair;
                } else {
                    sObj.varPair = fObj.varPair;
                }
            }
        }
    }

    private static boolean isEqual(boolean both, VarFieldPair fObj, VarFieldPair sObj) {
        boolean eq;
        if (fObj == null || sObj == null) {
            eq = fObj == sObj;
        } else {
            eq = true;
            if (fObj.fieldKey.length() == 0) {
                fObj.fieldKey = sObj.fieldKey;
            } else if (sObj.fieldKey.length() == 0) {
                if (both) {
                    sObj.fieldKey = fObj.fieldKey;
                }
            } else {
                eq = fObj.fieldKey.equals(sObj.fieldKey);
            }
        }
        return eq;
    }

    private static void setLocalClassDefinition(MethodWrapper method, ClassesProcessor.ClassNode node) {
        Statement first;
        RootStatement root = method.root;
        VarType classType = new VarType(node.classStruct.qualifiedName, true);
        HashSet<Statement> setStats = new HashSet<Statement>();
        Statement statement = NestedClassProcessor.getDefStatement(root, classType, setStats);
        if (statement == null) {
            statement = root.getFirst();
        }
        List<Exprent> lst = (first = NestedClassProcessor.findFirstBlock(statement, setStats)) == null ? statement.getVarDefinitions() : (first.getExprents() == null ? first.getVarDefinitions() : first.getExprents());
        int addIndex = 0;
        for (Exprent expr : lst) {
            if (NestedClassProcessor.searchForClass(expr, classType)) break;
            ++addIndex;
        }
        VarExprent var = new VarExprent(method.counter.getCounterAndIncrement(2), classType, method.varproc);
        var.setDefinition(true);
        var.setClassDef(true);
        lst.add(addIndex, var);
    }

    private static Statement findFirstBlock(Statement stat, Set<Statement> setStats) {
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(stat);
        block4: while (!stack.isEmpty()) {
            Statement st = (Statement)stack.remove(0);
            if (!stack.isEmpty() && !setStats.contains(st)) continue;
            if (st.isLabeled() && !stack.isEmpty() || st.getExprents() != null) {
                return st;
            }
            stack.clear();
            switch (st.type) {
                case SEQUENCE: {
                    stack.addAll(0, st.getStats());
                    continue block4;
                }
                case IF: 
                case ROOT: 
                case SWITCH: 
                case SYNCHRONIZED: {
                    stack.add(st.getFirst());
                    continue block4;
                }
            }
            return st;
        }
        return null;
    }

    private static Statement getDefStatement(Statement stat, VarType classType, Set<? super Statement> setStats) {
        List<Object> lst = new ArrayList();
        Statement retStat = null;
        if (stat.getExprents() == null) {
            int counter = 0;
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    Statement st = (Statement)obj;
                    Statement stTemp = NestedClassProcessor.getDefStatement(st, classType, setStats);
                    if (stTemp != null) {
                        if (counter == 1) {
                            retStat = stat;
                            break;
                        }
                        retStat = stTemp;
                        ++counter;
                    }
                    if (st.type != Statement.StatementType.DO) continue;
                    DoStatement dost = (DoStatement)st;
                    lst.addAll(dost.getInitExprentList());
                    lst.addAll(dost.getConditionExprentList());
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                lst.add((Exprent)obj);
            }
        } else {
            lst = stat.getExprents();
        }
        if (retStat != stat) {
            for (Exprent exprent : lst) {
                if (exprent == null || !NestedClassProcessor.searchForClass(exprent, classType)) continue;
                retStat = stat;
                break;
            }
        }
        if (retStat != null) {
            setStats.add(stat);
        }
        return retStat;
    }

    private static boolean searchForClass(Exprent exprent, VarType classType) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        String classname = classType.getValue();
        for (Exprent expr : lst) {
            boolean res = false;
            switch (expr.type) {
                case 3: {
                    ConstExprent constExpr = (ConstExprent)expr;
                    res = VarType.VARTYPE_CLASS.equals(constExpr.getConstType()) && classname.equals(constExpr.getValue()) || classType.equals(constExpr.getConstType());
                    break;
                }
                case 5: {
                    res = classname.equals(((FieldExprent)expr).getClassname());
                    break;
                }
                case 8: {
                    res = classname.equals(((InvocationExprent)expr).getClassName());
                    break;
                }
                case 10: {
                    VarType newType = ((NewExprent)expr).getNewType();
                    res = newType.getType() == 8 && classname.equals(newType.getValue());
                    break;
                }
                case 12: {
                    VarExprent varExpr = (VarExprent)expr;
                    if (!varExpr.isDefinition()) break;
                    Stack<VarType> stack = new Stack<VarType>();
                    stack.push(varExpr.getDefinitionType());
                    while (!stack.isEmpty()) {
                        VarType varType = (VarType)stack.pop();
                        if (classType.equals(varType) || varType.getArrayDim() > 0 && classType.getValue().equals(varType.getValue())) {
                            res = true;
                            continue;
                        }
                        if (!varType.isGeneric()) continue;
                        ((GenericType)varType).getArguments().forEach(stack::push);
                    }
                    break;
                }
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    private static void iterateExprents(DirectGraph graph, ExprentIteratorWithReplace iter) {
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(graph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            for (int i = 0; i < node.exprents.size(); ++i) {
                Exprent res = iter.processExprent(node.exprents.get(i));
                if (res == null) {
                    node.exprents.remove(i);
                    --i;
                    continue;
                }
                if (res == node.exprents.get(i)) continue;
                node.exprents.set(i, res);
            }
            stack.addAll(node.successors);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ int lambda$setLambdaVars$0(MethodWrapper enclosingMethod, VarType lambda_class_type, boolean is_static_lambda_content, MethodDescriptor md_content, int vars_count, Map mapNewNames, Map lvts, MethodWrapper method, Exprent exprent) {
        lst = exprent.getAllExprents(true);
        lst.add(exprent);
        for (Exprent expr : lst) {
            if (expr.type != 10) continue;
            new_expr = (NewExprent)expr;
            enclosingCollector = new VarNamesCollector(enclosingMethod.varproc.getVarNames());
            if (!new_expr.isLambda() || !lambda_class_type.equals(new_expr.getNewType())) continue;
            inv_dynamic = new_expr.getConstructor();
            param_index = is_static_lambda_content != false ? 0 : 1;
            varIndex = is_static_lambda_content != false ? 0 : 1;
            for (i = 0; i < md_content.params.length; ++i) {
                varVersion = new VarVersionPair(varIndex, 0);
                if (i < vars_count) {
                    param = inv_dynamic.getParameters().get(param_index + i);
                    if (param.type == 12) {
                        mapNewNames.put(varVersion, enclosingMethod.varproc.getVarName(new VarVersionPair((VarExprent)param)));
                        lvts.put(varVersion, ((VarExprent)param).getLVT());
                        ** if (enclosingMethod.varproc.getVarFinal((VarVersionPair)new VarVersionPair((VarExprent)((VarExprent)param))) != 1) goto lbl26
                    }
                } else {
                    mapNewNames.put(varVersion, enclosingCollector.getFreeName(method.varproc.getVarName(varVersion)));
lbl-1000:
                    // 1 sources

                    {
                        // empty if block
                    }
                }
lbl26:
                // 4 sources

                varIndex += md_content.params[i].getStackSize();
            }
        }
        return 0;
    }

    private static class VarFieldPair {
        public String fieldKey;
        public VarVersionPair varPair;

        VarFieldPair(String field, VarVersionPair varPair) {
            this.fieldKey = field;
            this.varPair = varPair;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VarFieldPair)) {
                return false;
            }
            VarFieldPair pair = (VarFieldPair)o;
            return this.fieldKey.equals(pair.fieldKey) && this.varPair.equals(pair.varPair);
        }

        public int hashCode() {
            return this.fieldKey.hashCode() + this.varPair.hashCode();
        }
    }

    private static interface ExprentIteratorWithReplace {
        public Exprent processExprent(Exprent var1);
    }
}

