/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.ZipFileCache;

public class SingleFileSaver
implements IResultSaver {
    private final File target;
    private ZipOutputStream output;
    private Set<String> entries = new HashSet<String>();
    private final ZipFileCache openZips = new ZipFileCache();

    public SingleFileSaver(File target) {
        this.target = target;
    }

    @Override
    public void saveFolder(String path) {
        if (!"".equals(path)) {
            throw new UnsupportedOperationException("Targeted a single output, but tried to create a directory");
        }
    }

    @Override
    public void copyFile(String source, String path, String entryName) {
        throw new UnsupportedOperationException("Targeted a single output, but tried to copy file");
    }

    @Override
    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        throw new UnsupportedOperationException("Targeted a single output, but tried to save a class file");
    }

    @Override
    public void createArchive(String path, String archiveName, Manifest manifest) {
        if (this.output != null) {
            throw new UnsupportedOperationException("Attempted to write multiple archives at the same time");
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.target);
            this.output = new ZipOutputStream(stream);
            if (manifest != null) {
                ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
                manifestEntry.setTime(946684800L);
                this.output.putNextEntry(manifestEntry);
                manifest.write(this.output);
                this.output.closeEntry();
            }
        }
        catch (IOException e) {
            DecompilerContext.getLogger().writeMessage("Cannot create archive " + this.target, e);
        }
    }

    @Override
    public void saveDirEntry(String path, String archiveName, String entryName) {
        this.saveEntryData(path, archiveName, entryName, null, null);
    }

    @Override
    public void copyEntry(String source, String path, String archiveName, String entryName) {
        block9: {
            if (!this.checkEntry(entryName)) {
                return;
            }
            try {
                ZipFile srcArchive = this.openZips.get(source);
                ZipEntry entry = srcArchive.getEntry(entryName);
                if (entry == null) break block9;
                try (InputStream in = srcArchive.getInputStream(entry);){
                    ZipEntry newEntry = new ZipEntry(entryName);
                    newEntry.setTime(entry.getTime());
                    this.output.putNextEntry(newEntry);
                    in.transferTo(this.output);
                }
            }
            catch (IOException ex) {
                String message = "Cannot copy entry " + entryName + " from " + source + " to " + this.target;
                DecompilerContext.getLogger().writeMessage(message, ex);
            }
        }
    }

    @Override
    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content, int[] mapping) {
        this.saveEntryData(path, archiveName, entryName, content.getBytes(StandardCharsets.UTF_8), this.getCodeLineData(mapping));
    }

    private void saveEntryData(String path, String archiveName, String entryName, byte[] content, byte[] extra) {
        if (!this.checkEntry(entryName)) {
            return;
        }
        try {
            ZipEntry entry = new ZipEntry(entryName);
            entry.setTime(946684800L);
            if (extra != null) {
                entry.setExtra(extra);
            }
            this.output.putNextEntry(entry);
            if (content != null) {
                this.output.write(content);
            }
        }
        catch (IOException ex) {
            String message = "Cannot write entry " + entryName + " to " + this.target;
            DecompilerContext.getLogger().writeMessage(message, ex);
        }
    }

    @Override
    public void closeArchive(String path, String archiveName) {
        try {
            this.output.close();
            this.entries.clear();
            this.output = null;
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot close " + this.target, IFernflowerLogger.Severity.WARN);
        }
    }

    @Override
    public void close() throws IOException {
        this.openZips.close();
    }

    private boolean checkEntry(String entryName) {
        boolean added = this.entries.add(entryName);
        if (!added) {
            String message = "Zip entry " + entryName + " already exists in " + this.target;
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
        return added;
    }
}

