/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statements;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public final class InitializerProcessor {
    public static void extractInitializers(ClassWrapper wrapper) {
        MethodWrapper method = wrapper.getMethodWrapper("<clinit>", "()V");
        if (method != null && method.root != null) {
            InitializerProcessor.extractStaticInitializers(wrapper, method);
        }
        InitializerProcessor.extractDynamicInitializers(wrapper);
        InitializerProcessor.liftConstructor(wrapper);
        if (DecompilerContext.getOption("hes")) {
            InitializerProcessor.hideEmptySuper(wrapper);
        }
    }

    private static void liftConstructor(ClassWrapper wrapper) {
        block0: for (MethodWrapper method : wrapper.getMethods()) {
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null) {
                return;
            }
            int index = 0;
            List<Exprent> lstExprents = firstData.getExprents();
            for (Exprent exprent : lstExprents) {
                int action = 0;
                if (exprent.type == 2) {
                    StructField structField;
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5 && assignExpr.getRight().type == 12 && (fExpr = (FieldExprent)assignExpr.getLeft()).getClassname().equals(wrapper.getClassStruct().qualifiedName) && (structField = wrapper.getClassStruct().getField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) != null && structField.hasModifier(16)) {
                        action = 1;
                    }
                } else if (index > 0 && exprent.type == 8 && Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, true)) {
                    lstExprents.add(0, lstExprents.remove(index));
                    action = 2;
                }
                if (action != 1) continue block0;
                ++index;
            }
        }
    }

    private static void hideEmptySuper(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            InvocationExprent invExpr;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null || firstData.getExprents().isEmpty()) {
                return;
            }
            Exprent exprent = firstData.getExprents().get(0);
            if (exprent.type != 8 || !Statements.isInvocationInitConstructor(invExpr = (InvocationExprent)exprent, method, wrapper, false)) continue;
            List<VarVersionPair> mask = ExprUtil.getSyntheticParametersMask(invExpr.getClassName(), invExpr.getStringDescriptor(), invExpr.getParameters().size());
            boolean hideSuper = true;
            for (int i = 0; i < invExpr.getDescriptor().params.length; ++i) {
                ClassesProcessor.ClassNode node;
                if (mask != null && mask.get(i) != null) continue;
                VarType type = invExpr.getDescriptor().params[i];
                if (type.getType() == 8 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.getValue())) != null && (node.type == 2 || (node.access & 0x1000) != 0)) break;
                hideSuper = false;
                break;
            }
            if (!hideSuper) continue;
            firstData.getExprents().remove(0);
        }
    }

    public static void hideInitalizers(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            ClassesProcessor.ClassNode node;
            VarType type;
            StructMethod mt = method.methodStruct;
            String name = mt.getName();
            String desc = mt.getDescriptor();
            if (!mt.isSynthetic() || !"<init>".equals(name)) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(desc);
            if (md.params.length <= 0 || (type = md.params[md.params.length - 1]).getType() != 8 || ((node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.getValue())) == null || node.type != 2) && (node.access & 0x1000) == 0) continue;
            wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, desc));
        }
    }

    private static void extractStaticInitializers(ClassWrapper wrapper, MethodWrapper method) {
        RootStatement root = method.root;
        StructClass cl = wrapper.getClassStruct();
        HashSet<String> whitelist = new HashSet<String>();
        Statement firstData = Statements.findFirstData(root);
        if (firstData != null) {
            boolean inlineInitializers = cl.hasModifier(512) || cl.hasModifier(16384);
            LinkedList<AssignmentExprent> exprentsToRemove = new LinkedList<AssignmentExprent>();
            HashMap<Integer, AssignmentExprent> nonFieldAssigns = new HashMap<Integer, AssignmentExprent>();
            Iterator<Exprent> itr = firstData.getExprents().iterator();
            while (itr.hasNext()) {
                Exprent exprent = itr.next();
                boolean found = false;
                if (exprent.type == 2) {
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5) {
                        FieldExprent fExpr = (FieldExprent)assignExpr.getLeft();
                        if (fExpr.isStatic() && fExpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) {
                            String keyField = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                            boolean exprentIndependent = InitializerProcessor.isExprentIndependent(assignExpr.getRight(), method, cl, whitelist, cl.getFields().getIndexByKey(keyField), true);
                            if ((inlineInitializers || exprentIndependent) && !wrapper.getStaticFieldInitializers().containsKey(keyField)) {
                                found = true;
                                if (exprentIndependent) {
                                    wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                                    whitelist.add(keyField);
                                    itr.remove();
                                } else if (assignExpr.getRight() instanceof NewExprent) {
                                    NewExprent newExprent = (NewExprent)assignExpr.getRight();
                                    Exprent instance = newExprent.getConstructor().getInstance();
                                    if (instance instanceof VarExprent && nonFieldAssigns.containsKey(((VarExprent)instance).getIndex())) {
                                        AssignmentExprent nonFieldAssignment = (AssignmentExprent)nonFieldAssigns.remove(((VarExprent)instance).getIndex());
                                        newExprent.getConstructor().setInstance(nonFieldAssignment.getRight());
                                        exprentsToRemove.add(nonFieldAssignment);
                                        wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                                        whitelist.add(keyField);
                                        itr.remove();
                                    } else {
                                        DecompilerContext.getLogger().writeMessage("Don't know how to handle non independent " + assignExpr.getRight().getClass().getName(), IFernflowerLogger.Severity.ERROR);
                                    }
                                } else {
                                    DecompilerContext.getLogger().writeMessage("Don't know how to handle non independent " + assignExpr.getRight().getClass().getName(), IFernflowerLogger.Severity.ERROR);
                                }
                            }
                        }
                    } else if (inlineInitializers) {
                        DecompilerContext.getLogger().writeMessage("Found non field assignment when needing to force inline: " + assignExpr.toString(), IFernflowerLogger.Severity.TRACE);
                        if (assignExpr.getLeft() instanceof VarExprent) {
                            nonFieldAssigns.put(((VarExprent)assignExpr.getLeft()).getIndex(), assignExpr);
                        } else {
                            DecompilerContext.getLogger().writeMessage("Left isnt VarExprent :(", IFernflowerLogger.Severity.ERROR);
                        }
                    }
                } else if (inlineInitializers && cl.hasModifier(512)) {
                    DecompilerContext.getLogger().writeMessage("Non assignment found in initialiser when we're needing to inline all", IFernflowerLogger.Severity.ERROR);
                }
                if (found) continue;
                break;
            }
            if (exprentsToRemove.size() > 0) {
                firstData.getExprents().removeAll(exprentsToRemove);
            }
        }
    }

    private static void extractDynamicInitializers(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        boolean isAnonymous = DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)cl.qualifiedName).type == 2;
        ArrayList<List<Exprent>> lstFirst = new ArrayList<List<Exprent>>();
        ArrayList<MethodWrapper> lstMethodWrappers = new ArrayList<MethodWrapper>();
        for (MethodWrapper method : wrapper.getMethods()) {
            Statement firstData;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null || (firstData = Statements.findFirstData(method.root)) == null || firstData.getExprents().isEmpty()) continue;
            Exprent exprent = firstData.getExprents().get(0);
            if (!isAnonymous && (exprent.type != 8 || !Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, false))) continue;
            lstFirst.add(firstData.getExprents());
            lstMethodWrappers.add(method);
        }
        if (lstFirst.isEmpty()) {
            return;
        }
        HashSet<String> whitelist = new HashSet<String>(wrapper.getStaticFieldInitializers().getLstKeys());
        int prev_fidx = 0;
        block1: while (true) {
            List lst;
            String fieldWithDescr = null;
            Exprent value = null;
            for (int i = 0; i < lstFirst.size(); ++i) {
                lst = (List)lstFirst.get(i);
                if (lst.size() < (isAnonymous ? 1 : 2)) {
                    return;
                }
                Exprent exprent = (Exprent)lst.get(isAnonymous ? 0 : 1);
                boolean found = false;
                if (exprent.type == 2) {
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft().type == 5 && !(fExpr = (FieldExprent)assignExpr.getLeft()).isStatic() && fExpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) {
                        String fieldKey = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                        int fidx = cl.getFields().getIndexByKey(fieldKey);
                        if (prev_fidx <= fidx && InitializerProcessor.isExprentIndependent(assignExpr.getRight(), (MethodWrapper)lstMethodWrappers.get(i), cl, whitelist, fidx, false)) {
                            prev_fidx = fidx;
                            if (fieldWithDescr == null) {
                                fieldWithDescr = fieldKey;
                                value = assignExpr.getRight();
                            } else if (!fieldWithDescr.equals(fieldKey) || !value.equals(assignExpr.getRight())) {
                                return;
                            }
                            found = true;
                        }
                    }
                }
                if (found) continue;
                return;
            }
            if (wrapper.getDynamicFieldInitializers().containsKey(fieldWithDescr)) break;
            wrapper.getDynamicFieldInitializers().addWithKey(value, fieldWithDescr);
            whitelist.add(fieldWithDescr);
            Iterator iterator = lstFirst.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                lst = (List)iterator.next();
                lst.remove(isAnonymous ? 0 : 1);
            }
            break;
        }
    }

    private static boolean isExprentIndependent(Exprent exprent, MethodWrapper method, StructClass cl, Set<String> whitelist, int fidx, boolean isStatic) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        block5: for (Exprent expr : lst) {
            switch (expr.type) {
                case 12: {
                    String varName;
                    VarVersionPair varPair = new VarVersionPair((VarExprent)expr);
                    if (method.varproc.getExternalVars().contains(varPair) || (varName = method.varproc.getVarName(varPair)).equals("this") || varName.endsWith(".this")) continue block5;
                    return false;
                }
                case 5: {
                    FieldExprent fexpr = (FieldExprent)expr;
                    if (cl.hasField(fexpr.getName(), fexpr.getDescriptor().descriptorString)) {
                        String key = InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString);
                        if (isStatic) {
                            if (!fexpr.isStatic()) {
                                return false;
                            }
                            if (cl.getFields().getIndexByKey(key) < fidx) continue block5;
                            fexpr.forceQualified(true);
                            break;
                        }
                        if (!whitelist.contains(key)) {
                            return false;
                        }
                        if (cl.getFields().getIndexByKey(key) <= fidx) continue block5;
                        return false;
                    }
                    if (fexpr.isStatic() || fexpr.getInstance() != null) continue block5;
                    return false;
                }
                case 10: {
                    InitializerProcessor.makeLaterFieldsInLambdaQualified((NewExprent)expr, cl, fidx);
                }
            }
        }
        return true;
    }

    private static void makeLaterFieldsInLambdaQualified(NewExprent nexpr, StructClass cl, int fidx) {
        boolean isStatic = ((StructField)cl.getFields().get(fidx)).hasModifier(8);
        if (isStatic && nexpr.isLambda() && !nexpr.isMethodReference()) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(nexpr.getNewType().getValue());
            MethodWrapper wrapper = child.parent.getWrapper().getMethods().getWithKey(child.lambdaInformation.content_method_key);
            HashSet s = new HashSet();
            wrapper.getOrBuildGraph().iterateExprentsDeep(e -> {
                if (e.type == 5 || e.type == 10) {
                    s.add(e);
                }
                return 0;
            });
            s.stream().forEach(e -> {
                switch (e.type) {
                    case 5: {
                        FieldExprent fe = (FieldExprent)e;
                        if (!fe.isStatic() || !cl.hasField(fe.getName(), fe.getDescriptor().descriptorString)) break;
                        String key = InterpreterUtil.makeUniqueKey(fe.getName(), fe.getDescriptor().descriptorString);
                        if (fe.getInstance() != null || cl.getFields().getIndexByKey(key) <= fidx) break;
                        fe.forceQualified(true);
                        break;
                    }
                    case 10: {
                        InitializerProcessor.makeLaterFieldsInLambdaQualified((NewExprent)e, cl, fidx);
                    }
                }
            });
        }
    }
}

