/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.JumpInstruction;
import org.jetbrains.java.decompiler.code.SwitchInstruction;
import org.jetbrains.java.decompiler.util.TextUtil;

public class Instruction
implements CodeConstants {
    public final int opcode;
    public final int group;
    public final boolean wide;
    public final int bytecodeVersion;
    public final int length;
    protected final int[] operands;

    public static Instruction create(int opcode, boolean wide, int group, int bytecodeVersion, int[] operands, int length) {
        if (opcode >= 153 && opcode <= 166 || opcode == 198 || opcode == 199 || opcode == 168 || opcode == 201 || opcode == 167 || opcode == 200) {
            return new JumpInstruction(opcode, group, wide, bytecodeVersion, operands, length);
        }
        if (opcode == 170 || opcode == 171) {
            return new SwitchInstruction(opcode, group, wide, bytecodeVersion, operands, length);
        }
        return new Instruction(opcode, group, wide, bytecodeVersion, operands, length);
    }

    public static boolean equals(Instruction i1, Instruction i2) {
        return i1 != null && i2 != null && (i1 == i2 || i1.opcode == i2.opcode && i1.wide == i2.wide && i1.operandsCount() == i2.operandsCount());
    }

    public Instruction(int opcode, int group, boolean wide, int bytecodeVersion, int[] operands, int length) {
        this.opcode = opcode;
        this.group = group;
        this.wide = wide;
        this.bytecodeVersion = bytecodeVersion;
        this.operands = operands;
        this.length = length;
    }

    public void initInstruction(InstructionSequence seq) {
    }

    public int operandsCount() {
        return this.operands == null ? 0 : this.operands.length;
    }

    public int operand(int index) {
        return this.operands[index];
    }

    public boolean canFallThrough() {
        return this.opcode != 167 && this.opcode != 200 && this.opcode != 169 && (this.opcode < 172 || this.opcode > 177) && this.opcode != 191 && this.opcode != 168 && this.opcode != 170 && this.opcode != 171;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.wide) {
            res.append("@wide ");
        }
        res.append("@").append(TextUtil.getInstructionName(this.opcode));
        int len = this.operandsCount();
        for (int i = 0; i < len; ++i) {
            int op = this.operands[i];
            if (op < 0) {
                res.append(" -").append(Integer.toHexString(-op));
                continue;
            }
            res.append(" ").append(Integer.toHexString(op));
        }
        return res.toString();
    }

    public Instruction clone() {
        return Instruction.create(this.opcode, this.wide, this.group, this.bytecodeVersion, this.operands == null ? null : (int[])this.operands.clone(), this.length);
    }
}

