/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.tasks.init;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.snowblower.Generator;
import net.minecraftforge.snowblower.Main;
import net.minecraftforge.snowblower.util.Cache;
import net.minecraftforge.snowblower.util.Util;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;

public class InitTask {
    private static final String COMMIT_MESSAGE = "Initial commit";
    private final Consumer<String> logger;
    private final Path root;
    private final Git git;

    public InitTask(Consumer<String> logger, Path root, Git git) {
        this.logger = logger;
        this.root = root;
        this.git = git;
    }

    public void cleanup() throws IOException {
        for (String file : new String[]{"Snowblower.txt", ".gitattributes", ".gitignore", "gradlew", "gradlew.bat", "gradle"}) {
            Path target = this.root.resolve(file);
            if (Files.isDirectory(target, new LinkOption[0])) {
                Util.deleteRecursive(target);
                continue;
            }
            if (!Files.exists(target, new LinkOption[0])) continue;
            Files.delete(target);
        }
    }

    public boolean validate(MinecraftVersion start) throws IOException, GitAPIException {
        Cache meta = new Cache().comment("Source files created by Snowblower", "https://github.com/MinecraftForge/Snowblower").put("Snowblower", InitTask.getGitCommitHash()).put("Start", start.toString());
        Path metaPath = this.root.resolve("Snowblower.txt");
        if (Files.exists(metaPath, new LinkOption[0]) && !meta.isValid(metaPath)) {
            return false;
        }
        if (!Files.exists(metaPath, new LinkOption[0])) {
            meta.write(metaPath);
            Util.add(this.git, metaPath);
            Path attrs = this.root.resolve(".gitattributes");
            Util.writeLines(attrs, "* text eol=lf", "*.java text eol=lf", "*.json text eol=lf", "*.xml text eol=lf", "*.bin binary", "*.png binary", "*.gif binary", "*.nbt binary", "*.ogg binary");
            Util.add(this.git, attrs);
            Path ignore = this.root.resolve(".gitignore");
            Util.writeLines(ignore, ".gradle", "build", "", "# Eclipse", ".settings", ".metadata", ".classpath", ".project", "bin", "", "# IntelliJ", "out", "*.idea", "*.iml");
            Util.add(this.git, ignore);
            try {
                final Path copyParentFolder = Util.isDev() ? Util.getSourcePath() : Util.getPath(Main.class.getResource("/resource_root.txt").toURI()).getParent();
                List<String> toCopy = List.of("gradlew", "gradlew.bat", "gradle");
                AddCommand addCmd = this.git.add();
                for (String filename : toCopy) {
                    Path copyPath = copyParentFolder.resolve(filename);
                    if (Files.isRegularFile(copyPath, new LinkOption[0])) {
                        Files.copy(copyPath, this.root.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.walkFileTree(copyPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Path destinationPath = InitTask.this.root.resolve(copyParentFolder.relativize(file).toString());
                                Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                                Files.copy(file, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    addCmd.addFilepattern(filename);
                }
                addCmd.call();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            DirCache dirCache = this.git.getRepository().lockDirCache();
            dirCache.getEntry("gradlew").setFileMode(FileMode.EXECUTABLE_FILE);
            dirCache.write();
            dirCache.commit();
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(this.root.resolve("gradlew"), PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView != null) {
                Set<PosixFilePermission> perms = posixFileAttributeView.readAttributes().permissions();
                perms.addAll(EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                posixFileAttributeView.setPermissions(perms);
            }
            Util.commit(this.git, COMMIT_MESSAGE, new Date(1242245460000L));
        }
        return true;
    }

    private static String getGitCommitHash() {
        String implVersion = Generator.class.getPackage().getImplementationVersion();
        if (implVersion != null) {
            return implVersion.substring(implVersion.indexOf(40) + 1, implVersion.indexOf(41));
        }
        Path folderPath = Path.of(Util.getCodeSourceUri());
        while (!Files.exists(folderPath.resolve(".git"), new LinkOption[0])) {
            if ((folderPath = folderPath.getParent()) != null) continue;
            return "unknown";
        }
        Git sourceGit = Git.open(folderPath.toFile());
        try {
            String string;
            ObjectId headId = sourceGit.getRepository().resolve("HEAD");
            String string2 = string = headId == null ? "unknown" : headId.getName();
            if (sourceGit != null) {
                sourceGit.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (sourceGit != null) {
                    try {
                        sourceGit.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isInitCommit(String message) {
        return COMMIT_MESSAGE.equals(message);
    }
}

