/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.tasks.enhance;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.snowblower.data.Version;
import net.minecraftforge.snowblower.util.HashFunction;

public class EnhanceVersionTask {
    private static final List<String> EXTRA_DEPENDENCIES = List.of("org.jetbrains:annotations:24.0.0", "com.google.code.findbugs:jsr305:3.0.2", "ca.weblite:java-objc-bridge:1.1");
    private static final String GRADLE_CONTENT = "plugins {\n    id 'java'\n}\n\njava {\n    toolchain {\n        languageVersion = JavaLanguageVersion.of(%java_version%)\n    }\n}\n\nrepositories {\n    mavenCentral()\n    maven {\n        name = 'Mojang'\n        url = 'https://libraries.minecraft.net/'\n    }\n}\n\ndependencies {\n%deps%\n}\n";

    public static List<Path> enhance(Path output, Version version) throws IOException {
        String created;
        byte[] data = GRADLE_CONTENT.replace("%java_version%", Integer.toString(version.javaVersion().majorVersion())).replace("%deps%", Stream.concat(version.libraries().stream().filter(Version.Library::isAllowed).map(Version.Library::name), EXTRA_DEPENDENCIES.stream()).sorted().map(lib -> "    implementation '" + lib + "'").collect(Collectors.joining("\n"))).getBytes(StandardCharsets.UTF_8);
        Path build = output.resolve("build.gradle");
        String existing = Files.exists(build, new LinkOption[0]) ? HashFunction.MD5.hash(build) : "";
        if (!existing.equals(created = HashFunction.MD5.hash(data))) {
            Files.write(build, data, new OpenOption[0]);
            return List.of(build);
        }
        return Collections.emptyList();
    }
}

