/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraftforge.mergetool.AnnotationVersion;
import net.minecraftforge.mergetool.Merger;
import net.minecraftforge.snowblower.data.Version;
import net.minecraftforge.snowblower.tasks.BundlerExtractTask;
import net.minecraftforge.snowblower.util.Cache;
import net.minecraftforge.snowblower.util.DependencyHashCache;
import net.minecraftforge.snowblower.util.Util;
import net.minecraftforge.srgutils.IMappingFile;

public class MergeTask {
    public static Path getJoinedJar(Consumer<String> logger, Path cache, Version version, Path mappings, DependencyHashCache depCache) throws IOException {
        Path clientJar = MergeTask.getJar(logger, "client", cache, version);
        Path serverJar = BundlerExtractTask.getExtractedServerJar(logger, cache, MergeTask.getJar(logger, "server", cache, version), depCache);
        Cache key = new Cache().put("net.minecraftforge:mergetool", depCache).put("client", clientJar).put("server", serverJar).put("map", mappings);
        Path keyF = cache.resolve("joined.jar.cache");
        Path joinedJar = cache.resolve("joined.jar");
        if (!Files.exists(joinedJar, new LinkOption[0]) || !key.isValid(keyF)) {
            logger.accept("  Merging client and server jars");
            Merger merger = new Merger(clientJar.toFile(), serverJar.toFile(), joinedJar.toFile());
            IMappingFile map = IMappingFile.load(mappings.toFile());
            map.getClasses().forEach(cls -> merger.whitelist(cls.getOriginal()));
            merger.annotate(AnnotationVersion.API, true);
            merger.keepData();
            merger.skipMeta();
            merger.process();
            key.write(keyF);
        }
        return joinedJar;
    }

    private static Path getJar(Consumer<String> logger, String type, Path cache, Version version) throws IOException {
        Path jar = cache.resolve(type + ".jar");
        Path keyF = cache.resolve(type + ".jar.cache");
        Version.Download dl = version.downloads().get(type);
        if (dl == null || dl.sha1() == null) {
            throw new IllegalStateException("Could not download \"" + type + "\" jar as version json doesn't have download entry");
        }
        Cache key = new Cache().put(type, dl.sha1());
        if (!Files.exists(jar, new LinkOption[0]) || !key.isValid(keyF)) {
            try {
                Util.downloadFile(logger, jar, dl.url(), dl.sha1());
            }
            catch (IOException e) {
                throw new IOException("Failed to download " + type + " jar", e);
            }
            key.put(type, jar);
            key.write(keyF);
        }
        return jar;
    }
}

