/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ClasspathHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class InvocationExprent
extends Exprent {
    private static final int INVOKE_SPECIAL = 1;
    private static final int INVOKE_VIRTUAL = 2;
    private static final int INVOKE_STATIC = 3;
    private static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_DYNAMIC = 5;
    public static final int TYPE_GENERAL = 1;
    public static final int TYPE_INIT = 2;
    public static final int TYPE_CLINIT = 3;
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private static final VarType JAVA_NIO_BUFFER = new VarType(8, 0, "java/nio/Buffer");
    private String name;
    private String className;
    private boolean isStatic;
    private boolean canIgnoreBoxing = true;
    private int funcType = 1;
    private Exprent instance;
    private StructMethod desc = null;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invokeDynamicClassSuffix;
    private int invocationType = 2;
    private List<Exprent> parameters = new ArrayList<Exprent>();
    private List<PooledConstant> bootstrapArguments;
    private List<VarType> genericArgs = new ArrayList<VarType>();
    private Map<VarType, VarType> genericsMap = new HashMap<VarType, VarType>();
    private boolean isInvocationInstance = false;
    private boolean forceBoxing = false;
    private boolean forceUnboxing = false;
    private boolean isSyntheticNullCheck = false;
    private static final Map<String, String> UNBOXING_METHODS = Map.of("booleanValue", "java/lang/Boolean", "byteValue", "java/lang/Byte", "shortValue", "java/lang/Short", "intValue", "java/lang/Integer", "longValue", "java/lang/Long", "floatValue", "java/lang/Float", "doubleValue", "java/lang/Double", "charValue", "java/lang/Character");

    public InvocationExprent() {
        super(8);
    }

    public InvocationExprent(int opcode, LinkConstant cn, List<PooledConstant> bootstrapArguments, ListStack<? extends Exprent> stack, BitSet bytecodeOffsets) {
        this();
        this.name = cn.elementname;
        this.className = cn.classname;
        this.bootstrapArguments = bootstrapArguments;
        switch (opcode) {
            case 184: {
                this.invocationType = 3;
                break;
            }
            case 183: {
                this.invocationType = 1;
                break;
            }
            case 182: {
                this.invocationType = 2;
                break;
            }
            case 185: {
                this.invocationType = 4;
                break;
            }
            case 186: {
                this.invocationType = 5;
                this.className = "java/lang/Class";
                this.invokeDynamicClassSuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.funcType = 2;
        } else if ("<clinit>".equals(this.name)) {
            this.funcType = 3;
        }
        this.stringDescriptor = cn.descriptor;
        this.descriptor = MethodDescriptor.parseDescriptor(cn.descriptor);
        for (VarType ignored : this.descriptor.params) {
            this.parameters.add(0, stack.pop());
        }
        if (opcode == 186) {
            PooledConstant link;
            int dynamicInvocationType = -1;
            if (bootstrapArguments != null && bootstrapArguments.size() > 1 && (link = bootstrapArguments.get(1)) instanceof LinkConstant) {
                dynamicInvocationType = ((LinkConstant)link).index1;
            }
            if (dynamicInvocationType == 6) {
                this.isStatic = true;
            } else if (!this.parameters.isEmpty()) {
                this.instance = this.parameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private InvocationExprent(InvocationExprent expr) {
        this();
        this.name = expr.getName();
        this.className = expr.getClassName();
        this.isStatic = expr.isStatic();
        this.canIgnoreBoxing = expr.canIgnoreBoxing;
        this.funcType = expr.getFuncType();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationType = expr.getInvocationType();
        this.invokeDynamicClassSuffix = expr.getInvokeDynamicClassSuffix();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        List<Exprent> parameters = expr.getParameters();
        this.parameters = new ArrayList<Exprent>(parameters.size());
        for (Exprent parameter : parameters) {
            this.parameters.add(parameter.copy());
        }
        this.addBytecodeOffsets(expr.bytecode);
        this.bootstrapArguments = expr.getBootstrapArguments();
        this.isSyntheticNullCheck = expr.isSyntheticNullCheck();
        if (this.invocationType == 5 && !this.isStatic && this.instance != null && !this.parameters.isEmpty()) {
            this.instance = this.parameters.get(0);
        }
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VarType getInferredExprType(VarType upperBound) {
        if (this.desc == null) {
            StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
            this.desc = cl != null ? cl.getMethodRecursive(this.name, this.stringDescriptor) : null;
        }
        this.genericArgs.clear();
        this.genericsMap.clear();
        StructClass mthCls = DecompilerContext.getStructContext().getClass(this.className);
        if (this.desc != null && mthCls != null) {
            boolean isGenNew;
            boolean isNew = this.funcType == 2;
            boolean bl = isGenNew = isNew && mthCls.getSignature() != null;
            if (this.desc.getSignature() != null || isGenNew) {
                ClassesProcessor.ClassNode currentCls;
                StructClass cls;
                Map<String, Map<VarType, VarType>> hierarchy;
                Map<VarType, List<VarType>> named = this.getNamedGenerics();
                Map<VarType, List<VarType>> bounds = this.getGenericBounds(mthCls);
                List<String> fparams = isGenNew ? mthCls.getSignature().fparameters : this.desc.getSignature().typeParameters;
                VarType ret = isGenNew ? mthCls.getSignature().genericType : this.desc.getSignature().returnType;
                HashMap<VarType, VarType> tempMap = new HashMap<VarType, VarType>();
                HashMap<VarType, VarType> upperBoundsMap = new HashMap<VarType, VarType>();
                Map<Object, Object> hierarchyMap = new HashMap();
                if (!this.className.equals(this.desc.getClassQualifiedName()) && (hierarchy = mthCls.getAllGenerics()).containsKey(this.desc.getClassQualifiedName())) {
                    hierarchyMap = hierarchy.get(this.desc.getClassQualifiedName());
                    hierarchyMap.forEach((from, to) -> {
                        if (to.getType() == 18) {
                            if (bounds.containsKey(to) && !bounds.containsKey(from)) {
                                bounds.put((VarType)from, (List)bounds.get(to));
                            }
                        } else if (!bounds.containsKey(from)) {
                            this.genericsMap.put((VarType)from, (VarType)to);
                        }
                    });
                }
                if (upperBound != null && !upperBound.equals(VarType.VARTYPE_OBJECT) && (upperBound.getType() != 18 || named.containsKey(upperBound))) {
                    VarType ub = upperBound;
                    VarType r = ret;
                    if (ub.getType() != 18 && r.getType() != 18 && !ub.getValue().equals(r.getValue())) {
                        if (DecompilerContext.getStructContext().instanceOf(ub.getValue(), r.getValue())) {
                            ub = GenericType.getGenericSuperType(ub, r);
                        } else {
                            r = GenericType.getGenericSuperType(r, ub);
                        }
                    }
                    if (r.getType() == 18) {
                        upperBoundsMap.put(r.resizeArrayDim(0), upperBound.resizeArrayDim(upperBound.getArrayDim() - r.getArrayDim()));
                    } else {
                        this.gatherGenerics(ub, r, tempMap);
                        tempMap.forEach((from, to) -> {
                            if (!this.genericsMap.containsKey(from) && to != null && (to.getType() != 18 || named.containsKey(to)) && this.isMappingInBounds((VarType)from, (VarType)to, named, bounds)) {
                                upperBoundsMap.put((VarType)from, (VarType)to);
                            }
                        });
                        tempMap.clear();
                    }
                }
                fparams.stream().map(p -> "T" + p + ";").map(GenericType::parse).filter(t -> !upperBoundsMap.containsKey(t)).forEach(t -> upperBoundsMap.put((VarType)t, GenericType.DUMMY_VAR));
                if (mthCls.getSignature() != null) {
                    mthCls.getSignature().fparameters.stream().map(p -> "T" + p + ";").map(GenericType::parse).filter(t -> !upperBoundsMap.containsKey(t)).forEach(t -> upperBoundsMap.put((VarType)t, GenericType.DUMMY_VAR));
                }
                if (this.instance != null && !isNew) {
                    this.instance.setInvocationInstance();
                    VarType instUB = mthCls.getSignature() != null ? mthCls.getSignature().genericType.remap(upperBoundsMap) : upperBound;
                    VarType instType = this.instance.type == 6 && ((FunctionExprent)this.instance).getFuncType() == 29 ? ((FunctionExprent)this.instance).getLstOperands().get(0).getInferredExprType(instUB) : this.instance.getInferredExprType(instUB);
                    if (instType.getType() == 18 && named.containsKey(instType)) {
                        instType = named.get(instType).get(0);
                    }
                    if (instType.isGeneric() && instType.getType() != 18) {
                        GenericType ginstance = (GenericType)instType;
                        cls = DecompilerContext.getStructContext().getClass(instType.getValue());
                        if (cls != null && cls.getSignature() != null) {
                            cls.getSignature().genericType.mapGenVarsTo(ginstance, tempMap);
                            tempMap.forEach((from, to) -> {
                                if (!fparams.contains(from.getValue())) {
                                    this.processGenericMapping((VarType)from, (VarType)to, named, bounds);
                                }
                            });
                            tempMap.clear();
                        }
                    }
                }
                if (upperBound == null && isGenNew && (currentCls = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE")) != null) {
                    if (mthCls.equals(currentCls.classStruct)) {
                        mthCls.getSignature().genericType.getAllGenericVars().forEach(var -> this.genericsMap.put((VarType)var, (VarType)var));
                    } else {
                        Map<String, Map<VarType, VarType>> hierarchy2 = currentCls.classStruct.getAllGenerics();
                        if (hierarchy2.containsKey(mthCls.qualifiedName)) {
                            hierarchy2.get(mthCls.qualifiedName).forEach(this.genericsMap::put);
                        }
                    }
                }
                if (!this.isInvocationInstance) {
                    upperBoundsMap.forEach((k, v) -> {
                        if (fparams.contains(k.getValue()) && !GenericType.DUMMY_VAR.equals(v) && !this.genericsMap.containsKey(k)) {
                            this.genericsMap.put((VarType)k, (VarType)v);
                        }
                    });
                }
                HashSet<VarType> paramGenerics = new HashSet<VarType>();
                if (!this.parameters.isEmpty() && this.desc.getSignature() != null) {
                    List<VarVersionPair> mask = null;
                    int start = 0;
                    ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.className);
                    if (newNode != null) {
                        if (isNew) {
                            mask = ExprUtil.getSyntheticParametersMask(newNode, this.stringDescriptor, this.parameters.size());
                            start = newNode.classStruct.hasModifier(16384) ? 2 : 0;
                        } else if (!newNode.enclosingClasses.isEmpty()) {
                            start = (newNode.access & 8) == 0 ? 1 : 0;
                        }
                    }
                    boolean bl2 = false;
                    for (int i = start; i < this.parameters.size(); ++i) {
                        NewExprent newExprent;
                        void var17_21;
                        VarType paramType;
                        if (mask != null && mask.get(i) != null || !(paramType = this.desc.getSignature().parameterTypes.get((int)(++var17_21))).isGeneric()) continue;
                        Exprent parameter = this.parameters.get(i);
                        HashSet excluded = new HashSet();
                        if (parameter.type == 10 && (newExprent = (NewExprent)parameter).isLambda()) {
                            StructClass base;
                            StructClass content;
                            ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(newExprent.getNewType().getValue());
                            int potentialMethodCount = Integer.MAX_VALUE;
                            if (node.lambdaInformation.is_method_reference && (content = DecompilerContext.getStructContext().getClass(node.lambdaInformation.content_class_name)) != null) {
                                StructClass currentCls2 = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
                                potentialMethodCount = (int)content.getMethods().stream().filter(method -> this.canAccess(currentCls2, (StructMethod)method)).map(StructMethod::getName).filter(node.lambdaInformation.content_method_name::equals).count();
                            }
                            if (potentialMethodCount > 1 && (base = DecompilerContext.getStructContext().getClass(newExprent.getExprType().getValue())) != null) {
                                StructMethod found = null;
                                for (StructMethod method2 : base.getMethods()) {
                                    if (method2.hasModifier(8) || method2.getInstructionSequence() != null) continue;
                                    found = method2;
                                    break;
                                }
                                if (found != null) {
                                    HashMap<VarType, VarType> genvars = new HashMap<VarType, VarType>();
                                    if (base.getSignature() != null) {
                                        base.getSignature().genericType.mapGenVarsTo((GenericType)paramType, genvars);
                                        excluded.addAll(found.getSignature().parameterTypes.stream().filter(VarType::isGeneric).map(GenericType.class::cast).map(GenericType::getAllGenericVars).flatMap(Collection::stream).map(genvars::get).filter(Objects::nonNull).filter(VarType::isGeneric).map(GenericType.class::cast).map(GenericType::getAllGenericVars).flatMap(Collection::stream).collect(Collectors.toList()));
                                    }
                                }
                            }
                        }
                        HashMap<VarType, VarType> combined = new HashMap<VarType, VarType>(this.genericsMap);
                        upperBoundsMap.forEach((k, v) -> {
                            if (!combined.containsKey(k)) {
                                combined.put((VarType)k, (VarType)v);
                            }
                        });
                        VarType paramUB = paramType.remap(hierarchyMap).remap(combined);
                        VarType argtype = this.parameters.get((int)i).type == 6 && ((FunctionExprent)this.parameters.get(i)).getFuncType() == 29 ? ((FunctionExprent)this.parameters.get(i)).getLstOperands().get(0).getInferredExprType(paramUB) : this.parameters.get(i).getInferredExprType(paramUB);
                        StructClass paramCls = DecompilerContext.getStructContext().getClass(paramType.getValue());
                        StructClass structClass = cls = argtype.getType() != 18 ? DecompilerContext.getStructContext().getClass(argtype.getValue()) : null;
                        if (cls != null && paramCls != null) {
                            if (paramType.isGeneric() && !paramType.getValue().equals(argtype.getValue())) {
                                argtype = GenericType.getGenericSuperType(argtype, paramType);
                            }
                            if (!paramType.isGeneric() || !argtype.isGeneric()) continue;
                            GenericType genParamType = (GenericType)paramType;
                            GenericType genArgType = (GenericType)argtype;
                            genParamType.mapGenVarsTo(genArgType, tempMap);
                            tempMap.forEach((from, to) -> {
                                if (!excluded.contains(from)) {
                                    paramGenerics.add((VarType)from);
                                }
                                this.processGenericMapping((VarType)from, (VarType)to, named, bounds);
                            });
                            tempMap.clear();
                            continue;
                        }
                        if (paramType.getType() != 18 || paramType.equals(argtype) || argtype.getArrayDim() < paramType.getArrayDim()) continue;
                        if (paramType.getArrayDim() > 0) {
                            argtype = argtype.resizeArrayDim(argtype.getArrayDim() - paramType.getArrayDim());
                            paramType = paramType.resizeArrayDim(0);
                        }
                        if (!excluded.contains(paramType)) {
                            paramGenerics.add(paramType);
                        }
                        this.processGenericMapping(paramType, argtype, named, bounds);
                    }
                }
                upperBoundsMap.forEach((k, v) -> {
                    if (fparams.contains(k.getValue()) && !GenericType.DUMMY_VAR.equals(v)) {
                        this.processGenericMapping((VarType)k, (VarType)v, named, bounds);
                    }
                });
                if (!this.genericsMap.isEmpty()) {
                    VarType newRet = ret.remap(hierarchyMap);
                    boolean skipArgs = true;
                    if (!fparams.isEmpty() && newRet.isGeneric()) {
                        for (VarType varType : ((GenericType)newRet).getAllGenericVars()) {
                            if (!fparams.contains(varType.getValue())) continue;
                            skipArgs = false;
                            break;
                        }
                    }
                    if ((newRet = newRet.remap(this.genericsMap)) == null) {
                        newRet = bounds.get(ret).get(0).remap(this.genericsMap);
                    }
                    if (!(skipArgs || isNew && !isGenNew)) {
                        boolean bl3;
                        boolean missing = paramGenerics.isEmpty();
                        if (!missing) {
                            for (String param : fparams) {
                                if (paramGenerics.contains(GenericType.parse("T" + param + ";"))) continue;
                                missing = true;
                                break;
                            }
                        }
                        boolean bl4 = bl3 = !(missing && this.isInvocationInstance || upperBound != null && newRet.isGeneric() && !DecompilerContext.getStructContext().instanceOf(newRet.getValue(), upperBound.getValue()));
                        if (!bl3 || DecompilerContext.getOption("ega")) {
                            this.getGenericArgs(fparams, this.genericsMap, this.genericArgs);
                        } else if (isGenNew) {
                            this.genericArgs.add(GenericType.DUMMY_VAR);
                        }
                    }
                    if (!(newRet == ret || newRet.isGeneric() && ((GenericType)newRet).hasUnknownGenericType(named.keySet()))) {
                        return newRet;
                    }
                }
                if (ret.isGeneric() && ((GenericType)ret).getAllGenericVars().isEmpty()) {
                    return ret;
                }
            }
        }
        return this.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Exprent parameter = this.parameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.getTypeFamily()));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.parameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        String super_qualifier = null;
        boolean isInstanceThis = false;
        tracer.addMapping(this.bytecode);
        if (this.instance instanceof InvocationExprent) {
            ((InvocationExprent)this.instance).markUsingBoxingResult();
        }
        if (this.isStatic) {
            if (this.isBoxingCall() && this.canIgnoreBoxing && !this.forceBoxing) {
                ExprProcessor.getCastedExprent(this.parameters.get(0), this.descriptor.params[0], buf, indent, false, false, true, false, tracer);
                return buf;
            }
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.className.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getNestedNameInClassContext(ExprProcessor.buildJavaClassName(this.className)));
            }
        } else {
            if (this.instance != null && this.instance.type == 12) {
                MethodWrapper currentMethod;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair varPair = new VarVersionPair(instVar);
                VarProcessor varProc = instVar.getProcessor();
                if (varProc == null && (currentMethod = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
                    varProc = currentMethod.varproc;
                }
                String this_classname = null;
                if (varProc != null) {
                    this_classname = varProc.getThisVars().get(varPair);
                }
                if (this_classname != null) {
                    isInstanceThis = true;
                    if (this.invocationType == 1 && !this.className.equals(this_classname)) {
                        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
                        boolean isInterface = cl != null && cl.hasModifier(512);
                        String string = super_qualifier = !isInterface ? this_classname : this.className;
                    }
                }
            }
            if (this.funcType == 1) {
                if (super_qualifier != null) {
                    TextUtil.writeQualifiedSuper(buf, super_qualifier);
                } else if (this.instance != null) {
                    boolean skippedCast;
                    VarType _new;
                    StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
                    VarType leftType = new VarType(8, 0, this.className);
                    if (!this.genericsMap.isEmpty() && cl != null && cl.getSignature() != null && (_new = cl.getSignature().genericType.remap(this.genericsMap)) != cl.getSignature().genericType) {
                        leftType = _new;
                    }
                    this.instance.setInvocationInstance();
                    VarType rightType = this.instance.getInferredExprType(leftType);
                    if (this.isUnboxingCall() && !this.forceUnboxing) {
                        FunctionExprent func;
                        if (this.instance.type == 6 && (func = (FunctionExprent)this.instance).getFuncType() == 29 && func.getLstOperands().get((int)1).type == 3) {
                            ConstExprent _const = (ConstExprent)func.getLstOperands().get(1);
                            boolean skipCast = false;
                            if (func.getLstOperands().get((int)0).type == 12) {
                                VarType inferred = func.getLstOperands().get(0).getInferredExprType(leftType);
                                skipCast = inferred.getType() != 8 || DecompilerContext.getStructContext().instanceOf(inferred.getValue(), this.className);
                            } else if (this.className.equals(_const.getConstType().getValue())) {
                                skipCast = true;
                            }
                            if (skipCast) {
                                buf.append(func.getLstOperands().get(0).toJava(indent, tracer));
                                return buf;
                            }
                        }
                        buf.append(this.instance.toJava(indent, tracer));
                        return buf;
                    }
                    TextBuffer res = this.instance.toJava(indent, tracer);
                    boolean bl = skippedCast = this.instance.type == 6 && ((FunctionExprent)this.instance).getFuncType() == 29 && !((FunctionExprent)this.instance).doesCast();
                    if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType)) {
                        buf.append("((").append(ExprProcessor.getCastTypeName(leftType, Collections.emptyList())).append(")");
                        if (this.instance.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                            res.enclose("(", ")");
                        }
                        buf.append(res).append(")");
                    } else if (this.instance.getPrecedence() > this.getPrecedence() && !skippedCast) {
                        buf.append("(").append(res).append(")");
                    } else if (JAVA_NIO_BUFFER.equals(this.descriptor.ret) && !JAVA_NIO_BUFFER.equals(rightType) && DecompilerContext.getStructContext().instanceOf(rightType.getValue(), JAVA_NIO_BUFFER.getValue())) {
                        buf.append("((").append(ExprProcessor.getCastTypeName(JAVA_NIO_BUFFER, Collections.emptyList())).append(")").append(res).append(")");
                    } else {
                        buf.append(res);
                    }
                }
            }
        }
        switch (this.funcType) {
            case 1: {
                if ("<VAR_NAMELESS_ENCLOSURE>".equals(buf.toString())) {
                    buf = new TextBuffer();
                }
                if (buf.length() > 0) {
                    buf.append(".");
                    this.appendParameters(buf, this.genericArgs);
                }
                buf.append(this.name);
                if (this.invocationType == 5) {
                    buf.append("<invokedynamic>");
                }
                buf.append("(");
                break;
            }
            case 3: {
                throw new RuntimeException("Explicit invocation of <clinit>");
            }
            case 2: {
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                if (this.instance != null) {
                    buf.append(this.instance.toJava(indent, tracer)).append(".<init>(");
                    break;
                }
                throw new RuntimeException("Unrecognized invocation of <init>");
            }
        }
        buf.append(this.appendParamList(indent, tracer)).append(')');
        return buf;
    }

    public TextBuffer appendParamList(int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode newNode;
        TextBuffer buf = new TextBuffer();
        List<VarVersionPair> mask = null;
        boolean isEnum = false;
        if (this.funcType == 2 && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.className)) != null) {
            mask = ExprUtil.getSyntheticParametersMask(newNode, this.stringDescriptor, this.parameters.size());
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("den");
        }
        ClassesProcessor.ClassNode currCls = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        List<StructMethod> matches = this.getMatchedDescriptors();
        BitSet setAmbiguousParameters = this.getAmbiguousParameters(matches);
        if (this.parameters.size() == this.descriptor.params.length && this.isVarArgCall()) {
            Exprent lastParam = this.parameters.get(this.parameters.size() - 1);
            if (lastParam.type == 10 && lastParam.getExprType().getArrayDim() >= 1) {
                ((NewExprent)lastParam).setVarArgParam(true);
            }
        }
        int start = isEnum ? 2 : 0;
        ArrayList<Exprent> parameters = new ArrayList<Exprent>(this.parameters);
        VarType[] types = Arrays.copyOf(this.descriptor.params, this.descriptor.params.length);
        block0: for (int i = start; i < parameters.size(); ++i) {
            StructClass stClass;
            Exprent par = (Exprent)parameters.get(i);
            if (par.type != 8) continue;
            InvocationExprent inv = (InvocationExprent)par;
            if (inv.isBoxingCall()) {
                Exprent value = inv.parameters.get(0);
                types[i] = value.getExprType();
                if (types[i].getTypeFamily() == 2) {
                    types[i] = "java/lang/Short".equals(inv.className) ? VarType.VARTYPE_SHORT : ("java/lang/Byte".equals(inv.className) ? VarType.VARTYPE_BYTE : ("java/lang/Integer".equals(inv.className) ? VarType.VARTYPE_INT : VarType.VARTYPE_CHAR));
                }
                int count = 0;
                StructClass stClass2 = DecompilerContext.getStructContext().getClass(this.className);
                if (stClass2 != null) {
                    block1: for (StructMethod mt : stClass2.getMethods()) {
                        if (!this.name.equals(mt.getName()) || currCls != null && !this.canAccess(currCls.classStruct, mt)) continue;
                        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                        if (md.params.length != this.descriptor.params.length) continue;
                        for (int x = 0; x < md.params.length; ++x) {
                            if (md.params[x].getTypeFamily() != this.descriptor.params[x].getTypeFamily() && md.params[x].getTypeFamily() != types[x].getTypeFamily()) continue block1;
                        }
                        ++count;
                    }
                }
                if (count != matches.size()) {
                    types[i] = this.descriptor.params[i];
                    inv.forceBoxing = true;
                    continue;
                }
                value.addBytecodeOffsets(inv.bytecode);
                parameters.set(i, value);
                continue;
            }
            if (!inv.isUnboxingCall() || inv.shouldForceUnboxing() || (stClass = DecompilerContext.getStructContext().getClass(this.className)) == null) continue;
            for (StructMethod mt : stClass.getMethods()) {
                if (!this.name.equals(mt.getName()) || currCls != null && !this.canAccess(currCls.classStruct, mt) || this.stringDescriptor.equals(mt.getDescriptor())) continue;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                if (md.params.length != this.descriptor.params.length || md.params[i].getType() != 8 || !DecompilerContext.getStructContext().instanceOf(inv.getInstance().getExprType().getValue(), md.params[i].getValue())) continue;
                inv.forceUnboxing(true);
                continue block0;
            }
        }
        if (this.desc == null) {
            VarType instType;
            this.getInferredExprType(null);
            if (this.genericsMap.isEmpty() && this.instance != null && this.funcType != 2 && (instType = this.instance.getInferredExprType(null)).isGeneric() && instType.getType() != 18) {
                GenericType ginstance = (GenericType)instType;
                StructClass cls = DecompilerContext.getStructContext().getClass(instType.getValue());
                if (cls != null && cls.getSignature() != null) {
                    cls.getSignature().genericType.mapGenVarsTo(ginstance, this.genericsMap);
                }
            }
        }
        if (this.desc != null && this.desc.getSignature() != null) {
            Map<String, Map<VarType, VarType>> hierarchy;
            StructClass mthCls;
            HashMap<VarType, VarType> hierarchyMap = new HashMap();
            if (!this.className.equals(this.desc.getClassQualifiedName()) && (mthCls = DecompilerContext.getStructContext().getClass(this.className)) != null && (hierarchy = mthCls.getAllGenerics()).containsKey(this.desc.getClassQualifiedName())) {
                hierarchyMap = hierarchy.get(this.desc.getClassQualifiedName());
            }
            Set<VarType> namedGens = this.getNamedGenerics().keySet();
            int y = 0;
            for (int x = start; x < types.length; ++x) {
                VarType type;
                if (mask != null && mask.get(x) != null || (type = this.desc.getSignature().parameterTypes.get(y++).remap(hierarchyMap).remap(this.genericsMap)) == null || type.isGeneric() && ((GenericType)type).hasUnknownGenericType(namedGens)) continue;
                types[x] = type;
            }
        }
        boolean firstParameter = true;
        for (int i = start; i < this.parameters.size(); ++i) {
            if (mask != null && mask.get(i) != null) continue;
            TextBuffer buff = new TextBuffer();
            boolean ambiguous = setAmbiguousParameters.get(i);
            if (i == parameters.size() - 1 && this.parameters.get(i).getExprType() == VarType.VARTYPE_NULL && NewExprent.probablySyntheticParameter(this.descriptor.params[i].getValue())) break;
            ExprProcessor.getCastedExprent(this.parameters.get(i), types[i], buff, indent, true, ambiguous, true, true, tracer);
            if (buff.length() > 0) {
                if (!firstParameter) {
                    buf.append(", ");
                }
                buf.append(buff);
            }
            firstParameter = false;
        }
        return buf;
    }

    private boolean isVarArgCall() {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
        if (cl != null) {
            StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
            if (mt != null) {
                return mt.hasModifier(128);
            }
        } else {
            Method mtd = ClasspathHelper.findMethod(this.className, this.name, this.descriptor);
            return mtd != null && mtd.isVarArgs();
        }
        return false;
    }

    public boolean isBoxingCall() {
        if (this.isStatic && "valueOf".equals(this.name) && this.parameters.size() == 1) {
            int paramType = this.parameters.get(0).getExprType().getType();
            if (this.parameters.get((int)0).type == 3) {
                if (this.parameters.get(0).getExprType().getTypeFamily() == 2 && this.className.equals("java/lang/Integer")) {
                    return true;
                }
                if ((paramType == 15 || paramType == 16) && (this.className.equals("java/lang/Character") || this.className.equals("java/lang/Short"))) {
                    return true;
                }
            }
            return this.className.equals(InvocationExprent.getClassNameForPrimitiveType(paramType));
        }
        return false;
    }

    public boolean isInstanceCall(@NotNull String className, @NotNull String methodName, int parametersCount) {
        return this.invocationType == 2 && this.className.equals(className) && methodName.equals(this.name) && this.parameters.size() == parametersCount;
    }

    public void markUsingBoxingResult() {
        this.canIgnoreBoxing = false;
    }

    private static String getClassNameForPrimitiveType(int type) {
        return switch (type) {
            case 7 -> "java/lang/Boolean";
            case 0, 15 -> "java/lang/Byte";
            case 1 -> "java/lang/Character";
            case 6, 16 -> "java/lang/Short";
            case 4 -> "java/lang/Integer";
            case 5 -> "java/lang/Long";
            case 3 -> "java/lang/Float";
            case 2 -> "java/lang/Double";
            default -> null;
        };
    }

    public boolean isUnboxingCall() {
        return !this.isStatic && this.parameters.size() == 0 && this.className.equals(UNBOXING_METHODS.get(this.name));
    }

    public boolean shouldForceBoxing() {
        return this.forceBoxing;
    }

    public void forceUnboxing(boolean value) {
        this.forceUnboxing = value;
    }

    public boolean shouldForceUnboxing() {
        return this.forceUnboxing;
    }

    private List<StructMethod> getMatchedDescriptors() {
        ArrayList<StructMethod> matches = new ArrayList<StructMethod>();
        ClassesProcessor.ClassNode currCls = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
        if (cl == null) {
            return matches;
        }
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<StructClass> que = new ArrayDeque<StructClass>();
        que.add(cl);
        while (!que.isEmpty()) {
            StructClass tmp;
            StructClass cls = (StructClass)que.poll();
            if (cls == null) continue;
            for (StructMethod mt : cls.getMethods()) {
                if (!this.name.equals(mt.getName())) continue;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                if (!this.matches(md.params, this.descriptor.params) || currCls != null && !this.canAccess(currCls.classStruct, mt)) continue;
                matches.add(mt);
            }
            if (cls == cl && !matches.isEmpty()) {
                return matches;
            }
            visited.add(cls.qualifiedName);
            if (cls.superClass != null && !visited.contains(cls.superClass.value) && (tmp = DecompilerContext.getStructContext().getClass((String)cls.superClass.value)) != null) {
                que.add(tmp);
            }
            for (String intf : cls.getInterfaceNames()) {
                StructClass tmp2;
                if (visited.contains(intf) || (tmp2 = DecompilerContext.getStructContext().getClass(intf)) == null) continue;
                que.add(tmp2);
            }
        }
        return matches;
    }

    private boolean matches(VarType[] left, VarType[] right) {
        if (left.length == right.length) {
            for (int i = 0; i < left.length; ++i) {
                if (left[i].getTypeFamily() == right[i].getTypeFamily()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean canAccess(StructClass currCls, StructMethod mt) {
        if (mt.hasModifier(1)) {
            return true;
        }
        if (mt.hasModifier(2)) {
            return mt.getClassQualifiedName().equals(currCls.qualifiedName);
        }
        if (mt.hasModifier(4)) {
            boolean samePackage = this.isInSamePackage(currCls.qualifiedName, mt.getClassQualifiedName());
            return samePackage || DecompilerContext.getStructContext().instanceOf(currCls.qualifiedName, mt.getClassQualifiedName());
        }
        return this.isInSamePackage(currCls.qualifiedName, mt.getClassQualifiedName());
    }

    private boolean isInSamePackage(String class1, String class2) {
        int pos2;
        int pos1 = class1.lastIndexOf(47);
        if (pos1 != (pos2 = class2.lastIndexOf(47))) {
            return false;
        }
        if (pos1 == -1) {
            return true;
        }
        String pkg1 = class1.substring(0, pos1);
        String pkg2 = class2.substring(0, pos2);
        return pkg1.equals(pkg2);
    }

    private BitSet getAmbiguousParameters(List<StructMethod> matches) {
        int i;
        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
        if (cl == null || matches.size() == 1) {
            return EMPTY_BIT_SET;
        }
        BitSet missed = new BitSet(this.parameters.size());
        StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
        if (mt != null) {
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length == this.parameters.size()) {
                boolean exact = true;
                for (i = 0; i < md.params.length; ++i) {
                    Exprent exp = this.parameters.get(i);
                    if (md.params[i].equals(exp.getExprType()) && (exp.type != 10 || !((NewExprent)exp).isLambda() || ((NewExprent)exp).isMethodReference())) continue;
                    exact = false;
                    missed.set(i);
                }
                if (exact) {
                    return EMPTY_BIT_SET;
                }
            }
        }
        ArrayList<StructMethod> mtds = new ArrayList<StructMethod>();
        for (StructMethod mtt : matches) {
            boolean failed = false;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
            for (int i2 = 0; i2 < this.parameters.size(); ++i2) {
                NewExprent newExp;
                Exprent exp = this.parameters.get(i2);
                VarType ptype = exp.getExprType();
                if (!missed.get(i2)) {
                    if (md.params[i2].equals(ptype)) continue;
                    failed = true;
                    break;
                }
                if (exp.type == 10 && (newExp = (NewExprent)exp).isLambda() && !newExp.isMethodReference() && !DecompilerContext.getStructContext().instanceOf(md.params[i2].getValue(), exp.getExprType().getValue())) {
                    StructClass pcls = DecompilerContext.getStructContext().getClass(md.params[i2].getValue());
                    if (pcls == null || pcls.getMethod(newExp.getLambdaMethodKey()) != null) continue;
                    failed = true;
                    break;
                }
                if (md.params[i2].getType() != 8 || ptype.getType() == 13 || DecompilerContext.getStructContext().instanceOf(ptype.getValue(), md.params[i2].getValue())) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            mtds.add(mtt);
        }
        BitSet ambiguous = new BitSet(this.descriptor.params.length);
        block3: for (i = 0; i < this.descriptor.params.length; ++i) {
            VarType paramType = this.descriptor.params[i];
            for (StructMethod mtt : mtds) {
                GenericMethodDescriptor gen = mtt.getSignature();
                if (gen != null && gen.parameterTypes.size() > i && gen.parameterTypes.get(i).isGeneric()) {
                    Exprent exp = this.parameters.get(i);
                    if (exp.type != 10 || !((NewExprent)exp).isLambda() || ((NewExprent)exp).isMethodReference()) continue block3;
                }
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
                if (paramType.equals(md.params[i])) continue;
                ambiguous.set(i);
                continue block3;
            }
        }
        return ambiguous;
    }

    private void processGenericMapping(VarType from, VarType to, Map<VarType, List<VarType>> named, Map<VarType, List<VarType>> bounds) {
        if (VarType.VARTYPE_NULL.equals(to) || to != null && to.getType() == 18 && !named.containsKey(to)) {
            return;
        }
        VarType current = this.genericsMap.get(from);
        if (!this.genericsMap.containsKey(from)) {
            this.putGenericMapping(from, to, named, bounds);
        } else if (to != null && current != null && !to.equals(current)) {
            VarType bound;
            if (named.containsKey(current)) {
                return;
            }
            if (current.getType() != 18 && to.getType() == 18 && named.containsKey(to) && !(bound = named.get(to).get(0)).equals(VarType.VARTYPE_OBJECT) && DecompilerContext.getStructContext().instanceOf(bound.getValue(), current.getValue())) {
                return;
            }
            if (to.isGeneric() && current.isGeneric() && GenericType.isAssignable(to, current, named)) {
                this.putGenericMapping(from, to, named, bounds);
            }
        }
    }

    private void putGenericMapping(VarType from, VarType to, Map<VarType, List<VarType>> named, Map<VarType, List<VarType>> bounds) {
        if (this.isMappingInBounds(from, to, named, bounds)) {
            this.genericsMap.put(from, to);
        }
    }

    private boolean isMappingInBounds(VarType from, VarType to, Map<VarType, List<VarType>> named, Map<VarType, List<VarType>> bounds) {
        if (!bounds.containsKey(from)) {
            return false;
        }
        if (to == null || to.getType() == 18 && !named.containsKey(to)) {
            return true;
        }
        BiFunction<VarType, VarType, Boolean> verifier = (newTo, bound) -> {
            if (bound.getType() == 18) {
                Function<VarType, VarType> map = e -> {
                    VarType mapped = this.genericsMap.get(e);
                    if (mapped == null) {
                        mapped = named.containsKey(e) ? (VarType)((List)named.get(e)).get(0) : null;
                    }
                    return mapped;
                };
                VarType mapped = map.apply((VarType)bound);
                if (mapped != null && !mapped.equals(bound)) {
                    VarType last = bound;
                    while (bound != null) {
                        last = bound;
                        bound = map.apply((VarType)bound);
                    }
                    bound = last;
                    if (bound.getType() != 18) {
                        return DecompilerContext.getStructContext().instanceOf(newTo.getValue(), bound.getValue());
                    }
                }
                return this.isMappingInBounds((VarType)bound, (VarType)newTo, named, bounds);
            }
            if (newTo.getType() < 8) {
                return bound.equals(VarType.VARTYPE_OBJECT) || bound.equals(newTo);
            }
            if (!DecompilerContext.getStructContext().instanceOf(newTo.getValue(), bound.getValue())) {
                return false;
            }
            if (bound.isGeneric() && !((GenericType)bound).getArguments().isEmpty()) {
                GenericType genbound = (GenericType)bound;
                VarType _new = newTo;
                if (!newTo.getValue().equals(bound.getValue())) {
                    _new = GenericType.getGenericSuperType(newTo, bound);
                }
                if (!_new.isGeneric() || ((GenericType)_new).getArguments().size() != genbound.getArguments().size()) {
                    return false;
                }
                HashMap<VarType, VarType> toAdd = new HashMap<VarType, VarType>();
                GenericType genNew = (GenericType)_new;
                for (int i = 0; i < genbound.getArguments().size(); ++i) {
                    VarType boundArg = genbound.getArguments().get(i);
                    VarType newArg = genNew.getArguments().get(i);
                    if (boundArg == null || boundArg.equals(newArg) || from.equals(boundArg) && to.equals(newArg)) continue;
                    if (bounds.containsKey(boundArg) && this.isMappingInBounds(boundArg, newArg, named, bounds)) {
                        toAdd.put(boundArg, newArg);
                        continue;
                    }
                    return false;
                }
                toAdd.forEach((k, v) -> this.processGenericMapping((VarType)k, (VarType)v, named, bounds));
            }
            return true;
        };
        List<VarType> toVerify = to.getType() == 18 ? named.get(to) : Collections.singletonList(to);
        return bounds.get(from).stream().allMatch(bound -> toVerify.stream().anyMatch(v -> (Boolean)verifier.apply((VarType)v, (VarType)bound)));
    }

    private Map<VarType, List<VarType>> getGenericBounds(StructClass mthCls) {
        ClassesProcessor.ClassNode cn;
        int x;
        HashMap<VarType, List<VarType>> bounds = new HashMap<VarType, List<VarType>>();
        if (this.desc.getSignature() != null) {
            for (x = 0; x < this.desc.getSignature().typeParameters.size(); ++x) {
                bounds.putIfAbsent(GenericType.parse("T" + this.desc.getSignature().typeParameters.get(x) + ";"), this.desc.getSignature().typeParameterBounds.get(x));
            }
        }
        if (mthCls.getSignature() != null) {
            for (x = 0; x < mthCls.getSignature().fparameters.size(); ++x) {
                bounds.putIfAbsent(GenericType.parse("T" + mthCls.getSignature().fparameters.get(x) + ";"), mthCls.getSignature().fbounds.get(x));
            }
        }
        ClassesProcessor.ClassNode classNode = cn = (cn = DecompilerContext.getClassProcessor().getMapRootClasses().get(mthCls.qualifiedName)) != null ? cn.parent : null;
        while (cn != null) {
            if (cn.classStruct.getSignature() != null) {
                for (int x2 = 0; x2 < cn.classStruct.getSignature().fparameters.size(); ++x2) {
                    bounds.putIfAbsent(GenericType.parse("T" + cn.classStruct.getSignature().fparameters.get(x2) + ";"), cn.classStruct.getSignature().fbounds.get(x2));
                }
            }
            cn = cn.parent;
        }
        return bounds;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (oldExpr != this.parameters.get(i)) continue;
            this.parameters.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return Objects.equals(this.name, it.name) && Objects.equals(this.className, it.className) && this.isStatic == it.isStatic && Objects.equals(this.instance, it.instance) && Objects.equals(this.descriptor, it.descriptor) && this.funcType == it.funcType && Objects.equals(this.parameters, it.parameters);
    }

    public List<Exprent> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Exprent> parameters) {
        this.parameters = parameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getFuncType() {
        return this.funcType;
    }

    public void setFuncType(int funcType) {
        this.funcType = funcType;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public int getInvocationType() {
        return this.invocationType;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invokeDynamicClassSuffix;
    }

    public List<PooledConstant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public void setSyntheticNullCheck() {
        this.isSyntheticNullCheck = true;
    }

    public boolean isSyntheticNullCheck() {
        return this.isSyntheticNullCheck;
    }

    public List<VarType> getGenericArgs() {
        return this.genericArgs;
    }

    public Map<VarType, VarType> getGenericsMap() {
        return this.genericsMap;
    }

    @Override
    public void setInvocationInstance() {
        this.isInvocationInstance = true;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        InvocationExprent.measureBytecode(values, this.parameters);
        InvocationExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER ? value.isVariable() && (value.parameter >= this.parameters.size() || !engine.checkAndSetVariableValue(value.value.toString(), this.parameters.get(value.parameter))) : (key == IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS ? !value.value.equals(this.className) : key == IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE && !value.value.equals(this.name + this.stringDescriptor)))) continue;
            return false;
        }
        return true;
    }
}

