/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ConcatenationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class SecondaryFunctionsHelper {
    private static final int[] funcsnot = new int[]{43, 42, 45, 44, 47, 46, 49, 48};
    private static final Map<Integer, Integer[]> mapNumComparisons = Map.of(42, new Integer[]{44, 42, 46}, 43, new Integer[]{45, 43, 47}, 46, new Integer[]{45, 46, null}, 45, new Integer[]{null, 45, 46}, 44, new Integer[]{null, 44, 47}, 47, new Integer[]{44, 47, null});

    public static boolean identifySecondaryFunctions(Statement stat, VarProcessor varProc) {
        if (stat.getExprents() == null && stat.type == Statement.StatementType.IF) {
            IfStatement ifelsestat = (IfStatement)stat;
            Statement ifstat = ifelsestat.getIfstat();
            if (ifelsestat.iftype == 1 && ifstat.getExprents() != null && ifstat.getExprents().isEmpty() && (ifstat.getAllSuccessorEdges().isEmpty() || !ifstat.getAllSuccessorEdges().get((int)0).explicit)) {
                ifelsestat.getStats().removeWithKey(ifstat.id);
                ifelsestat.iftype = 0;
                ifelsestat.setIfstat(ifelsestat.getElsestat());
                ifelsestat.setElsestat(null);
                if (ifelsestat.getAllSuccessorEdges().isEmpty() && !ifstat.getAllSuccessorEdges().isEmpty()) {
                    StatEdge endedge = ifstat.getAllSuccessorEdges().get(0);
                    ifstat.removeSuccessor(endedge);
                    endedge.setSource(ifelsestat);
                    if (endedge.closure != null) {
                        ifelsestat.getParent().addLabeledEdge(endedge);
                    }
                    ifelsestat.addSuccessor(endedge);
                }
                ifelsestat.getFirst().removeSuccessor(ifelsestat.getIfEdge());
                ifelsestat.setIfEdge(ifelsestat.getElseEdge());
                ifelsestat.setElseEdge(null);
                ifelsestat.setNegated(!ifelsestat.isNegated());
                ifelsestat.getHeadexprentList().set(0, ((IfExprent)ifelsestat.getHeadexprent().copy()).negateIf());
                return true;
            }
        }
        boolean replaced = true;
        block0: while (replaced) {
            replaced = false;
            ArrayList<Object> lstObjects = new ArrayList<Object>(stat.getExprents() == null ? stat.getSequentialObjects() : stat.getExprents());
            for (int i = 0; i < lstObjects.size(); ++i) {
                Exprent retexpr;
                Object obj = lstObjects.get(i);
                if (obj instanceof Statement) {
                    if (!SecondaryFunctionsHelper.identifySecondaryFunctions((Statement)obj, varProc)) continue;
                    replaced = true;
                    continue block0;
                }
                if (!(obj instanceof Exprent) || (retexpr = SecondaryFunctionsHelper.identifySecondaryFunctions((Exprent)obj, true, varProc)) == null) continue;
                if (stat.getExprents() == null) {
                    stat.replaceExprent((Exprent)obj, retexpr);
                } else {
                    stat.getExprents().set(i, retexpr);
                }
                replaced = true;
                continue block0;
            }
        }
        return false;
    }

    private static Exprent identifySecondaryFunctions(Exprent exprent, boolean statement_level, VarProcessor varProc) {
        block38: {
            ConstExprent cexpr;
            if (exprent.type == 6) {
                FunctionExprent fexpr = (FunctionExprent)exprent;
                switch (fexpr.getFuncType()) {
                    case 12: {
                        Exprent retparam = SecondaryFunctionsHelper.propagateBoolNot(fexpr);
                        if (retparam == null) break;
                        return retparam;
                    }
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        Integer destcon;
                        int index;
                        Object expr1 = fexpr.getLstOperands().get(0);
                        Object expr2 = fexpr.getLstOperands().get(1);
                        if (((Exprent)expr1).type == 3) {
                            expr2 = expr1;
                            expr1 = fexpr.getLstOperands().get(1);
                        }
                        if (((Exprent)expr1).type != 6 || ((Exprent)expr2).type != 3) break;
                        FunctionExprent funcexpr = (FunctionExprent)expr1;
                        cexpr = (ConstExprent)expr2;
                        int functype = funcexpr.getFuncType();
                        if (functype != 37 && functype != 39 && functype != 38 && functype != 41 && functype != 40) break;
                        int desttype = -1;
                        Integer[] destcons = mapNumComparisons.get(fexpr.getFuncType());
                        if (destcons != null && (index = cexpr.getIntValue() + 1) >= 0 && index <= 2 && (destcon = destcons[index]) != null) {
                            desttype = destcon;
                        }
                        if (desttype < 0) break;
                        if (functype != 37) {
                            boolean trueForNan;
                            boolean oneForNan = functype == 40 || functype == 38;
                            boolean trueForOne = desttype == 44 || desttype == 47;
                            boolean bl = trueForNan = oneForNan == trueForOne;
                            if (trueForNan) {
                                ArrayList<Exprent> operands = new ArrayList<Exprent>();
                                operands.add(new FunctionExprent(funcsnot[desttype - 42], funcexpr.getLstOperands(), funcexpr.bytecode));
                                return new FunctionExprent(12, operands, funcexpr.bytecode);
                            }
                        }
                        return new FunctionExprent(desttype, funcexpr.getLstOperands(), funcexpr.bytecode);
                    }
                }
            }
            boolean replaced = true;
            block20: while (replaced) {
                replaced = false;
                for (Exprent expr : exprent.getAllExprents()) {
                    Exprent retexpr = SecondaryFunctionsHelper.identifySecondaryFunctions(expr, false, varProc);
                    if (retexpr == null) continue;
                    exprent.replaceExprent(expr, retexpr);
                    replaced = true;
                    continue block20;
                }
            }
            block4 : switch (exprent.type) {
                case 6: {
                    FunctionExprent fexpr = (FunctionExprent)exprent;
                    List<Exprent> lstOperands = fexpr.getLstOperands();
                    switch (fexpr.getFuncType()) {
                        case 6: {
                            for (int i = 0; i < 2; ++i) {
                                Exprent operand = lstOperands.get(i);
                                VarType operandtype = operand.getExprType();
                                if (operand.type != 3 || operandtype.getType() == 7) continue;
                                ConstExprent cexpr2 = (ConstExprent)operand;
                                long val = operandtype.getType() == 5 ? (Long)cexpr2.getValue() : (long)((Integer)cexpr2.getValue()).intValue();
                                if (val != -1L) continue;
                                ArrayList<Exprent> lstBitNotOperand = new ArrayList<Exprent>();
                                lstBitNotOperand.add(lstOperands.get(1 - i));
                                return new FunctionExprent(11, lstBitNotOperand, fexpr.bytecode);
                            }
                            break block4;
                        }
                        case 42: 
                        case 43: {
                            if (lstOperands.get(0).getExprType().getType() == 7 && lstOperands.get(1).getExprType().getType() == 7) {
                                for (int i = 0; i < 2; ++i) {
                                    if (lstOperands.get((int)i).type != 3) continue;
                                    cexpr = (ConstExprent)lstOperands.get(i);
                                    int val = (Integer)cexpr.getValue();
                                    if (fexpr.getFuncType() == 42 && val == 1 || fexpr.getFuncType() == 43 && val == 0) {
                                        return lstOperands.get(1 - i);
                                    }
                                    ArrayList<Exprent> lstNotOperand = new ArrayList<Exprent>();
                                    lstNotOperand.add(lstOperands.get(1 - i));
                                    return new FunctionExprent(12, lstNotOperand, fexpr.bytecode);
                                }
                                break block4;
                            }
                            break block38;
                        }
                        case 12: {
                            if (lstOperands.get((int)0).type == 3) {
                                int val = ((ConstExprent)lstOperands.get(0)).getIntValue();
                                if (val == 0) {
                                    return new ConstExprent(VarType.VARTYPE_BOOLEAN, 1, fexpr.bytecode);
                                }
                                return new ConstExprent(VarType.VARTYPE_BOOLEAN, 0, fexpr.bytecode);
                            }
                            break block38;
                        }
                        case 36: {
                            Exprent expr1 = lstOperands.get(1);
                            Exprent expr2 = lstOperands.get(2);
                            if (expr1.type != 3 || expr2.type != 3) break block4;
                            ConstExprent cexpr1 = (ConstExprent)expr1;
                            ConstExprent cexpr2 = (ConstExprent)expr2;
                            if (cexpr1.getExprType().getType() != 7 || cexpr2.getExprType().getType() != 7) break block4;
                            if (cexpr1.getIntValue() == 0 && cexpr2.getIntValue() != 0) {
                                return new FunctionExprent(12, lstOperands.get(0), fexpr.bytecode);
                            }
                            if (cexpr1.getIntValue() == 0 || cexpr2.getIntValue() != 0) break block4;
                            return lstOperands.get(0);
                        }
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: {
                            int var = DecompilerContext.getCounterContainer().getCounterAndIncrement(2);
                            VarType type = lstOperands.get(0).getExprType();
                            FunctionExprent iff = new FunctionExprent(36, Arrays.asList(new FunctionExprent(44, Arrays.asList(new VarExprent(var, type, varProc), ConstExprent.getZeroConstant(type.getType())), null), new ConstExprent(VarType.VARTYPE_INT, -1, null), new ConstExprent(VarType.VARTYPE_INT, 1, null)), null);
                            FunctionExprent head = new FunctionExprent(42, Arrays.asList(new AssignmentExprent(new VarExprent(var, type, varProc), new FunctionExprent(1, Arrays.asList(lstOperands.get(0), lstOperands.get(1)), null), null), ConstExprent.getZeroConstant(type.getType())), null);
                            varProc.setVarType(new VarVersionPair(var, 0), type);
                            return new FunctionExprent(36, Arrays.asList(head, new ConstExprent(VarType.VARTYPE_INT, 0, null), iff), fexpr.bytecode);
                        }
                    }
                    break;
                }
                case 2: {
                    AssignmentExprent asexpr = (AssignmentExprent)exprent;
                    Exprent right = asexpr.getRight();
                    Exprent left = asexpr.getLeft();
                    if (right.type != 6) break;
                    FunctionExprent func = (FunctionExprent)right;
                    VarType midlayer = null;
                    if (func.getFuncType() >= 14 && func.getFuncType() <= 28) {
                        right = func.getLstOperands().get(0);
                        midlayer = func.getSimpleCastType();
                        if (right.type == 6) {
                            func = (FunctionExprent)right;
                        } else {
                            return null;
                        }
                    }
                    List<Exprent> lstFuncOperands = func.getLstOperands();
                    Exprent cond = null;
                    switch (func.getFuncType()) {
                        case 0: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (left.equals(lstFuncOperands.get(1))) {
                                cond = lstFuncOperands.get(0);
                                break;
                            }
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            if (!left.equals(lstFuncOperands.get(0))) break;
                            cond = lstFuncOperands.get(1);
                        }
                    }
                    if (cond == null || midlayer != null && !midlayer.equals(cond.getExprType())) break;
                    asexpr.setRight(cond);
                    asexpr.setCondType(func.getFuncType());
                    break;
                }
                case 8: {
                    Exprent retexpr;
                    if (statement_level || exprent.equals(retexpr = ConcatenationHelper.contractStringConcat(exprent))) break;
                    return retexpr;
                }
            }
        }
        return null;
    }

    public static Exprent propagateBoolNot(Exprent exprent) {
        FunctionExprent fexpr;
        if (exprent.type == 6 && (fexpr = (FunctionExprent)exprent).getFuncType() == 12) {
            Exprent param = fexpr.getLstOperands().get(0);
            if (param.type == 6) {
                FunctionExprent fparam = (FunctionExprent)param;
                int ftype = fparam.getFuncType();
                boolean canSimplify = false;
                switch (ftype) {
                    case 12: {
                        Exprent newexpr = fparam.getLstOperands().get(0);
                        Exprent retexpr = SecondaryFunctionsHelper.propagateBoolNot(newexpr);
                        return retexpr == null ? newexpr : retexpr;
                    }
                    case 48: 
                    case 49: {
                        List<Exprent> operands = fparam.getLstOperands();
                        for (int i = 0; i < operands.size(); ++i) {
                            FunctionExprent newparam = new FunctionExprent(12, operands.get(i), operands.get((int)i).bytecode);
                            Exprent retparam = SecondaryFunctionsHelper.propagateBoolNot(newparam);
                            operands.set(i, retparam == null ? newparam : retparam);
                        }
                    }
                    case 42: 
                    case 43: {
                        canSimplify = true;
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        VarType right;
                        VarType left;
                        VarType commonSupertype;
                        List<Exprent> operands;
                        if (!canSimplify && (commonSupertype = VarType.getCommonSupertype(left = (operands = fparam.getLstOperands()).get(0).getExprType(), right = operands.get(1).getExprType())) != null) {
                            boolean bl = canSimplify = commonSupertype.getType() != 3 && commonSupertype.getType() != 2;
                        }
                        if (!canSimplify) break;
                        fparam.setFuncType(funcsnot[ftype - 42]);
                        return fparam;
                    }
                }
            }
        }
        return null;
    }

    public static void updateAssignments(Statement stat) {
        ArrayList<Object> objects = new ArrayList<Object>(stat.getExprents() == null ? stat.getSequentialObjects() : stat.getExprents());
        for (Object e : objects) {
            if (e instanceof Statement) {
                SecondaryFunctionsHelper.updateAssignments((Statement)e);
                continue;
            }
            if (!(e instanceof Exprent)) continue;
            Exprent exprent = (Exprent)e;
            if (exprent.type != 2) continue;
            AssignmentExprent assignment = (AssignmentExprent)exprent;
            List<Exprent> params = exprent.getAllExprents();
            Exprent lhs = params.get(0);
            Exprent rhs = params.get(1);
            if (assignment.getCondType() != -1 || lhs.type != 12 || rhs.type != 6) continue;
            VarExprent lhsVar = (VarExprent)lhs;
            FunctionExprent rhsFunc = (FunctionExprent)rhs;
            List<Exprent> funcParams = rhsFunc.getAllExprents();
            if (rhsFunc.getFuncType() > 10 || funcParams.get((int)0).type != 12) continue;
            VarExprent lhsVarFunc = (VarExprent)funcParams.get(0);
            if (lhsVar.getIndex() != lhsVarFunc.getIndex()) continue;
            assignment.setCondType(rhsFunc.getFuncType());
            assignment.setRight(funcParams.get(1));
        }
    }
}

