/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class MethodHandleDescriptorHelper {
    private static final String OBJECT_ARRAY_PARAM = "([Ljava/lang/Object;)";

    public static void changeMethodHandleDescriptorsStats(Statement stat) {
        for (Statement inner : stat.getStats()) {
            MethodHandleDescriptorHelper.changeMethodHandleDescriptorsStats(inner);
        }
        if (stat.getExprents() != null) {
            for (int i = 0; i < stat.getExprents().size(); ++i) {
                Exprent exprent = stat.getExprents().get(i);
                Exprent updated = MethodHandleDescriptorHelper.updateExprent(exprent);
                if (updated == null) continue;
                stat.getExprents().set(i, updated);
            }
        }
    }

    private static Exprent updateExprent(Exprent exprent) {
        for (Exprent inner : exprent.getAllExprents()) {
            Exprent updated = MethodHandleDescriptorHelper.updateExprent(inner);
            if (updated == null) continue;
            exprent.replaceExprent(inner, updated);
        }
        if (exprent.type == 8) {
            InvocationExprent invocation = (InvocationExprent)exprent;
            StructClass cl = DecompilerContext.getStructContext().getClass(invocation.getClassName());
            if (cl != null) {
                StructAnnotationAttribute annotations;
                StructMethod mtd = cl.getMethod(invocation.getName(), "([Ljava/lang/Object;)Ljava/lang/Object;");
                if (mtd == null) {
                    mtd = cl.getMethod(invocation.getName(), OBJECT_ARRAY_PARAM + invocation.getDescriptor().ret);
                }
                if (mtd != null && (annotations = mtd.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS)) != null) {
                    for (AnnotationExprent annotation : annotations.getAnnotations()) {
                        if (!annotation.getClassName().equals("java/lang/invoke/MethodHandle$PolymorphicSignature")) continue;
                        MethodDescriptor oldDesc = invocation.getDescriptor();
                        invocation.setStringDescriptor(mtd.getDescriptor());
                        invocation.setDescriptor(MethodDescriptor.parseDescriptor(mtd.getDescriptor()));
                        List<Exprent> params = invocation.getParameters();
                        NewExprent newParam = new NewExprent(VarType.VARTYPE_OBJECT.resizeArrayDim(1), Collections.emptyList(), null);
                        newParam.setLstArrayElements(params);
                        ArrayList<Exprent> newParams = new ArrayList<Exprent>();
                        newParams.add(newParam);
                        invocation.setParameters(newParams);
                        if (!VarType.VARTYPE_VOID.equals(oldDesc.ret)) {
                            ArrayList<Exprent> castExprents = new ArrayList<Exprent>();
                            castExprents.add(invocation);
                            castExprents.add(new ConstExprent(oldDesc.ret, null, null));
                            FunctionExprent cast = new FunctionExprent(29, castExprents, null);
                            return cast;
                        }
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

