/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IVariableNamingFactory;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructContext;

public class DecompilerContext {
    public static final String CURRENT_CLASS = "CURRENT_CLASS";
    public static final String CURRENT_CLASS_WRAPPER = "CURRENT_CLASS_WRAPPER";
    public static final String CURRENT_CLASS_NODE = "CURRENT_CLASS_NODE";
    public static final String CURRENT_METHOD_WRAPPER = "CURRENT_METHOD_WRAPPER";
    public static final String CURRENT_VAR_PROCESSOR = "CURRENT_VAR_PROCESSOR";
    public static final String IN_CLASS_TYPE_PARAMS = "IN_CLASS_TYPE_PARAMS";
    public static final String RENAMER_FACTORY = "RENAMER_FACTORY";
    private final Map<String, Object> properties;
    private final IFernflowerLogger logger;
    private final StructContext structContext;
    private final ClassesProcessor classProcessor;
    private final PoolInterceptor poolInterceptor;
    private final IVariableNamingFactory renamerFactory;
    private final int threads;
    private ImportCollector importCollector;
    private VarProcessor varProcessor;
    private CounterContainer counterContainer;
    private BytecodeSourceMapper bytecodeSourceMapper;
    private static final ThreadLocal<DecompilerContext> currentContext = new ThreadLocal();

    public DecompilerContext(Map<String, Object> properties, int threads, IFernflowerLogger logger, StructContext structContext, ClassesProcessor classProcessor, PoolInterceptor interceptor, IVariableNamingFactory renamerFactory) {
        Objects.requireNonNull(properties);
        Objects.requireNonNull(logger);
        Objects.requireNonNull(structContext);
        Objects.requireNonNull(classProcessor);
        this.properties = properties;
        this.threads = threads;
        this.logger = logger;
        this.structContext = structContext;
        this.classProcessor = classProcessor;
        this.poolInterceptor = interceptor;
        this.renamerFactory = renamerFactory;
        this.counterContainer = new CounterContainer();
    }

    private DecompilerContext(DecompilerContext other) {
        this.properties = new HashMap<String, Object>(other.properties);
        this.logger = other.logger;
        this.structContext = other.structContext;
        this.classProcessor = other.classProcessor;
        this.poolInterceptor = other.poolInterceptor;
        this.renamerFactory = other.renamerFactory;
        this.threads = other.threads;
    }

    public static DecompilerContext getCurrentContext() {
        return currentContext.get();
    }

    public static void setCurrentContext(DecompilerContext context) {
        currentContext.set(context);
    }

    public static void cloneContext(DecompilerContext root) {
        DecompilerContext current = DecompilerContext.getCurrentContext();
        if (current == null) {
            current = new DecompilerContext(root);
            DecompilerContext.setCurrentContext(current);
        }
    }

    public static void setProperty(String key, Object value) {
        DecompilerContext.getCurrentContext().properties.put(key, value);
    }

    public static void startClass(ImportCollector importCollector) {
        DecompilerContext context = DecompilerContext.getCurrentContext();
        context.importCollector = importCollector;
        context.counterContainer = new CounterContainer();
        context.bytecodeSourceMapper = new BytecodeSourceMapper();
    }

    public static void startMethod(VarProcessor varProcessor) {
        DecompilerContext context = DecompilerContext.getCurrentContext();
        context.varProcessor = varProcessor;
        context.counterContainer = new CounterContainer();
    }

    public static Object getProperty(String key) {
        return DecompilerContext.getCurrentContext().properties.get(key);
    }

    public static boolean getOption(String key) {
        return "1".equals(DecompilerContext.getProperty(key));
    }

    public static String getNewLineSeparator() {
        return DecompilerContext.getOption("nls") ? "\n" : "\r\n";
    }

    public static int getThreads() {
        return DecompilerContext.getCurrentContext().threads;
    }

    public static IFernflowerLogger getLogger() {
        return DecompilerContext.getCurrentContext().logger;
    }

    public static StructContext getStructContext() {
        return DecompilerContext.getCurrentContext().structContext;
    }

    public static ClassesProcessor getClassProcessor() {
        return DecompilerContext.getCurrentContext().classProcessor;
    }

    public static PoolInterceptor getPoolInterceptor() {
        return DecompilerContext.getCurrentContext().poolInterceptor;
    }

    public static IVariableNamingFactory getNamingFactory() {
        return DecompilerContext.getCurrentContext().renamerFactory;
    }

    public static ImportCollector getImportCollector() {
        return DecompilerContext.getCurrentContext().importCollector;
    }

    public static VarProcessor getVarProcessor() {
        return DecompilerContext.getCurrentContext().varProcessor;
    }

    public static CounterContainer getCounterContainer() {
        return DecompilerContext.getCurrentContext().counterContainer;
    }

    public static BytecodeSourceMapper getBytecodeSourceMapper() {
        return DecompilerContext.getCurrentContext().bytecodeSourceMapper;
    }
}

