/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.snowblower.Main;
import net.minecraftforge.snowblower.data.Version;
import net.minecraftforge.snowblower.util.HashFunction;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;

public class Util {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)MinecraftVersion.class), (json, typeOfT, context) -> MinecraftVersion.from(json.getAsString())).create();

    public static Path getPath(URI uri) {
        try {
            return Path.of(uri);
        }
        catch (FileSystemNotFoundException e) {
            if (uri.getScheme().equals("jar")) {
                try {
                    FileSystems.newFileSystem(uri, Map.of());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return Path.of(uri);
            }
            throw e;
        }
    }

    public static boolean isDev() {
        return Main.class.getPackage().getImplementationVersion() == null;
    }

    public static Path getSourcePath() {
        Path folderPath = Path.of(Util.getCodeSourceUri());
        while (!Files.exists(folderPath.resolve(".git"), new LinkOption[0])) {
            if ((folderPath = folderPath.getParent()) != null) continue;
            return null;
        }
        return folderPath;
    }

    public static URI getCodeSourceUri() {
        try {
            return Util.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLines(Path target, String ... lines) throws IOException {
        String attrib = String.join((CharSequence)"\n", lines);
        Files.writeString(target, (CharSequence)attrib, new OpenOption[0]);
    }

    public static boolean downloadFile(Consumer<String> logger, Path output, Version version, String key) throws IOException {
        Version.Download download = version.downloads().get(key);
        if (download == null) {
            return false;
        }
        return Util.downloadFile(logger, output, download.url(), download.sha1());
    }

    public static boolean downloadFile(Consumer<String> logger, Path file, URL url, String sha1) throws IOException {
        String actual;
        logger.accept("  Downloading " + url.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.connect();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (InputStream in = connection.getInputStream();
             OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            Util.copy(in, out);
        }
        if (sha1 != null && !(actual = HashFunction.SHA1.hash(file)).equals(sha1)) {
            Files.delete(file);
            throw new IOException("Failed to download " + url + " Invalid Hash:\n    Expected: " + sha1 + "\n    Actual: " + actual);
        }
        return true;
    }

    public static <T> T downloadJson(URL url, Class<T> type) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.connect();
        try (InputStreamReader in = new InputStreamReader(connection.getInputStream());){
            T t = GSON.fromJson((Reader)in, type);
            return t;
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        int cnt;
        byte[] buf = new byte[256];
        while ((cnt = input.read(buf, 0, buf.length)) != -1) {
            output.write(buf, 0, cnt);
        }
    }

    public static void deleteRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walker = Files.walk(dir, new FileVisitOption[0]);){
            walker.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static void commit(Git git, String message, Date time) throws GitAPIException {
        PersonIdent snowblower = new PersonIdent("SnowBlower", "snow@blower.com");
        PersonIdent timed = new PersonIdent(snowblower, time);
        git.commit().setMessage(message).setAuthor(timed).setCommitter(timed).setSign(false).call();
    }

    public static void add(Git git, Path file) throws GitAPIException {
        Path root = git.getRepository().getDirectory().getParentFile().toPath();
        Path path = root.toAbsolutePath().relativize(file.toAbsolutePath());
        git.add().addFilepattern(path.toString()).call();
    }

    public static URL makeURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

