/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.snowblower.util.DependencyHashCache;
import net.minecraftforge.snowblower.util.HashFunction;
import net.minecraftforge.snowblower.util.Util;

public class Cache {
    private final Map<String, String> data = new LinkedHashMap<String, String>();
    private String comment = null;

    public Cache comment(String ... lines) {
        this.comment = lines == null || lines.length == 0 ? null : String.join((CharSequence)"\n", lines);
        return this;
    }

    public Cache put(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    public Cache put(String key, Path path) throws IOException {
        this.data.put(key, HashFunction.SHA1.hash(path));
        return this;
    }

    public Cache put(String key, DependencyHashCache depCache) {
        this.data.put(key, depCache.getHash(key));
        return this;
    }

    public Cache put(Class<?> codeClass) {
        try {
            Path folderPath = Util.getPath(codeClass.getProtectionDomain().getCodeSource().getLocation().toURI());
            String packageName = codeClass.getPackageName();
            String[] packageParts = packageName.split("\\.");
            String keyPrefix = packageName.replace('.', '/') + "/";
            for (String packagePart : packageParts) {
                folderPath = folderPath.resolve(packagePart);
            }
            String className = codeClass.getName().substring(codeClass.getName().lastIndexOf(46) + 1);
            try (Stream<Path> walker = Files.list(folderPath);){
                walker.filter(p -> p.getFileName().toString().startsWith(className) && Files.isRegularFile(p, new LinkOption[0])).forEach(p -> {
                    try {
                        this.put(keyPrefix + p.getFileName().toString(), (Path)p);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void write(Path target) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (this.comment != null) {
            buf.append(this.comment).append("\n\n");
        }
        this.data.forEach((k, v) -> buf.append((String)k).append(": ").append((String)v).append('\n'));
        Files.writeString(target, (CharSequence)buf.toString(), new OpenOption[0]);
    }

    public boolean isValid(Path target) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            return false;
        }
        HashMap existing = new HashMap();
        try (Stream<String> stream = Files.lines(target);){
            stream.forEach(l -> {
                int idx = l.indexOf(32);
                if (idx <= 1 || l.charAt(idx - 1) != ':') {
                    return;
                }
                String key = l.substring(0, idx - 1);
                String value = l.substring(idx + 1);
                existing.put(key, value);
            });
        }
        return existing.equals(this.data);
    }
}

