/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower.data;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.snowblower.util.Util;
import net.minecraftforge.srgutils.MinecraftVersion;

public record Version(MinecraftVersion id, Date time, Date releaseTime, String type, Map<String, Download> downloads, List<Library> libraries, JavaVersion javaVersion) {
    public static Version query(URL url) throws IOException {
        return Util.downloadJson(url, Version.class);
    }

    public static Version load(Path file) throws IOException {
        try (InputStreamReader in = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]));){
            Version version = Util.GSON.fromJson((Reader)in, Version.class);
            return version;
        }
    }

    public record JavaVersion(int majorVersion) {
    }

    public record Library(Map<String, Download> downloads, String name, Map<String, ?>[] rules) implements Comparable<Library>
    {
        @Override
        public int compareTo(Library o) {
            return this.name.compareTo(o.name);
        }

        public boolean isAllowed() {
            if (this.rules == null || this.rules.length == 0) {
                return true;
            }
            for (Map<String, ?> rule : this.rules) {
                boolean matched = true;
                Object obj = rule.get("action");
                if (!(obj instanceof String)) {
                    return false;
                }
                String action = (String)obj;
                if (rule.get("os") instanceof Map) {
                    Object v;
                    Map os = (Map)rule.get("os");
                    if (matched && (v = os.get("name")) instanceof String) {
                        String osName = (String)v;
                        matched = Library.getOsName().equals(osName);
                    }
                    if (matched && (v = os.get("version")) instanceof String) {
                        String osVersion = (String)v;
                        matched = Pattern.compile(osVersion).matcher(System.getProperty("os.version")).find();
                    }
                    if (matched && (v = os.get("arch")) instanceof String) {
                        String osArch = (String)v;
                        matched = Pattern.compile(osArch).matcher(System.getProperty("os.arch")).find();
                    }
                }
                if (!matched || !"allow".equals(action)) continue;
                return true;
            }
            return false;
        }

        private static String getOsName() {
            String name = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            if (name.contains("windows") || name.contains("win")) {
                return "windows";
            }
            if (name.contains("linux") || name.contains("unix")) {
                return "linux";
            }
            if (name.contains("osx") || name.contains("mac")) {
                return "osx";
            }
            return "unknown";
        }
    }

    public record Download(String path, String sha1, int size, URL url) {
    }
}

