/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.snowblower.Generator;
import net.minecraftforge.snowblower.data.Config;
import net.minecraftforge.snowblower.util.DependencyHashCache;
import net.minecraftforge.snowblower.util.Util;
import net.minecraftforge.srgutils.MinecraftVersion;

public class Main {
    public static void main(String[] args) throws Exception {
        Config cfg;
        MinecraftVersion targetVer;
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "Output directory to put the git directory in").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Cache directory to hold all files related to a version. If omitted, goes to ./cache").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> extraMappingsO = parser.accepts("extra-mappings", "When set, points to a directory with extra mappings files").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<String> startVerO = parser.accepts("start-ver", "The starting Minecraft version to generate from (inclusive). If omitted, defaultys to oldest while respecting --releases-only").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> targetVerO = parser.accepts("target-ver", "The target Minecraft version to generate up to (inclusive). If omitted, defaults to latest while respecting --releases-only").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> branchNameO = parser.acceptsAll(List.of("branch-name", "branch"), "The Git branch name, creating an orphan branch if it does not exist. Uses checked out branch if omitted").withRequiredArg();
        OptionSpecBuilder releasesOnlyO = parser.accepts("releases-only", "When set, only release versions will be considered");
        OptionSpecBuilder startOverO = parser.accepts("start-over", "Whether to start over by deleting the target branch");
        ArgumentAcceptingOptionSpec<URI> configO = parser.accepts("cfg", "Config file for SnowBlower").withRequiredArg().ofType(URI.class);
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            System.err.println("Error: " + ex.getMessage());
            System.err.println();
            parser.printHelpOn(System.err);
            System.exit(1);
            return;
        }
        URL depHashCacheUrl = Main.class.getResource("/dependency_hashes.txt");
        if (depHashCacheUrl == null) {
            throw new IllegalStateException("Could not find dependency_hashes.txt on classpath");
        }
        DependencyHashCache depCache = DependencyHashCache.load(Util.getPath(depHashCacheUrl.toURI()));
        File output = options.valueOf(outputO);
        File cache = options.valueOf(cacheO);
        Path cachePath = cache == null ? Paths.get("cache", new String[0]) : cache.toPath();
        File extraMappings = options.valueOf(extraMappingsO);
        Path extraMappingsPath = extraMappings == null ? null : extraMappings.toPath();
        boolean startOver = options.has(startOverO);
        MinecraftVersion startVer = options.has(startVerO) ? MinecraftVersion.from(options.valueOf(startVerO)) : null;
        MinecraftVersion minecraftVersion = targetVer = options.has(targetVerO) ? MinecraftVersion.from(options.valueOf(targetVerO)) : null;
        if (targetVer != null && targetVer.compareTo(startVer) < 0) {
            throw new IllegalArgumentException("Target version must be greater than or equal to start version");
        }
        Config.BranchSpec cliBranch = new Config.BranchSpec(options.has(releasesOnlyO) ? "release" : "all", startVer, targetVer, null);
        String branchName = options.valueOf(branchNameO);
        if (options.has(configO)) {
            URI configUri = options.valueOf(configO);
            try {
                URL url = configUri.toURL();
                cfg = Util.downloadJson(url, Config.class);
            }
            catch (MalformedURLException e) {
                cfg = Config.load(Util.getPath(configUri));
            }
        } else {
            HashMap<String, Config.BranchSpec> branches = new HashMap<String, Config.BranchSpec>();
            branches.put("release", new Config.BranchSpec("release", null, null, null));
            branches.put("dev", new Config.BranchSpec("all", null, null, null));
            cfg = new Config(branches);
        }
        try (Generator gen = new Generator(output.toPath(), cachePath, extraMappingsPath, depCache);){
            gen.setup(branchName, cfg, cliBranch, startOver);
            gen.run();
        }
    }
}

