/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.snowblower;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fart.api.IdentifierFixerConfig;
import net.minecraftforge.fart.api.Renamer;
import net.minecraftforge.fart.api.SignatureStripperConfig;
import net.minecraftforge.fart.api.SourceFixerConfig;
import net.minecraftforge.fart.api.Transformer;
import net.minecraftforge.snowblower.data.Config;
import net.minecraftforge.snowblower.data.Version;
import net.minecraftforge.snowblower.data.VersionManifestV2;
import net.minecraftforge.snowblower.tasks.MappingTask;
import net.minecraftforge.snowblower.tasks.MergeTask;
import net.minecraftforge.snowblower.tasks.enhance.EnhanceVersionTask;
import net.minecraftforge.snowblower.tasks.init.InitTask;
import net.minecraftforge.snowblower.util.Cache;
import net.minecraftforge.snowblower.util.DependencyHashCache;
import net.minecraftforge.snowblower.util.HashFunction;
import net.minecraftforge.snowblower.util.Util;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;

public class Generator
implements AutoCloseable {
    private final Path output;
    private final Path cache;
    private final Path extraMappings;
    private final DependencyHashCache depCache;
    private final Consumer<String> logger = System.out::println;
    private Git git;
    private Config.BranchSpec branch;

    public Generator(Path output, Path cache, Path extraMappings, DependencyHashCache depCache) {
        this.output = output.toAbsolutePath();
        this.cache = cache.toAbsolutePath();
        this.extraMappings = extraMappings == null ? null : extraMappings.toAbsolutePath();
        this.depCache = depCache;
    }

    public Generator setup(String branchName, Config cfg, Config.BranchSpec cliBranch, boolean fresh) throws IOException, GitAPIException {
        Config.BranchSpec cfgBranch;
        try {
            this.git = Git.open(this.output.toFile());
            String currentBranch = this.git.getRepository().getBranch();
            if (branchName == null) {
                if (currentBranch == null) {
                    throw new IllegalStateException("Git repository has no HEAD reference");
                }
                branchName = currentBranch;
            }
            boolean exists = this.git.getRepository().resolve(branchName) != null;
            boolean temp = false;
            if (fresh && exists) {
                if (branchName.equals(currentBranch)) {
                    this.git.checkout().setOrphan(true).setName("orphan_temp").call();
                    temp = true;
                }
                this.git.branchDelete().setBranchNames(branchName).setForce(true).call();
                exists = false;
                this.git.checkout().setOrphan(true).setName(branchName).call();
            } else if (!branchName.equals(currentBranch)) {
                this.git.checkout().setOrphan(!exists).setName(branchName).call();
            }
            this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
            this.git.clean().setCleanDirectories(true).call();
            if (temp) {
                this.git.branchDelete().setBranchNames("orphan_temp").setForce(true).call();
            }
        }
        catch (RepositoryNotFoundException e) {
            if (branchName == null) {
                branchName = "release";
            }
            Util.deleteRecursive(this.output);
            this.git = Git.init().setDirectory(this.output.toFile()).setInitialBranch(branchName).call();
        }
        Config.BranchSpec branchSpec = cfgBranch = cfg.branches() == null ? null : cfg.branches().get(branchName);
        if (cfgBranch == null) {
            if (cliBranch.start() == null && cliBranch.end() == null && cliBranch.versions() == null) {
                throw new IllegalArgumentException("Unknown branch config: " + branchName);
            }
            this.branch = cliBranch;
        } else {
            this.branch = new Config.BranchSpec(cfgBranch.type(), cliBranch.start() == null ? cfgBranch.start() : cliBranch.start(), cliBranch.end() == null ? cfgBranch.end() : cliBranch.end(), cfgBranch.versions());
        }
        return this;
    }

    public void run() throws IOException, GitAPIException {
        MinecraftVersion startVer;
        InitTask init = new InitTask(this.logger, this.output, this.git);
        VersionManifestV2 manifest = VersionManifestV2.query();
        if (manifest.versions() == null) {
            throw new IllegalStateException("Failed to find versions, manifest mising versions listing");
        }
        List<VersionManifestV2.VersionInfo> versions = Arrays.asList(manifest.versions());
        MinecraftVersion targetVer = this.branch.end();
        if (this.branch.versions() != null) {
            versions = versions.stream().filter(v -> this.branch.versions().contains(v.id())).toList();
            if (targetVer == null) {
                targetVer = versions.get(0).id();
            }
        }
        if (targetVer == null) {
            VersionManifestV2.LatestInfo lat = manifest.latest();
            if (lat == null) {
                throw new IllegalStateException("Failed to determine latest version, Manifest does not contain latest entries");
            }
            if (this.branch.type().equals("release")) {
                targetVer = lat.release();
            } else {
                VersionManifestV2.VersionInfo release = versions.stream().filter(e -> !lat.release().equals(e.id())).findFirst().orElse(null);
                VersionManifestV2.VersionInfo snapshot = versions.stream().filter(e -> !lat.snapshot().equals(e.id())).findFirst().orElse(null);
                if (release == null && snapshot == null) {
                    throw new IllegalStateException("Failed to find latest, manifest specified " + lat.release() + " and " + lat.snapshot() + " and both are missing");
                }
                if (release == null) {
                    targetVer = snapshot.id();
                } else if (snapshot == null) {
                    targetVer = release.id();
                } else {
                    MinecraftVersion minecraftVersion = targetVer = snapshot.releaseTime().compareTo(release.releaseTime()) > 0 ? snapshot.id() : release.id();
                }
            }
        }
        if ((startVer = this.branch.start()) == null) {
            startVer = versions.get(versions.size() - 1).id();
        }
        if (!init.validate(startVer)) {
            return;
        }
        int startIdx = -1;
        int endIdx = -1;
        for (int i = 0; i < versions.size(); ++i) {
            MinecraftVersion ver = versions.get(i).id();
            if (ver.equals(targetVer)) {
                endIdx = i;
            }
            if (!ver.equals(startVer)) continue;
            startIdx = i;
            break;
        }
        if (startIdx == -1 || endIdx == -1) {
            throw new IllegalStateException("Could not find start and/or end version in version manifest (or they were out of order)");
        }
        List<VersionManifestV2.VersionInfo> toGenerate = new ArrayList<VersionManifestV2.VersionInfo>(versions.subList(endIdx, startIdx + 1));
        if (this.branch.type().equals("release")) {
            toGenerate.removeIf(v -> !v.type().equals("release"));
        }
        Collections.reverse(toGenerate);
        String lastVersion = Generator.getLastVersion(this.git);
        if (lastVersion != null && !init.isInitCommit(lastVersion)) {
            boolean found = false;
            for (int i = 0; i < toGenerate.size(); ++i) {
                if (!toGenerate.get(i).id().toString().equals(lastVersion)) continue;
                toGenerate = toGenerate.subList(i + 1, toGenerate.size());
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("Git is in invalid state, latest commit is " + lastVersion + " but it is not in our version list");
            }
        }
        toGenerate = Generator.findVersionsWithMappings(this.logger, toGenerate, this.cache, this.extraMappings);
        Path libs = this.cache.resolve("libraries");
        for (int x = 0; x < toGenerate.size(); ++x) {
            VersionManifestV2.VersionInfo versionInfo = toGenerate.get(x);
            Path versionCache = this.cache.resolve(versionInfo.id().toString());
            Files.createDirectories(versionCache, new FileAttribute[0]);
            this.logger.accept("[" + (x + 1) + "/" + toGenerate.size() + "] Generating " + versionInfo.id());
            Version version = Version.load(versionCache.resolve("version.json"));
            this.generate(this.logger, this.git, this.output, versionCache, libs, version, this.extraMappings, this.depCache);
        }
        if (toGenerate.isEmpty()) {
            this.logger.accept("No versions to process");
        }
    }

    private static List<VersionManifestV2.VersionInfo> findVersionsWithMappings(Consumer<String> logger, List<VersionManifestV2.VersionInfo> versions, Path cache, Path extraMappings) throws IOException {
        logger.accept("Downloading version manifests");
        ArrayList<VersionManifestV2.VersionInfo> ret = new ArrayList<VersionManifestV2.VersionInfo>();
        for (VersionManifestV2.VersionInfo ver : versions) {
            Map<String, Version.Download> dls;
            Path json = cache.resolve(ver.id().toString()).resolve("version.json");
            if (!Files.exists(json, new LinkOption[0]) || !HashFunction.SHA1.hash(json).equals(ver.sha1())) {
                Util.downloadFile(logger, json, ver.url(), ver.sha1());
            }
            if ((dls = Version.load(json).downloads()).containsKey("client_mappings") && dls.containsKey("server_mappings")) {
                ret.add(ver);
                continue;
            }
            if (extraMappings == null) continue;
            Path root = extraMappings.resolve(ver.type()).resolve(ver.id().toString()).resolve("maps");
            Path client = root.resolve("client.txt");
            Path server = root.resolve("server.txt");
            if (!Files.exists(client, new LinkOption[0]) || !Files.exists(server, new LinkOption[0])) continue;
            ret.add(ver);
        }
        return ret;
    }

    private static String getLastVersion(Git git) throws IOException, GitAPIException {
        ObjectId headId = git.getRepository().resolve("HEAD");
        if (headId == null) {
            return null;
        }
        Iterator iterator = git.log().add(headId).call().iterator();
        while (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            if (!commit.getCommitterIdent().getName().equalsIgnoreCase("SnowBlower")) continue;
            return commit.getShortMessage();
        }
        return null;
    }

    private void generate(Consumer<String> logger, Git git, Path output, Path cache, Path libCache, Version version, Path extraMappings, DependencyHashCache depCache) throws IOException, GitAPIException {
        Set<Object> existingFiles;
        Path mappings = MappingTask.getMergedMappings(logger, cache, version, extraMappings);
        if (mappings == null) {
            return;
        }
        Path joined = MergeTask.getJoinedJar(logger, cache, version, mappings, depCache);
        List<Path> libs = this.getLibraries(libCache, version);
        Path renamed = this.getRenamedJar(cache, joined, mappings, libCache, libs);
        Path decomped = this.getDecompiledJar(cache, renamed, libCache, libs);
        Path src = output.resolve("src").resolve("main");
        if (Files.exists(src, new LinkOption[0])) {
            try (Stream<Path> walker = Files.walk(src, new FileVisitOption[0]);){
                existingFiles = walker.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toSet());
            }
        } else {
            existingFiles = new HashSet();
        }
        Path java = src.resolve("java");
        Path resources = src.resolve("resources");
        ArrayList<Path> added = new ArrayList<Path>();
        ArrayList removed = new ArrayList();
        try (FileSystem zipFs = FileSystems.newFileSystem(decomped);){
            Path root = zipFs.getPath("/", new String[0]);
            try (Stream<Path> walker = Files.walk(root, new FileVisitOption[0]);){
                walker.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                    try {
                        Path relative = root.relativize((Path)p);
                        Path target = (p.toString().endsWith(".java") ? java : resources).resolve(relative.toString());
                        if (existingFiles.remove(target)) {
                            boolean copy;
                            Path realPath = target.toRealPath(LinkOption.NOFOLLOW_LINKS);
                            if (!realPath.toString().equals(target.toString())) {
                                Files.delete(realPath);
                                removed.add(realPath);
                                added.add(target);
                                copy = true;
                            } else {
                                String created;
                                String existing = HashFunction.MD5.hash(target);
                                boolean bl = copy = !existing.equals(created = HashFunction.MD5.hash((Path)p));
                            }
                            if (copy) {
                                Files.copy(p, target, StandardCopyOption.REPLACE_EXISTING);
                                added.add(target);
                            }
                        } else {
                            Files.createDirectories(target.getParent(), new FileAttribute[0]);
                            Files.copy(p, target, StandardCopyOption.REPLACE_EXISTING);
                            added.add(target);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<Path> enhanced = EnhanceVersionTask.enhance(output, version);
        existingFiles.removeAll(enhanced);
        added.addAll(enhanced);
        existingFiles.stream().sorted().forEach(p -> {
            try {
                Files.delete(p);
                removed.add(p);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.logger.accept("  Committing files");
            Function<Path, String> convert = p -> output.relativize((Path)p).toString().replace('\\', '/');
            if (!added.isEmpty()) {
                AddCommand add = git.add();
                added.stream().map(convert).forEach(add::addFilepattern);
                add.call();
            }
            if (!removed.isEmpty()) {
                RmCommand rm = git.rm();
                removed.stream().map(convert).forEach(rm::addFilepattern);
                rm.call();
            }
            Util.commit(git, version.id().toString(), version.releaseTime());
        }
    }

    private List<Path> getLibraries(Path cache, Version version) throws IOException {
        if (version.libraries() == null) {
            return Collections.emptyList();
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        for (Version.Library lib : version.libraries()) {
            if (lib.downloads() == null || !lib.downloads().containsKey("artifact")) continue;
            Version.Download dl = lib.downloads().get("artifact");
            Path target = cache.resolve(dl.path());
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Util.downloadFile(this.logger, target, dl.url(), dl.sha1());
            }
            ret.add(target);
        }
        return ret;
    }

    private Path getRenamedJar(Path cache, Path joined, Path mappings, Path libCache, List<Path> libs) throws IOException {
        Cache key = new Cache().put("net.minecraftforge:ForgeAutoRenamingTool", this.depCache).put("joined", joined).put("map", mappings);
        for (Path lib : libs) {
            Path relative = libCache.relativize(lib);
            key.put(relative.toString(), lib);
        }
        Path keyF = cache.resolve("joined-renamed.jar.cache");
        Path ret = cache.resolve("joined-renamed.jar");
        if (!Files.exists(ret, new LinkOption[0]) || !key.isValid(keyF)) {
            this.logger.accept("  Renaming joined jar");
            Renamer.Builder builder = Renamer.builder().input(joined.toFile()).output(ret.toFile()).map(mappings.toFile()).add(Transformer.parameterAnnotationFixerFactory()).add(Transformer.identifierFixerFactory(IdentifierFixerConfig.ALL)).add(Transformer.sourceFixerFactory(SourceFixerConfig.JAVA)).add(Transformer.recordFixerFactory()).add(Transformer.signatureStripperFactory(SignatureStripperConfig.ALL)).logger(s -> {});
            libs.forEach(l -> builder.lib(l.toFile()));
            builder.build().run();
            key.write(keyF);
        }
        return ret;
    }

    private Path getDecompiledJar(Path cache, Path renamed, Path libCache, List<Path> libs) throws IOException {
        Cache key = new Cache().put("net.minecraftforge:forgeflower", this.depCache).put("renamed", renamed);
        CharSequence[] decompileArgs = new String[]{"-din=1", "-rbr=1", "-dgs=1", "-asc=1", "-rsy=1", "-iec=1", "-jvn=1", "-jpr=1", "-isl=0", "-iib=1", "-bsm=1", "-dcl=1"};
        key.put("decompileArgs", String.join((CharSequence)" ", decompileArgs));
        for (Path lib : libs) {
            Path relative = libCache.relativize(lib);
            key.put(relative.toString(), lib);
        }
        Path keyF = cache.resolve("joined-decompiled.jar.cache");
        Path ret = cache.resolve("joined-decompiled.jar");
        if (!Files.exists(ret, new LinkOption[0]) || !key.isValid(keyF)) {
            this.logger.accept("  Decompiling joined-renamed.jar");
            Path cfg = cache.resolve("joined-libraries.cfg");
            Util.writeLines(cfg, (String[])libs.stream().map(l -> "-e=" + l.toString()).toArray(String[]::new));
            ConsoleDecompiler.main((String[])Stream.concat(Arrays.stream(decompileArgs), Stream.of("-log=ERROR", "-cfg", cfg.toString(), renamed.toString(), ret.toString())).toArray(String[]::new));
            key.write(keyF);
        }
        return ret;
    }

    @Override
    public void close() throws Exception {
        if (this.git != null) {
            this.git.close();
        }
    }
}

