/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mercurius.updater;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.mercurius.updater.LogHelper;
import net.minecraftforge.mercurius.updater.Utils;

@Mod(modid="mercurius_updater", version="1.0", acceptedMinecraftVersions="[1.10.2]")
public class MercuriusUpdaterMod {
    private Class loadedMercurius;
    private Object loadedMercuriusInstance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        if (Loader.isModLoaded((String)"mercurius")) {
            LogHelper.info("Normal Mercurius found, disabeling stub");
            return;
        }
        File librariesDir = Utils.findMaven(MinecraftForge.class, e.getSide() == Side.CLIENT);
        if (librariesDir == null) {
            return;
        }
        File libFile = Utils.updateMercurius(librariesDir, "1.9.4");
        if (libFile == null) {
            LogHelper.fatal("Mercurius Updating failed");
            return;
        }
        try {
            URLClassLoader cl = URLClassLoader.newInstance(new URL[]{libFile.toURI().toURL()}, MercuriusUpdaterMod.class.getClassLoader());
            this.loadedMercurius = cl.loadClass("net.minecraftforge.mercurius.StatsMod");
            this.loadedMercuriusInstance = this.loadedMercurius.newInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.invokeEvent("preInit", (FMLEvent)e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        this.invokeEvent("init", (FMLEvent)e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        this.invokeEvent("postInit", (FMLEvent)e);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        this.invokeEvent("serverStarting", (FMLEvent)e);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent e) {
        this.invokeEvent("serverStopping", (FMLEvent)e);
    }

    private void invokeEvent(String name, FMLEvent event) {
        if (this.loadedMercurius == null) {
            return;
        }
        try {
            ReflectionHelper.findMethod((Class)this.loadedMercurius, (Object)this.loadedMercuriusInstance, (String[])new String[]{name}, (Class[])new Class[]{event.getClass()}).invoke(this.loadedMercuriusInstance, event);
        }
        catch (ReflectionHelper.UnableToFindMethodException unableToFindMethodException) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

